/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.logging.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogConfigurationException;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.logging.impl.MyPrivilegedAction;

public class LogFactoryImpl
extends LogFactory {
    public static final String LOG_DEFAULT = "org.logicalcobwebs.logging.impl.SimpleLog";
    public static final String LOG_PROPERTY = "org.logicalcobwebs.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "org.apache.commons.logging.log";
    private Hashtable attributes = new Hashtable();
    private Hashtable instances = new Hashtable();
    private Constructor logConstructor = null;
    private LogFactory proxyFactory = null;
    private Class[] logConstructorSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LogFactoryImpl.class$("java.lang.String")) : class$java$lang$String};
    private Method logMethod = null;
    private Class[] logMethodSignature = new Class[]{class$org$logicalcobwebs$logging$LogFactory == null ? (class$org$logicalcobwebs$logging$LogFactory = LogFactoryImpl.class$("org.logicalcobwebs.logging.LogFactory")) : class$org$logicalcobwebs$logging$LogFactory};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$logicalcobwebs$logging$LogFactory;
    static /* synthetic */ Class class$org$logicalcobwebs$logging$Log;

    public LogFactoryImpl() {
        this.guessConfig();
    }

    public Object getAttribute(String name) {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getAttribute(name);
        }
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getAttributeNames();
        }
        Vector names = new Vector();
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            names.addElement(keys.nextElement());
        }
        String[] results = new String[names.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (String)names.elementAt(i);
        }
        return results;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getInstance(clazz);
        }
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String name) throws LogConfigurationException {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getInstance(name);
        }
        Log instance = (Log)this.instances.get(name);
        if (instance == null) {
            instance = this.newInstance(name);
            this.instances.put(name, instance);
        }
        return instance;
    }

    public void release() {
        if (this.proxyFactory != null) {
            this.proxyFactory.release();
        }
        this.instances.clear();
    }

    public void removeAttribute(String name) {
        if (this.proxyFactory != null) {
            this.proxyFactory.removeAttribute(name);
        }
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.proxyFactory != null) {
            this.proxyFactory.setAttribute(name, value);
        }
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    protected Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor != null) {
            return this.logConstructor;
        }
        String logClassName = null;
        if (logClassName == null) {
            logClassName = (String)this.getAttribute(LOG_PROPERTY);
        }
        if (logClassName == null) {
            logClassName = (String)this.getAttribute(LOG_PROPERTY_OLD);
        }
        if (logClassName == null) {
            try {
                logClassName = System.getProperty(LOG_PROPERTY);
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        if (logClassName == null) {
            try {
                logClassName = System.getProperty(LOG_PROPERTY_OLD);
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        if (logClassName == null && this.isLog4JAvailable()) {
            logClassName = "org.logicalcobwebs.logging.impl.Log4JCategoryLog";
        }
        if (logClassName == null && this.isJdk14Available()) {
            logClassName = "org.logicalcobwebs.logging.impl.Jdk14Logger";
        }
        if (logClassName == null) {
            logClassName = LOG_DEFAULT;
        }
        Class logClass = null;
        try {
            logClass = LogFactoryImpl.loadClass(logClassName);
            if (logClass == null) {
                throw new LogConfigurationException("No suitable Log implementation for " + logClassName);
            }
            if (!(class$org$logicalcobwebs$logging$Log == null ? (class$org$logicalcobwebs$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$logicalcobwebs$logging$Log).isAssignableFrom(logClass)) {
                throw new LogConfigurationException("Class " + logClassName + " does not implement Log");
            }
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
        try {
            this.logMethod = logClass.getMethod("setLogFactory", this.logMethodSignature);
        }
        catch (Throwable t) {
            this.logMethod = null;
        }
        try {
            this.logConstructor = logClass.getConstructor(this.logConstructorSignature);
            return this.logConstructor;
        }
        catch (Throwable t) {
            throw new LogConfigurationException("No suitable Log constructor " + this.logConstructorSignature + " for " + logClassName, t);
        }
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader threadCL = LogFactoryImpl.getContextClassLoader();
        Object result = AccessController.doPrivileged(new MyPrivilegedAction(threadCL, name));
        if (result instanceof Class) {
            return (Class)result;
        }
        throw (ClassNotFoundException)result;
    }

    protected void guessConfig() {
        if (this.isLog4JAvailable()) {
            this.proxyFactory = null;
            try {
                Class proxyClass = LogFactoryImpl.loadClass("org.logicalcobwebs.logging.impl.Log4jFactory");
                if (proxyClass != null) {
                    this.proxyFactory = (LogFactory)proxyClass.newInstance();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected boolean isJdk14Available() {
        try {
            LogFactoryImpl.loadClass("java.util.logging.Logger");
            LogFactoryImpl.loadClass("org.logicalcobwebs.logging.impl.Jdk14Logger");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected boolean isLog4JAvailable() {
        try {
            LogFactoryImpl.loadClass("org.apache.log4j.Category");
            LogFactoryImpl.loadClass("org.logicalcobwebs.logging.impl.Log4JCategoryLog");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected Log newInstance(String name) throws LogConfigurationException {
        Log instance = null;
        try {
            Object[] params = new Object[]{name};
            instance = (Log)this.getLogConstructor().newInstance(params);
            if (this.logMethod != null) {
                params[0] = this;
                this.logMethod.invoke((Object)instance, params);
            }
            return instance;
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

