/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.model;

import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.fabrica.NumeroFactory;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.infra.model.Model;
import br.com.politec.infra.seguranca.ControladorDeAcesso;
import br.com.politec.infra.util.UtilLog;

public abstract class ModelAbstrato
implements Model {
    private ControladorDeAcesso controladorDeAcesso;
    private boolean transacaoCompartilhada;

    public void setTransacaoCompartilhada(boolean transacaoCompartilhada) {
        this.transacaoCompartilhada = transacaoCompartilhada;
    }

    protected abstract ControladorDeAcesso novoControladorDeAcesso();

    protected void iniciarTransacao() {
        this.getControladorDeAcesso().iniciarTransacao();
    }

    protected void finalizarTransacao() {
        if (!this.isTransacaoCompartilhada()) {
            this.getControladorDeAcesso().finalizarTransacao();
        }
    }

    protected void commitTransacao() {
        if (!this.isTransacaoCompartilhada()) {
            this.getControladorDeAcesso().commitTransacao();
        }
    }

    protected void rollbackTransacao() {
        if (!this.isTransacaoCompartilhada()) {
            this.getControladorDeAcesso().rollbackTransacao();
        }
    }

    protected ControladorDeAcesso getControladorDeAcesso() {
        this.debugInit("getControladorDeAcesso");
        if (!this.isReferencia(this.controladorDeAcesso)) {
            this.controladorDeAcesso = this.novoControladorDeAcesso();
        }
        this.getLog().debug("ControladorDeAcesso: " + this.controladorDeAcesso);
        this.debugEnd("getControladorDeAcesso");
        return this.controladorDeAcesso;
    }

    protected boolean isTransacaoCompartilhada() {
        return this.transacaoCompartilhada;
    }

    protected NumeroFactory getNumeroFactory() {
        return NumeroFactory.getInstance();
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    protected DataFactory getDataFactory() {
        return DataFactory.getInstance();
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected void debugInit(String metodo) {
        this.getLog().debugInit(this.getClass(), metodo);
    }

    protected void debugEnd(String metodo) {
        this.getLog().debugEnd(this.getClass(), metodo);
    }

    protected LogAbstrato getLog() {
        return UtilLog.getLog();
    }
}

