/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.servicelocator;

import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.infra.servicelocator.IServiceLocator;
import br.com.politec.infra.servicelocator.IServiceLocatorFactory;
import br.com.politec.infra.servicelocator.ServiceLocator;
import br.com.politec.infra.servicelocator.ServiceLocatorAbstrato;
import br.com.politec.infra.util.excecao.UtilServiceLocatorException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class ServiceLocatorFactory
implements IServiceLocatorFactory {
    private static ServiceLocatorFactory instancia = new ServiceLocatorFactory();

    private ServiceLocatorFactory() {
    }

    public static ServiceLocatorFactory getInstancia() {
        return instancia;
    }

    public IServiceLocator novoServiceLocator() {
        ServiceLocator locator = new ServiceLocator();
        locator.setContexto(this.novoContexto());
        return locator;
    }

    public IServiceLocator novoServiceLocator(Context contexto) {
        ServiceLocatorAbstrato locator = new ServiceLocator();
        locator = (ServiceLocatorAbstrato)this.novoServiceLocator();
        locator.setContexto(contexto);
        return locator;
    }

    public IServiceLocator novoServiceLocator(Properties properties, boolean cache) {
        ServiceLocatorAbstrato locator = null;
        locator = (ServiceLocatorAbstrato)this.novoServiceLocator();
        locator.setContexto(this.novoContexto(properties));
        locator.setCache(cache);
        return null;
    }

    public Context novoContexto() {
        InitialContext contexto;
        try {
            contexto = new InitialContext();
        }
        catch (NamingException e) {
            throw UtilServiceLocatorException.erroAoCriarContexto(e);
        }
        return contexto;
    }

    public Context novoContexto(Properties properties) {
        Context contexto = this.novoContexto();
        try {
            if (UtilObjeto.isReferencia(properties)) {
                contexto = new InitialContext(properties);
            }
        }
        catch (NamingException e) {
            throw UtilServiceLocatorException.erroAoCriarContexto(e);
        }
        return contexto;
    }
}

