/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.taglib;

import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.infra.util.excecao.UtilInfraException;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class InfraTagSupportAbstrato
extends BodyTagSupport {
    protected void println(String texto) throws JspException {
        try {
            if (!UtilString.isVazio(texto)) {
                this.getOut().println(texto);
            }
        }
        catch (IOException e) {
            throw UtilInfraException.erroAoImprimirTag(texto, e);
        }
    }

    protected void print(String texto) throws JspException {
        try {
            if (!UtilString.isVazio(texto)) {
                this.getOut().print(texto);
            }
        }
        catch (IOException e) {
            throw UtilInfraException.erroAoImprimirTag(texto, e);
        }
    }

    protected void include(String pathDaPagina) throws JspException {
        try {
            this.getPageContext().include(pathDaPagina);
        }
        catch (ServletException e) {
            throw UtilInfraException.erroAoImprimirTag(pathDaPagina, e);
        }
        catch (IOException e) {
            throw UtilInfraException.erroAoImprimirTag(pathDaPagina, e);
        }
    }

    protected void forward(String pathDaPagina) throws JspException {
        try {
            this.getPageContext().forward(pathDaPagina);
        }
        catch (ServletException e) {
            throw UtilInfraException.erroAoImprimirTag(pathDaPagina, e);
        }
        catch (IOException e) {
            throw UtilInfraException.erroAoImprimirTag(pathDaPagina, e);
        }
    }

    protected HttpSession getSession() {
        return this.getPageContext().getSession();
    }

    protected JspWriter getOut() {
        JspWriter out = this.getEnclosingWriter();
        if (!UtilObjeto.isReferencia(out)) {
            out = this.getPageContext().getOut();
        }
        return out;
    }

    protected JspWriter getEnclosingWriter() {
        JspWriter out = null;
        if (UtilObjeto.isReferencia(this.getBodyContent())) {
            out = this.getBodyContent().getEnclosingWriter();
        }
        return out;
    }

    protected HttpServletResponse getResponse() {
        return (HttpServletResponse)this.getPageContext().getResponse();
    }

    protected HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getPageContext().getRequest();
    }

    protected PageContext getPageContext() {
        return this.pageContext;
    }

    protected ServletContext getServletContext() {
        return this.getPageContext().getServletContext();
    }

    protected String getString() {
        String resultado = null;
        BodyContent bc = this.getBodyContent();
        if (this.isReferencia(bc)) {
            resultado = bc.getString();
        }
        return resultado;
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }
}

