/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.util;

import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class UtilWeb {
    private UtilWeb() {
    }

    public static String getContexto(HttpServletRequest request) {
        String contexto = null;
        if (UtilWeb.isReferencia(request)) {
            contexto = request.getContextPath() + "/";
        }
        return contexto;
    }

    public static String getPrimeiroContexto(HttpServletRequest request) {
        String contexto = null;
        if (UtilWeb.isReferencia(request)) {
            contexto = request.getContextPath();
            int inicio = 0;
            int fim = contexto.lastIndexOf("/") + 1;
            contexto = UtilString.substring(contexto, inicio, fim);
        }
        return contexto;
    }

    public static String getURISemContexto(HttpServletRequest request) {
        String uri = null;
        if (UtilWeb.isReferencia(request)) {
            String contexto = request.getContextPath();
            uri = request.getRequestURI();
            uri = UtilString.remover(uri, contexto);
        }
        return uri;
    }

    public static String getURLSemContexto(HttpServletRequest request) {
        String url = null;
        if (UtilWeb.isReferencia(request)) {
            String contexto = request.getContextPath();
            url = request.getRequestURL().toString();
            url = UtilString.remover(url, contexto);
        }
        return url;
    }

    public static String getPaginaDaURL(HttpServletRequest request) {
        String url = null;
        if (UtilWeb.isReferencia(request)) {
            url = request.getRequestURL().toString();
            String contexto = request.getContextPath();
            url = UtilString.remover(url, contexto);
            url = UtilString.substring(url, url.lastIndexOf("/"), url.length());
            url = contexto + url;
        }
        return url;
    }

    public static HttpSession getSessao(HttpServletRequest request) {
        HttpSession sessao = null;
        if (UtilWeb.isReferencia(request)) {
            sessao = request.getSession();
        }
        return sessao;
    }

    public static HttpSession getSessao(HttpServletRequest request, boolean novaSessao) {
        HttpSession sessao = null;
        if (UtilWeb.isReferencia(request)) {
            sessao = request.getSession(novaSessao);
        }
        return sessao;
    }

    public static HttpSession getSessao(ServletRequest request, boolean novaSessao) {
        HttpSession sessao = null;
        if (UtilWeb.isReferencia(request)) {
            sessao = UtilWeb.getRequest(request).getSession(novaSessao);
        }
        return sessao;
    }

    public static HttpServletRequest getRequest(ServletRequest servletRequest) {
        HttpServletRequest request = null;
        if (UtilWeb.isReferencia(servletRequest)) {
            request = (HttpServletRequest)servletRequest;
        }
        return request;
    }

    public static HttpServletResponse getResponse(ServletResponse servletRequest) {
        HttpServletResponse response = null;
        if (UtilWeb.isReferencia(servletRequest)) {
            response = (HttpServletResponse)servletRequest;
        }
        return response;
    }

    public static Object getAtributoDaSessao(HttpServletRequest request, String nome) {
        Object atributo = null;
        if (UtilWeb.isReferencia(request) && !UtilWeb.isVazio(nome)) {
            atributo = UtilWeb.getSessao(request).getAttribute(nome);
        }
        return atributo;
    }

    public static Object getAtributoDoRequest(HttpServletRequest request, String nome) {
        Object atributo = null;
        if (UtilWeb.isReferencia(request) && !UtilWeb.isVazio(nome)) {
            atributo = request.getAttribute(nome);
        }
        return atributo;
    }

    public static String getParametroDoRequest(HttpServletRequest request, String nome) {
        String parametro = null;
        if (UtilWeb.isReferencia(request) && !UtilWeb.isVazio(nome)) {
            parametro = request.getParameter(nome);
        }
        return parametro;
    }

    public static String getPathDaAplicacao(ServletContextEvent evento) {
        String path = null;
        if (UtilWeb.isReferencia(evento)) {
            path = UtilWeb.getPathDaAplicacao(evento.getServletContext());
        }
        return path;
    }

    public static String getPathDaAplicacao(ServletContext servletContext) {
        String path = null;
        if (UtilWeb.isReferencia(servletContext)) {
            StringBuffer pathSB = new StringBuffer();
            pathSB.append(servletContext.getRealPath("."));
            pathSB.delete(pathSB.length() - 2, pathSB.length());
            path = pathSB.toString();
        }
        return path;
    }

    public static Map getMapaParametros(FilterConfig config) {
        Map resultado = UtilWeb.getColecaoFactory().novoHashMap();
        if (UtilWeb.isReferencia(config)) {
            String parametro = null;
            Enumeration parametros = config.getInitParameterNames();
            while (parametros.hasMoreElements()) {
                parametro = (String)parametros.nextElement();
                resultado.put(parametro, config.getInitParameter(parametro));
            }
        }
        return resultado;
    }

    public static String getRequisicaoGet() {
        return "GET";
    }

    public static String getRequisicaoPost() {
        return "POST";
    }

    public static void setAtributoNoRequest(HttpServletRequest request, String nome, Object valor) {
        if (UtilWeb.isReferencia(request) && !UtilWeb.isVazio(nome)) {
            request.setAttribute(nome, valor);
        }
    }

    public static void setAtributoNaSessao(HttpServletRequest request, String nome, Object valor) {
        if (UtilWeb.isReferencia(request) && !UtilWeb.isVazio(nome)) {
            UtilWeb.getSessao(request).setAttribute(nome, valor);
        }
    }

    private static boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    private static boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    private static ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }
}

