/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.util.excecao;

import br.com.politec.generico.excecao.RuntimeExceptionAbstrato;
import br.com.politec.generico.excecao.UtilRuntimeExcecaoAbstrato;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.infra.constante.MensagemID;
import br.com.politec.infra.exception.TransacaoException;
import br.com.politec.infra.util.UtilLog;
import java.sql.SQLException;

public final class UtilTransacaoException
extends UtilRuntimeExcecaoAbstrato {
    private UtilTransacaoException() {
    }

    public static TransacaoException erro(Throwable e) {
        String chave = MensagemID.getErro();
        String mensagem = UtilTransacaoException.getMensagem(e);
        return UtilTransacaoException.converter(UtilTransacaoException.novaExcecao(e, chave, mensagem));
    }

    public static TransacaoException conexaoNaoDefinida() {
        String chave = MensagemID.getConexaoNaoDefinida();
        return UtilTransacaoException.converter(UtilTransacaoException.novaExcecao(chave));
    }

    public static TransacaoException transacaoNaoIniciada(SQLException e) {
        String chave = MensagemID.getTransacaoNaoIniciada();
        String erro = UtilTransacaoException.getMensagem(e);
        return UtilTransacaoException.converter(UtilTransacaoException.novaExcecao(e, chave, erro));
    }

    public static TransacaoException erroAoEfetuarOCommit(SQLException e) {
        String chave = MensagemID.getErroAoEfetuarOCommit();
        String erro = UtilTransacaoException.getMensagem(e);
        return UtilTransacaoException.converter(UtilTransacaoException.novaExcecao(e, chave, erro));
    }

    public static TransacaoException erroAoEfetuarORollback(SQLException e) {
        String chave = MensagemID.getErroAoEfetuarORollback();
        String erro = UtilTransacaoException.getMensagem(e);
        return UtilTransacaoException.converter(UtilTransacaoException.novaExcecao(e, chave, erro));
    }

    private static TransacaoException converter(RuntimeExceptionAbstrato e) {
        TransacaoException excecao = new TransacaoException(e);
        UtilTransacaoException.getLog().error("Ocorreu um erro", excecao);
        return excecao;
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }
}

