/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.mantercliente.action;

import br.com.bb.plugins.dbt.apresentacao.action.DBTPluginActionAbstrato;
import br.com.bb.plugins.dbt.negocio.facade.ManterClienteFacade;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.form.ManterCadastroPessoaForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaFisicaFacade;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaJuridicaFacade;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import br.com.bb.plugins.gac.util.swing.IActionDeConfirmacao;
import java.util.LinkedHashSet;

public class IncluirClienteAction
extends DBTPluginActionAbstrato
implements IActionDeConfirmacao {
    public String executar(PluginFormAbstrato form) throws BBException {
        ManterCadastroPessoaForm pessoaForm = (ManterCadastroPessoaForm)form;
        if (pessoaForm.isPessoaFisica()) {
            this.incluirPessoaFisicaTO(pessoaForm);
            this.incluirConvenentePessoaTODecorator((PessoaTO)pessoaForm.getPessoaFisicaTO());
        } else {
            this.incluirPessoaJuridicaTO(pessoaForm);
            this.incluirConvenentePessoaTODecorator((PessoaTO)pessoaForm.getPessoaJuridicaTO());
        }
        return null;
    }

    private void incluirConvenentePessoaTODecorator(PessoaTO pessoaTO) {
        ConvenentePessoaTODecorator convenentePessoaTODecorator = this.getTOFactory().novoConvenentePessoaTODecorator();
        convenentePessoaTODecorator.setConvenenteTO(this.getConvenenteSelecionado());
        convenentePessoaTODecorator.setPessoaTO(pessoaTO);
        this.getManterClienteFacade().incluir(convenentePessoaTODecorator);
    }

    private ConvenenteTO getConvenenteSelecionado() {
        return FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getConvenenteTO();
    }

    private PluginControladorDeAcesso getControladorDeAcesso() {
        return this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
    }

    private void incluirPessoaJuridicaTO(ManterCadastroPessoaForm pessoaForm) throws BBException {
        ComplementoPessoaJuridicaTO pessoaJuridicaTO = pessoaForm.getPessoaJuridicaTO();
        pessoaJuridicaTO.setLogradouroTOs(new LinkedHashSet(pessoaForm.getListaEndereco()));
        pessoaJuridicaTO.setContatoTOs(new LinkedHashSet(pessoaForm.getListaContatos()));
        pessoaJuridicaTO.setIdentificacaoTOs(new LinkedHashSet(pessoaForm.getListaDocumento()));
        this.getManterCadastroPessoaJuridicaFacade().incluir(pessoaJuridicaTO);
    }

    private void incluirPessoaFisicaTO(ManterCadastroPessoaForm pessoaForm) throws BBException {
        ComplementoPessoaFisicaTO complementoPessoaFisica = pessoaForm.getPessoaFisicaTO();
        complementoPessoaFisica.setLogradouroTOs(new LinkedHashSet(pessoaForm.getListaEndereco()));
        complementoPessoaFisica.setContatoTOs(new LinkedHashSet(pessoaForm.getListaContatos()));
        complementoPessoaFisica.setIdentificacaoTOs(new LinkedHashSet(pessoaForm.getListaDocumento()));
        this.getManterCadastroPessoaFisicaFacade().incluir(complementoPessoaFisica);
    }

    private ManterCadastroPessoaJuridicaFacade getManterCadastroPessoaJuridicaFacade() {
        return this.getFacadeFactory().novoManterCadastroPessoaJuridicaFacade();
    }

    private ManterCadastroPessoaFisicaFacade getManterCadastroPessoaFisicaFacade() {
        return this.getFacadeFactory().novoManterCadastroPessoaFisicaFacade();
    }

    private ManterClienteFacade getManterClienteFacade() {
        return this.getDBTFacadeFactory().novoManterClienteFacade();
    }

    public String getMensagemDeConfirmacao() {
        return this.getUtilMensagem().getMensagem("MN001");
    }
}

