/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.form;

import br.com.bb.plugins.dbt.factory.DBTTOFactory;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjectRecebimento;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.string.UtilString;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterRecebimentoForm
extends PluginFormAbstrato {
    private RecebimentoDebitoTODecorator recebimentoTODecorator;
    private PaginadorTO paginadorTO;
    private List<RecebimentoDebitoTODecorator> listaComRecebimentoSelecionado;
    private Collection<IdentificadorClienteDebitoTO> listaIdentificacaoDebito;
    private Collection<ConvenentePessoaTO> listaPessoasDoConvenente;
    private ConvenentePessoaTO convenentePessoaTO;
    private ConvenenteTO convenenteTO;
    private ServicoTO servicoTO;
    private PessoaTO pessoaTO;
    private String opcaoConsulta;
    private GrupoClienteRecebimentoTO grupoClienteRecebimentoTO;
    private Long codigoContaCorrente;
    private Integer codigoAgencia;
    private IdentificadorClienteDebitoTO identificadorClienteDebitoTO;
    private String textoIdentificadorDebito;
    private String textoIdentificadorProprio;
    private Collection<ConvenioDebitoTO> mapConveioDebito;
    private List<IObjectRecebimento> listaExcluirRecebimento;

    public ConvenioDebitoTO getConvenioDebitoTO() {
        return this.getRecebimentoTODecorator().getConvenioDebitoTO();
    }

    public void setConvenioDebitoTO(Object object) {
        this.getRecebimentoTODecorator().setConvenioDebitoTO(object instanceof ConvenioDebitoTO ? (ConvenioDebitoTO)object : null);
    }

    public InstituicaoFinanceiraTO getInstituicaoFinanceiraTO() {
        return this.getRecebimentoTODecorator().getInstituicaoFinanceiraTO();
    }

    public Long getCodigoContaCorrente() {
        return this.codigoContaCorrente;
    }

    public Integer getCodigoInstituicaoFinanceira() {
        return this.getRecebimentoTODecorator().getInstituicaoFinanceiraTO().getCodigoInstituicaoFinanceira();
    }

    public Integer getCodigoTipoDocumento() {
        return this.getRecebimentoTODecorator().getIdentificacaoTO().getTipoDocumentoTO().getCodigoTipoDocumento();
    }

    public Date getDataFinal() {
        return this.getRecebimentoTODecorator().getDataDebitoFinal();
    }

    public Date getDataInicial() {
        return this.getRecebimentoTODecorator().getDataDebitoInicial();
    }

    public Date getDataRemessa() {
        return this.getRecebimentoTODecorator().getRemessaTO().getId().getDataRemessa();
    }

    public GrupoClienteRecebimentoTO getGrupoClienteRecebimentoTO() {
        return this.grupoClienteRecebimentoTO;
    }

    public String getNumeroInscricao() {
        return this.getRecebimentoTODecorator().getIdentificacaoTO().getTextoIdentificacao();
    }

    public SituacaoRecebimentoTO getSituacaoRecebimentoTO() {
        return this.getRecebimentoTODecorator().getSituacaoRecebimentoTO();
    }

    public String getTextoIdentificadorDebito() {
        return this.textoIdentificadorDebito;
    }

    public String getTextoNome() {
        return this.getRecebimentoTODecorator().getTextoNome();
    }

    public void setCodigoAgencia(String codigoAgencia) {
        Integer codigo = null;
        String codigoStr = null;
        codigoStr = this.recuperarNumero(codigoAgencia);
        if (codigoStr != null) {
            codigo = new Integer(codigoStr);
        }
        this.codigoAgencia = codigo;
    }

    public Integer getCodigoAgencia() {
        return this.codigoAgencia;
    }

    public void setCodigoContaCorrente(String codigoContaCorrente) {
        Long codigo = null;
        String codigoStr = null;
        codigoStr = this.recuperarNumero(codigoContaCorrente);
        if (codigoStr != null) {
            codigo = new Long(codigoStr);
        }
        this.codigoContaCorrente = codigo;
    }

    public void setCodigoInstituicaoFinanceira(String codigoInstituicaoFinanceira) {
        this.getRecebimentoTODecorator().getInstituicaoFinanceiraTO().setCodigoInstituicaoFinanceira(this.converterParaInteger(codigoInstituicaoFinanceira));
    }

    public void setCodigoTipoDocumento(String codigoTipoDocumento) {
        this.getRecebimentoTODecorator().getIdentificacaoTO().getTipoDocumentoTO().setCodigoTipoDocumento(this.converterParaInteger(codigoTipoDocumento));
    }

    public void setDataFinal(Date dataFinal) {
        this.getRecebimentoTODecorator().setDataDebitoFinal(dataFinal);
    }

    public void setDataInicial(Date dataInicial) {
        this.getRecebimentoTODecorator().setDataDebitoInicial(dataInicial);
    }

    public void setDataRemessa(Date dataRemessa) {
        this.getRecebimentoTODecorator().getRemessaTO().getId().setDataRemessa(dataRemessa);
    }

    public void setGrupoClienteRecebimentoTO(Object grupo) {
        this.grupoClienteRecebimentoTO = grupo instanceof GrupoClienteRecebimentoTO ? (GrupoClienteRecebimentoTO)grupo : null;
    }

    public void setNumeroInscricao(String inscricao) {
        this.getRecebimentoTODecorator().getIdentificacaoTO().setTextoIdentificacao(inscricao);
    }

    public void setSituacaoRecebimentoTO(SituacaoRecebimentoTO situacaoRecebimentoTO) {
        this.getRecebimentoTODecorator().getRecebimentoDebitoTO().setSituacaoRecebimentoTO(situacaoRecebimentoTO);
    }

    public void setTextoIdentificadorDebito(String textoIdentificadorDebito) {
        this.textoIdentificadorDebito = textoIdentificadorDebito;
    }

    public void setTextoNome(String textoNome) {
        this.getRecebimentoTODecorator().setTextoNome(textoNome);
    }

    public void setValorFinal(String valorFinal) {
        if (!UtilString.isVazio((String)valorFinal)) {
            this.getRecebimentoTODecorator().setValorFinal(Float.valueOf(this.converterParaLong(valorFinal).floatValue()));
        } else {
            this.getRecebimentoTODecorator().setValorFinal(Float.valueOf(0.0f));
        }
    }

    public void setValorInicial(String valorInicial) {
        if (!UtilString.isVazio((String)valorInicial)) {
            this.getRecebimentoTODecorator().setValorInicial(Float.valueOf(this.converterParaLong(valorInicial).floatValue()));
        } else {
            this.getRecebimentoTODecorator().setValorInicial(Float.valueOf(0.0f));
        }
    }

    public void setInstituicaoFinanceiraTO(InstituicaoFinanceiraTO instituicaoFinanceiraTO) {
        this.getRecebimentoTODecorator().setInstituicaoFinanceiraTO(instituicaoFinanceiraTO);
    }

    public PaginadorTO getPaginadorTO() {
        return this.paginadorTO;
    }

    public void setPaginadorTO(PaginadorTO paginadorTO) {
        this.paginadorTO = paginadorTO;
    }

    public Integer getTotalDeRegistros() {
        return this.getPaginadorTO().getTotalDeRegistros();
    }

    public Integer getPaginaAtual() {
        return this.getRecebimentoTODecorator().getPaginaAtual();
    }

    public void setPaginaAtual(Integer paginaAtual) {
        this.getRecebimentoTODecorator().setPaginaAtual(paginaAtual);
    }

    public RecebimentoDebitoTODecorator getRecebimentoTODecorator() {
        if (this.recebimentoTODecorator == null) {
            this.recebimentoTODecorator = DBTTOFactory.getInstancia().novoRecebimentoDebitoTODecorator();
        }
        return this.recebimentoTODecorator;
    }

    public void setRecebimentoTODecorator(RecebimentoDebitoTODecorator recebimentoTODecorator) {
        this.recebimentoTODecorator = recebimentoTODecorator;
    }

    public void setTipoOrdenacao(String tipoOrdenacao) {
        this.getRecebimentoTODecorator().setTipoOrdenacao(tipoOrdenacao);
    }

    public void setNomeColunaOrdenada(String nomeColunaOrdenada) {
        this.getRecebimentoTODecorator().setNomeColunaOrdenada(nomeColunaOrdenada);
    }

    public List<RecebimentoDebitoTODecorator> getListaComRecebimentoSelecionado() {
        return this.listaComRecebimentoSelecionado;
    }

    public void setListaComRecebimentoSelecionado(List<RecebimentoDebitoTODecorator> listaComRecebimentoSelecionado) {
        this.listaComRecebimentoSelecionado = listaComRecebimentoSelecionado;
    }

    public RecebimentoDebitoTODecorator getRecebimentoSelecionado() {
        RecebimentoDebitoTODecorator decorator = null;
        if (this.getListaComRecebimentoSelecionado() != null && this.getListaComRecebimentoSelecionado().size() > 0) {
            decorator = (RecebimentoDebitoTODecorator)((Object)UtilColecao.getElementoDoIndice(this.getListaComRecebimentoSelecionado(), (int)0));
        }
        if (decorator == null) {
            decorator = DBTTOFactory.getInstancia().novoRecebimentoDebitoTODecorator();
        }
        return decorator;
    }

    public void setListaIdentificacaoDebito(Collection<IdentificadorClienteDebitoTO> listaIdentificacaoDebito) {
        this.listaIdentificacaoDebito = listaIdentificacaoDebito;
    }

    public Collection<IdentificadorClienteDebitoTO> getListaIdentificacaoDebito() {
        return this.listaIdentificacaoDebito;
    }

    public Collection<ConvenentePessoaTO> getListaPessoasDoConvenente() {
        return this.listaPessoasDoConvenente;
    }

    public void setListaPessoasDoConvenente(Collection<ConvenentePessoaTO> listaPessoasDoConvenente) {
        this.listaPessoasDoConvenente = listaPessoasDoConvenente;
    }

    public IdentificadorClienteDebitoTO getIdentificadorClienteDebitoTO() {
        return this.identificadorClienteDebitoTO;
    }

    public void setIdentificadorClienteDebitoTO(IdentificadorClienteDebitoTO identificadorClienteDebitoTO) {
        this.identificadorClienteDebitoTO = identificadorClienteDebitoTO;
    }

    public Date getDataRecebimento() {
        return this.getRecebimentoTODecorator().getDataRecebimento();
    }

    public BigDecimal getValorRecebimento() {
        return this.getRecebimentoTODecorator().getValorRecebimento();
    }

    public void setDataRecebimento(Date date) {
        this.getRecebimentoTODecorator().setDataRecebimento(date);
    }

    public void setValorRecebimento(String valor) {
        BigDecimal bigDecimal = new BigDecimal(this.converterParaDouble(valor));
        this.getRecebimentoTODecorator().setValorRecebimento(bigDecimal);
    }

    public ConvenentePessoaTO getConvenentePessoaTO() {
        if (this.convenentePessoaTO == null) {
            this.convenentePessoaTO = this.getTOFactory().novoConvenentePessoaTO();
        }
        return this.convenentePessoaTO;
    }

    public void setConvenentePessoaTO(ConvenentePessoaTO convenentePessoaTO) {
        this.convenentePessoaTO = convenentePessoaTO;
    }

    public ConvenenteTO getConvenenteTO() {
        if (this.convenenteTO == null) {
            this.convenenteTO = FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getConvenenteTO();
        }
        return this.convenenteTO;
    }

    public ServicoTO getServicoTO() {
        return this.servicoTO;
    }

    public void setServicoTO(ServicoTO servicoTO) {
        this.servicoTO = servicoTO;
    }

    public void setPessoaTO(PessoaTO to) {
        this.pessoaTO = to;
    }

    public PessoaTO getPessoaTO() {
        return this.pessoaTO;
    }

    public String getOpcaoConsulta() {
        return this.opcaoConsulta;
    }

    public void setOpcaoConsulta(String opcaoConsulta) {
        this.opcaoConsulta = opcaoConsulta;
    }

    protected void doCarregarValidadores() {
        this.adicionarValidadorDeObrigatoriedadeParaObjeto("identificadorClienteDebitoTO", "ID P/D\u00e9bito");
        this.adicionarValidadorDeDataFuturaEUtil("dataRecebimento", "Data");
    }

    public RecebimentoDebitoTO getRecebimentoDebitoTO() {
        RecebimentoDebitoTO retorno = TOFactory.getInstancia().novoRecebimentoDebitoTO();
        ContaCorrenteClienteTOId idConta = null;
        retorno.setConvenioDebitoTO(this.getConvenioDebitoTO());
        retorno.setIdentificadorClienteDebitoTO(this.getIdentificadorClienteDebitoTO());
        idConta = this.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId();
        retorno.setCodigoBancoLiquidacao(idConta.getCodigoInstituicaoFinanceira());
        retorno.setCodigoContaCorrenteLiquidacao(Integer.valueOf(idConta.getCodigoContaCorrente().intValue()));
        retorno.setCodigoAgenciaLiquidacao(idConta.getCodigoAgencia());
        retorno.setDataRecebimento(this.getDataRecebimento());
        retorno.setValorRecebimento(this.getValorRecebimento());
        return retorno;
    }

    private String recuperarNumero(String numeroComDigito) {
        String retorno = null;
        int pos = 0;
        if (numeroComDigito != null) {
            retorno = numeroComDigito.trim();
            pos = retorno.indexOf(45);
            retorno = pos >= 1 ? retorno.substring(0, pos) : null;
        }
        return retorno;
    }

    public String getTextoIdentificadorProprio() {
        return this.textoIdentificadorProprio;
    }

    public void setTextoIdentificadorProprio(String textoIdentificadorProprio) {
        this.textoIdentificadorProprio = textoIdentificadorProprio;
    }

    public void setMapConveioDebito(Collection<ConvenioDebitoTO> mapConveioDebito) {
        this.mapConveioDebito = mapConveioDebito;
    }

    public Collection<ConvenioDebitoTO> getMapConveioDebito() {
        return this.mapConveioDebito;
    }

    public void setDado(Object dado) {
        this.setMapConveioDebito((Collection)dado);
    }

    public void setListaExcluirRecebimento(List<IObjectRecebimento> colecao) {
        this.listaExcluirRecebimento = colecao;
    }

    public List<IObjectRecebimento> getListaExcluirRecebimento() {
        return this.listaExcluirRecebimento;
    }
}

