/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.migrardadosdedebito.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.util.UtilMigracaoException;
import br.com.bb.plugins.dbt.util.dominio.UtilDominioImprimir;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjectErrosMigracaoDBT;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableScrollPane;
import br.com.bb.plugins.gac.util.view.FramePrincipal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewMigrarDadosListaErros
extends DBTBasicInternalFrame {
    private static final String LISTA_ERROS_GRAVES_MIGRACAO = "listaErrosGravesMigracao";
    private BBJTableScrollPane<IObjectErrosMigracaoDBT> tableModel;
    private JPanel panelPrincipal;
    private JPanel panelDados;
    private JPanel panelBotoes;
    private BBJButton btnImprimir;
    private BBJButton btnFechar;
    private BBJButton btnVoltar;
    private Map<Object, Object> context;
    private static final long serialVersionUID = 1L;

    public ViewMigrarDadosListaErros() {
        super("Migrar Base de Dados de Vers\u00f5es Anteriores - Erros de Migra\u00e7\u00e3o", false, true);
        this.initComponents();
        this.setVisible(false);
    }

    public ViewMigrarDadosListaErros(String title, boolean resizable, boolean closable) {
        super(title, false, false);
        this.setVisible(true);
        this.initComponents();
    }

    public void doShow(Map context) {
        this.tableModel = null;
        this.context = context;
        List lista = (List)context.get(LISTA_ERROS_GRAVES_MIGRACAO);
        this.panelPrincipal.add((Component)this.getPanelDados(), "North");
        this.carregaTabela(lista);
        this.setVisible(true);
    }

    private void initComponents() {
        super.add((Component)this.getPanelPrincipal());
    }

    private JPanel getPanelPrincipal() {
        if (!this.isReferencia(this.panelPrincipal)) {
            this.panelPrincipal = this.getPainelFactory().novoJPainel();
            this.panelPrincipal.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.add((Component)this.getPanelBotoes(), "Center");
            this.panelPrincipal.add((Component)panel, "Center");
            this.panelPrincipal.setOpaque(false);
        }
        return this.panelPrincipal;
    }

    private JPanel getPanelDados() {
        if (this.panelDados == null) {
            this.panelDados = new JPanel();
            this.panelDados.setOpaque(false);
            this.panelDados.setLayout(new BorderLayout());
            this.panelDados.setBorder(BBJBordaOval.createOvalBorder());
            this.panelDados.add((Component)this.getTableModel(), "Center");
        }
        return this.panelDados;
    }

    private JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setOpaque(false);
            FlowLayout flayout = new FlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add((Component)this.getBtnImprimir());
            this.panelBotoes.add((Component)this.getBtnVoltar());
            this.panelBotoes.add((Component)this.getBtnFechar());
        }
        return this.panelBotoes;
    }

    public BBJTableScrollPane<IObjectErrosMigracaoDBT> getTableModel() {
        if (this.tableModel == null) {
            String[] columnNames = null;
            int[] columnSizes = null;
            int[] columnAligment = null;
            columnNames = new String[]{"Nome", "Conv\u00eanio", "Data", "Valor", "Base", "Tabela", "Campo", "Motivo"};
            columnSizes = new int[]{275, 100, 80, 80, 80, 140, 140, 400};
            columnAligment = new int[]{2, 2, 2, 4, 2, 2, 2, 2, 2};
            this.tableModel = new BBJTableScrollPane(columnNames, columnSizes, columnAligment, 0);
            this.tableModel.setName("ErrosMigracao");
        }
        return this.tableModel;
    }

    private BBJButton getBtnImprimir() {
        if (!this.isReferencia(this.btnImprimir)) {
            this.btnImprimir = new BBJButton("IMPRIMIR");
            this.btnImprimir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewMigrarDadosListaErros.this.imprimir();
                }
            });
        }
        return this.btnImprimir;
    }

    private BBJButton getBtnFechar() {
        if (this.btnFechar == null) {
            this.btnFechar = new BBJButton("FECHAR");
            this.btnFechar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewMigrarDadosListaErros.this.doClose(null);
                }
            });
        }
        return this.btnFechar;
    }

    private BBJButton getBtnVoltar() {
        if (this.btnVoltar == null) {
            this.btnVoltar = new BBJButton("VOLTAR");
            this.btnVoltar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewMigrarDadosListaErros.this.voltarTelaResumo();
                }
            });
        }
        return this.btnVoltar;
    }

    private void voltarTelaResumo() {
        ViewController.getInstance().goToView("ViewMigrarDadosResumoDBT", this.context, false);
    }

    private void carregaTabela(List<UtilMigracaoException> lista) {
        ArrayList<IObjectErrosMigracaoDBT> listaIobject = new ArrayList<IObjectErrosMigracaoDBT>();
        for (UtilMigracaoException migracaoexception : lista) {
            listaIobject.add(new IObjectErrosMigracaoDBT(migracaoexception));
        }
        this.getTableModel().setDataListTabela(listaIobject);
    }

    private void imprimir() {
        List dataListTabela = this.tableModel.getBbtModel().getDataListTabela();
        UtilDominioImprimir utilDominioImprimir = new UtilDominioImprimir();
        String relatorio = "/relatorios/RelatorioMigrarDadosErrosMigracaoDBT.jasper";
        try {
            JasperViewer jasperViewer = utilDominioImprimir.imprimir(relatorio, this.getMapaParametros(), dataListTabela, "Mem\u00f3ria insuficiente para exibi\u00e7\u00e3o do relat\u00f3rio.", "");
            jasperViewer.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<Object, Object> getMapaParametros() {
        Map mapa = this.getColecaoFactory().novoHashMap();
        ConvenenteTO convenente = FramePrincipal.getInstance().getConvenente();
        try {
            mapa.put("convenente", convenente.getPessoaTO().getTextoNome());
            mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        }
        catch (Exception e) {
            mapa.put("nomeConvenente", "");
            mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        }
        return mapa;
    }
}

