/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.integracao.dao;

import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenioTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvenioDebitoDAOImpl
extends HibernateDAO<ConvenioDebitoTO, ConvenioDebitoTOId>
implements ConvenioDebitoDAO {
    protected ConvenioDebitoTOId getChavePrimaria(ConvenioDebitoTO to) {
        return to.getId();
    }

    protected Class<ConvenioDebitoTO> novoTipoDeObjetoPersistente() {
        return ConvenioDebitoTO.class;
    }

    @Override
    public void excluirPorConvenio(ConvenioDebitoTOId id) {
        Query query = this.novaQuery("DELETE FROM ConvenioDebitoTO to  WHERE to.id.numeroConvenio = :numeroConvenio AND to.id.codigoPessoaConvenente = :codigoPessoa AND to.id.textoIdentificadorServico = :textoIdentificadorServico");
        query.setInteger("numeroConvenio", id.getNumeroConvenio().intValue());
        query.setInteger("codigoPessoa", id.getCodigoPessoaConvenente().intValue());
        query.setString("textoIdentificadorServico", id.getTextoIdentificadorServico());
        query.executeUpdate();
    }

    @Override
    public Collection<ConvenioDebitoTO> consultarPorConvenente(ConvenioDebitoTO to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorConvenente(query, to);
        return query.list();
    }

    @Override
    public ConvenioDebitoTO consultar(Integer numeroConvenio, String textoIdentificadorServico) {
        Criteria query = this.novaCriteria();
        List lista = null;
        ConvenioDebitoTO retorno = null;
        if (numeroConvenio != null) {
            query.add(this.novoCriterioEQ("id.numeroConvenio", numeroConvenio));
        } else {
            query.add(Restrictions.isNull((String)"id.numeroConvenio"));
        }
        if (textoIdentificadorServico != null) {
            query.add(this.novoCriterioEQ("id.textoIdentificadorServico", textoIdentificadorServico));
        } else {
            query.add(Restrictions.isNull((String)"id.textoIdentificadorServico"));
        }
        lista = query.list();
        if (!lista.isEmpty()) {
            retorno = (ConvenioDebitoTO)lista.get(0);
        }
        return retorno;
    }

    private void adicionarCriterioConsultarPorConvenente(Criteria query, ConvenioDebitoTO to) {
        Integer codigoPessoaConvenente = to.getId().getCodigoPessoaConvenente();
        query.add(this.novoCriterioEQ("id.codigoPessoaConvenente", codigoPessoaConvenente));
    }

    @Override
    public boolean isExisteConvenioDebito(ConvenioDebitoTO convenioDebitoTO) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoPessoaConvenente", convenioDebitoTO.getId().getCodigoPessoaConvenente()));
        query.add(this.novoCriterioEQ("id.textoIdentificadorServico", convenioDebitoTO.getId().getTextoIdentificadorServico()));
        query.add(this.novoCriterioEQ("id.numeroConvenio", convenioDebitoTO.getId().getNumeroConvenio()));
        return !UtilColecao.isVazio((Collection)query.list());
    }

    @Override
    public void excluirPorConvenente(int codigo) {
        String hql = "delete ConvenioDebitoTO convenioDebito  where convenioDebito.id.codigoPessoaConvenente = :codigoPessoaConvenente";
        Query query = this.novaQuery(hql);
        query.setInteger("codigoPessoaConvenente", codigo);
        query.executeUpdate();
    }

    @Override
    public Collection<ConvenioDebitoTO> consultarPorConvenenteServicoAtivo(ConvenioDebitoTO convenioDebitoTO) {
        ConvenioTODecorator decorator = this.novoConvenioTODecorator(convenioDebitoTO.getConvenioTO());
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoPessoaConvenente", decorator.getCodigoPessoaConvenente()));
        Criteria convenioTOCriteria = this.getCriteria(query, "convenioTO");
        Criteria servicoTOCriteria = this.getCriteria(convenioTOCriteria, "servicoTO");
        servicoTOCriteria.add(this.novoCriterioEQ("textoIdentificadorServico", decorator.getTextoIdentificadorServico()));
        convenioTOCriteria.add(this.novoCriterioEQ("indicadorEstado", "1"));
        return query.list();
    }

    private ConvenioTODecorator novoConvenioTODecorator(ConvenioTO convenioTO) {
        return this.getTOFactory().novoConvenioTODecorator(convenioTO);
    }

    @Override
    public Collection<ConvenioDebitoTO> consultarPorConvenenteServico(ConvenioDebitoTO convenioDebitoTO) {
        ConvenioTODecorator decorator = this.novoConvenioTODecorator(convenioDebitoTO.getConvenioTO());
        Criteria query = this.novaCriteria();
        Criteria convenioTOCriteria = this.getCriteria(query, "convenioTO");
        Criteria servicoTOCriteria = this.getCriteria(convenioTOCriteria, "servicoTO");
        convenioTOCriteria.add(this.novoCriterioEQ("convenenteTO.codigoPessoaConvenente", decorator.getCodigoPessoaConvenente()));
        servicoTOCriteria.add(this.novoCriterioEQ("textoIdentificadorServico", decorator.getTextoIdentificadorServico()));
        return query.list();
    }

    @Override
    public void limpar() {
        super.getSession().clear();
    }

    public IdentificacaoTO consultarIdPessoaTOCodigo(int codigoPessoa) {
        Query query = this.novaQuery("select objIdentificacaoTO from IdentificacaoTO objIdentificacaoTO where objIdentificacaoTO.pessoaTO.codigoPessoa = " + codigoPessoa);
        return (IdentificacaoTO)query.uniqueResult();
    }

    public PessoaTO consultarPessoaTOCodigo(int codigoPessoa) {
        Query query = this.novaQuery("select objPessoaTO from PessoaTO objPessoaTO where objPessoaTO.codigoPessoa = " + codigoPessoa);
        return (PessoaTO)query.uniqueResult();
    }

    @Override
    public void alterarTipoLayout(int tipoLayout, int numeroConvenio) {
        Query query = this.novaQuery("UPDATE CVN_DEB SET NR_VRS_LAUT = :numeroLayout WHERE NR_CVN = :numeroConvenio");
        query.setInteger("numeroLayout", tipoLayout);
        query.setInteger("numeroConvenio", numeroConvenio);
        query.executeUpdate();
    }

    @Override
    public ConvenioDebitoTO buscarVersaoLayout(int numeroConvenio) {
        Query query = this.novaQuery("select objConvenioDebitoTO from ConvenioDebitoTO objConvenioDebitoTO where objConvenioDebitoTO.id.numeroConvenio = " + numeroConvenio);
        return (ConvenioDebitoTO)query.uniqueResult();
    }

    @Override
    public ConvenioDebitoTO buscarVersaoLayoutPeloCodPss(int codigoPessoa) {
        Query query = this.novaQuery("select objConvenioDebitoTO from ConvenioDebitoTO objConvenioDebitoTO where objConvenioDebitoTO.id.codigoPessoaConvenente = " + codigoPessoa);
        return (ConvenioDebitoTO)query.uniqueResult();
    }
}

