/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.negocio.model.GerarCopiaSegurancaModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ControleCopiaSegurancaTODecorator;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeData;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

public class ExecutarExpurgoDebitoEmContaModel
extends PluginModelAbstrato {
    private RecebimentoDebitoDAO recebimentoDAO;
    private RemessaDAO remessaDAO;
    private ServicoDAO servicoDAO;
    private GerarCopiaSegurancaModel gerarCopiaSegurancaModel;

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public PaginadorTO consultarPelaDataDeRecebimentoEConvenente(RecebimentoDebitoTODecorator recebimentoDebitoTODecorator) {
        return this.getRecebimentoDAO().consultarPelaDataDeRecebimentoEConvenente(recebimentoDebitoTODecorator);
    }

    public PaginadorTO consultarPelaDataDeRecebimentoConvenioEConvenente(RecebimentoDebitoTODecorator recebimentoDebitoTODecorator) {
        return this.getRecebimentoDAO().consultarPelaDataDeRecebimentoConvenioEConvenente(recebimentoDebitoTODecorator);
    }

    public void excluir(RecebimentoDebitoTODecorator recebimentoDebitoTODecorator) throws BBException {
        HashMap<String, RemessaTO> remessas = new HashMap<String, RemessaTO>();
        if (recebimentoDebitoTODecorator.isGerarCopiaDeSeguranca()) {
            ControleCopiaSegurancaTODecorator to = this.getFabricaDeTO().novoControleCopiaSegurancaTODecorator();
            String diretorio = this.getDiretorioCopiaDeSeguraca();
            to.setTextoNomeDiretorioArquivo(diretorio);
            try {
                this.getGerarCopiaSegurancaModel().gerar(to);
            }
            catch (BBException e) {
                e.printStackTrace();
            }
        }
        recebimentoDebitoTODecorator.setPaginaAtual(0);
        PaginadorTO paginadorTO = this.getRecebimentoDAO().consultarPelaDataDeRecebimentoEConvenente(recebimentoDebitoTODecorator);
        Collection colecaoRecebimentos = paginadorTO.getColecaoDeRegistros();
        if (UtilColecao.isVazio((Collection)colecaoRecebimentos)) {
            throw new BBException("MI051");
        }
        int totalRegistros = colecaoRecebimentos.size();
        int registroAtual = 1;
        for (RecebimentoDebitoTO recebimentoTO : colecaoRecebimentos) {
            String idRemessa;
            RemessaTO remessaTO = recebimentoTO.getRemessaTO();
            if (remessaTO != null && remessas.get(idRemessa = String.valueOf(remessaTO.getId().getNumeroConvenio()) + "#" + remessaTO.getId().getNumeroRemessa() + "#" + UtilFormatadorDeData.formatar_ddMMyyyy((Date)remessaTO.getId().getDataRemessa())) == null) {
                remessas.put(idRemessa, remessaTO);
            }
            this.getRecebimentoDAO().excluir(recebimentoTO);
            this.atualizaPorcentagem(recebimentoDebitoTODecorator.getNotificaExpurgoDebitoEmConta(), totalRegistros, registroAtual);
            ++registroAtual;
        }
        totalRegistros = remessas.values().size();
        registroAtual = 1;
        for (RemessaTO to : remessas.values()) {
            if (!this.getRecebimentoDAO().isExisteLancamentosComRemessa(to)) {
                this.getRemessaDAO().excluir((Object)to);
            }
            this.atualizaPorcentagem(recebimentoDebitoTODecorator.getNotificaExpurgoDebitoEmConta(), totalRegistros, registroAtual);
            ++registroAtual;
        }
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        servicoTO.setTextoIdentificadorServico("DBT");
        servicoTO = (ServicoTO)this.getServicoDAO().listar((Object)servicoTO);
        servicoTO.setDataExecucaoUltimoExpurgo((Date)UtilConversorDeData.converterParaSqlDate((Date)this.getDataAtual()));
        this.getServicoDAO().alterar((Object)servicoTO);
    }

    private void atualizaPorcentagem(UtilNotificador notificaExpurgo, int totalCadastros, int numeroCadastroAtual) {
        int porcentagem = numeroCadastroAtual * 100 / totalCadastros;
        notificaExpurgo.notifyObservers((Object)porcentagem);
    }

    public String getDiretorioCopiaDeSeguraca() {
        String diretorioCopiaSeguranca = this.getUtilArquivoConfiguracao().getValorPropertie("diretorio.copiaseguranca");
        return diretorioCopiaSeguranca;
    }

    protected UtilArquivoConfiguracao getUtilArquivoConfiguracao() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    private Date getDataAtual() {
        return DataFactory.getInstance().novoDate();
    }

    public RecebimentoDebitoDAO getRecebimentoDAO() {
        return this.recebimentoDAO;
    }

    public void setRecebimentoDAO(RecebimentoDebitoDAO recebimentoDAO) {
        this.recebimentoDAO = recebimentoDAO;
    }

    public GerarCopiaSegurancaModel getGerarCopiaSegurancaModel() {
        return this.gerarCopiaSegurancaModel;
    }

    public void setGerarCopiaSegurancaModel(GerarCopiaSegurancaModel gerarCopiaSegurancaModel) {
        this.gerarCopiaSegurancaModel = gerarCopiaSegurancaModel;
    }
}

