/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.negocio.model.DBTDominioModel;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificacaoDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.negocio.business.GerarRemessaDeDebitoAutomaticoBO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTOId;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTOId;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoRemessaTO;
import br.com.bb.plugins.gac.negocio.to.TipoRetornoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenioTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.GerarRemessaNegocioDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RegistroGerarRemessaDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RelatorioGerarRemessaDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.relatorio.RelatorioDataSource;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.conversor.UtilConversorDeLong;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import br.com.politec.generico.string.UtilString;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GerarRemessaModel
extends DBTDominioModel {
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private RemessaDAO remessaDAO;
    private ConvenioDAO convenioDAO;
    private ConvenioDebitoDAO convenioDebitoDAO;
    private ServicoDAO servicoDAO;
    private PessoaDAO pessoaDAO;
    private IdentificacaoDAO identificacaoDAO;
    private String versaoLayout;
    private final String[] columnNames = new String[]{"Cliente", "Data do D\u00e9bito", "Valor"};
    private final int[] columnSizes = new int[]{200, 150, 150};
    private final int[] columnAligment = new int[]{2, 4, 4};

    private String getVersaoLayout() {
        return this.versaoLayout;
    }

    private void setVersaoLayout(String versaoLayout) {
        this.versaoLayout = versaoLayout;
    }

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public ConvenioDAO getConvenioDAO() {
        return this.convenioDAO;
    }

    public void setConvenioDAO(ConvenioDAO convenioDAO) {
        this.convenioDAO = convenioDAO;
    }

    @Override
    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    @Override
    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }

    private void atualizaRecebimentoDebito(RecebimentoDebitoTO ultimoRecebimentoDebito, RemessaTODecorator remessaTODecorator) {
        if (this.isReferencia(ultimoRecebimentoDebito)) {
            ultimoRecebimentoDebito.setSituacaoRecebimentoTO(new SituacaoRecebimentoTO());
            ultimoRecebimentoDebito.getSituacaoRecebimentoTO().setCodigoSituacaoRecebimento(Character.valueOf('R'));
            ultimoRecebimentoDebito.setRemessaTO(remessaTODecorator.getRemessaTO());
        }
    }

    public List<RecebimentoDebitoTO> consultarPelaConvenioESituacaoRecebimentoG(IdentificadorClienteDebitoTODecorator idClienteTODecorator) {
        RecebimentoDebitoTODecorator decorator = this.getFabricaDeDBTTO().novoRecebimentoDebitoTODecorator();
        SituacaoRecebimentoTO situacao = this.getFabricaDeTO().novoSituacaoRecebimentoTO();
        decorator.setConvenioTO(idClienteTODecorator.getConvenioTO());
        situacao.setCodigoSituacaoRecebimento(Character.valueOf('G'));
        decorator.setSituacaoRecebimentoTO(situacao);
        return this.getRecebimentoDebitoDAO().consultarPelaConvenioESituacaoRecebimento(decorator);
    }

    private String criaHeader(Integer numeroConvenio, String nomeEmpresa, Integer sequencial) {
        ServicoTO servicoTO = (ServicoTO)this.getServicoDAO().listar((Serializable)((Object)"DBT"));
        String retorno = "";
        if (this.getVersaoLayout().equals(null) || this.getVersaoLayout().equalsIgnoreCase("")) {
            retorno = String.format("A1%-20.20s%-20.20s001%-20.20s%4$tY%4$tm%4$td%5$06d04%6$-17.17s%7$52.52s\n", UtilString.completarAEsquerda((String)numeroConvenio.toString(), (String)"0", (int)5), this.substituirCaracteresEspeciais(nomeEmpresa), "BANCO DO BRASIL", new Date(), 0, "DBT" + servicoTO.getTextoVersao().substring(0, 5), "");
        } else if (this.getVersaoLayout().equalsIgnoreCase("4") || this.getVersaoLayout().equals(null) || this.getVersaoLayout().equalsIgnoreCase("")) {
            retorno = String.format("A1%-20.20s%-20.20s001%-20.20s%4$tY%4$tm%4$td%5$06d04%6$-17.17s%7$52.52s\n", UtilString.completarAEsquerda((String)numeroConvenio.toString(), (String)"0", (int)5), this.substituirCaracteresEspeciais(nomeEmpresa), "BANCO DO BRASIL", new Date(), 0, "DBT" + servicoTO.getTextoVersao().substring(0, 5), "");
        } else if (this.getVersaoLayout().equalsIgnoreCase("5")) {
            retorno = String.format("A1%-20.20s%-20.20s001%-20.20s%4$tY%4$tm%4$td%5$06d05%6$-17.17s%7$52.52s\n", UtilString.completarAEsquerda((String)numeroConvenio.toString(), (String)"0", (int)5), this.substituirCaracteresEspeciais(nomeEmpresa), "BANCO DO BRASIL", new Date(), 0, "DBT" + servicoTO.getTextoVersao().substring(0, 5), "");
        }
        return retorno;
    }

    private String criaTrailler(int totalRegistros, double valorTotal) {
        return String.format("Z%06d%017.0f%126.126s\n", totalRegistros, valorTotal * 100.0, "");
    }

    private String criaRegistroTipoD(IdentificadorClienteDebitoTO identificadorClienteDebitoTO, List<RegistroGerarRemessaDecorator> colecaoAlterecaoExclucao) {
        String idDbtAnt = identificadorClienteDebitoTO.getTextoIdentificadorAnterior() == null ? "" : identificadorClienteDebitoTO.getTextoIdentificadorAnterior();
        int numAgencia = identificadorClienteDebitoTO.getContaCorrenteClienteTO().getId().getCodigoAgencia();
        String digAgencia = identificadorClienteDebitoTO.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia().toString();
        long numConta = identificadorClienteDebitoTO.getContaCorrenteClienteTO().getId().getCodigoContaCorrente();
        String digConta = identificadorClienteDebitoTO.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente().toString();
        String textoIdentificadorAnterior = identificadorClienteDebitoTO.getTextoIdentificadorAnterior();
        identificadorClienteDebitoTO.setDataUltimaRemessa(new Date());
        String idDbtAtual = identificadorClienteDebitoTO.getTextoIdentificadorDebito();
        String ocorrencia = identificadorClienteDebitoTO.getTextoDescricaoOcorrencia() == null ? "" : identificadorClienteDebitoTO.getTextoDescricaoOcorrencia();
        Integer codMovimento = textoIdentificadorAnterior.equals("AGUARDANDO EXCLUSAO NO BB") ? Integer.valueOf(1) : Integer.valueOf(0);
        colecaoAlterecaoExclucao.add(this.novoRegistroGerarRemessaDecorator(identificadorClienteDebitoTO, codMovimento, null, null));
        return String.format("D%-25.25s%04d%014d%-25.25s%-60.60s%-20.20s%01d\n", idDbtAnt, numAgencia, numConta, idDbtAtual, this.substituirCaracteresEspeciais(ocorrencia), "", codMovimento);
    }

    private String criaRegistroTipoJ(IdentificadorClienteDebitoTO identificadorClienteDebitoTO, List<RegistroGerarRemessaDecorator> colecaoAlterecaoExclucao) {
        String idDbtAnt = identificadorClienteDebitoTO.getTextoIdentificadorAnterior() == null ? "" : identificadorClienteDebitoTO.getTextoIdentificadorAnterior();
        int numAgencia = identificadorClienteDebitoTO.getContaCorrenteClienteTO().getId().getCodigoAgencia();
        String digAgencia = identificadorClienteDebitoTO.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia().toString();
        long numConta = identificadorClienteDebitoTO.getContaCorrenteClienteTO().getId().getCodigoContaCorrente();
        String digConta = identificadorClienteDebitoTO.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente().toString();
        String textoIdentificadorAnterior = identificadorClienteDebitoTO.getTextoIdentificadorAnterior();
        identificadorClienteDebitoTO.setDataUltimaRemessa(new Date());
        String idDbtAtual = identificadorClienteDebitoTO.getTextoIdentificadorDebito();
        String ocorrencia = identificadorClienteDebitoTO.getTextoDescricaoOcorrencia() == null ? "" : identificadorClienteDebitoTO.getTextoDescricaoOcorrencia();
        Integer codMovimento = UtilString.isVazio((String)textoIdentificadorAnterior) ? Integer.valueOf(1) : Integer.valueOf(0);
        colecaoAlterecaoExclucao.add(this.novoRegistroGerarRemessaDecorator(identificadorClienteDebitoTO, codMovimento, null, null));
        return String.format("D%-25.25s%04d%014d%-25.25s%-60.60s%-20.20s%01d\n", idDbtAnt, numAgencia, numConta, idDbtAtual, this.substituirCaracteresEspeciais(ocorrencia), "", codMovimento);
    }

    private String criaRegistroTipoE(IdentificadorClienteDebitoTO identificadorClienteDebitoTO, Date dataOpcao, RecebimentoDebitoTO recebimento) throws Throwable {
        ContaCorrenteClienteTOId idConta = identificadorClienteDebitoTO.getContaCorrenteClienteTO().getId();
        String tipoID = "";
        String idCliente = "";
        String stringRetorno = "";
        PessoaTO pessoaTO = new PessoaTO();
        Vector vetorId = new Vector();
        pessoaTO.setCodigoPessoa(idConta.getCodigoPessoa());
        IdentificacaoTO identificacaoTO = new IdentificacaoTO();
        this.getIdentificacaoDAO().consultarPelaPessoa(pessoaTO);
        Collection listaId = this.getIdentificacaoDAO().consultarPelaPessoa(pessoaTO);
        vetorId.addAll(listaId);
        int i = 0;
        while (i < vetorId.size()) {
            if (((IdentificacaoTO)vetorId.elementAt(i)).getId().getTextoIdentificador().equalsIgnoreCase("1") || ((IdentificacaoTO)vetorId.elementAt(i)).getId().getTextoIdentificador().equalsIgnoreCase("2")) {
                identificacaoTO.setId(((IdentificacaoTO)vetorId.elementAt(i)).getId());
            }
            ++i;
        }
        String idDbtAnterior = identificadorClienteDebitoTO.getTextoIdentificadorAnterior();
        String idDbt = identificadorClienteDebitoTO.getTextoIdentificadorDebito();
        Integer numAgencia = idConta.getCodigoAgencia();
        String digAgencia = identificadorClienteDebitoTO.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia().toString();
        Long numConta = idConta.getCodigoContaCorrente();
        String digConta = identificadorClienteDebitoTO.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente().toString();
        BigDecimal valorRecebimento = null;
        String idRecebimento = null;
        String codMovimento = "0";
        String filler = "";
        if (recebimento != null) {
            valorRecebimento = recebimento.getValorRecebimento();
            idRecebimento = recebimento.getTextoIdentificadorRegistro();
        } else {
            valorRecebimento = new BigDecimal(0);
            idRecebimento = "";
        }
        if (this.getVersaoLayout().equals(null) || this.getVersaoLayout().equalsIgnoreCase("")) {
            stringRetorno = String.format("E%1$-25.25S%2$04d%3$014d%4$tY%4$tm%4$td%5$015.0f03%6$-60.60s%7$-20.20s%8$1.1s\n", idDbt, numAgencia, numConta, dataOpcao, valorRecebimento.doubleValue() * 100.0, idRecebimento, filler, codMovimento);
        } else if (this.getVersaoLayout().equalsIgnoreCase("4") || this.getVersaoLayout().equals(null) || this.getVersaoLayout().equalsIgnoreCase("")) {
            stringRetorno = String.format("E%1$-25.25S%2$04d%3$014d%4$tY%4$tm%4$td%5$015.0f03%6$-60.60s%7$-20.20s%8$1.1s\n", idDbt, numAgencia, numConta, dataOpcao, valorRecebimento.doubleValue() * 100.0, idRecebimento, filler, codMovimento);
        } else if (this.getVersaoLayout().equalsIgnoreCase("5")) {
            tipoID = identificacaoTO.getId().getTextoIdentificador();
            tipoID = tipoID.equals("1") ? "2" : "1";
            idCliente = Util.strZero((String)identificacaoTO.getId().getTextoIdentificacao(), (int)15);
            stringRetorno = String.format("E%1$-25.25S%2$04d%3$014d%4$tY%4$tm%4$td%5$015.0f03%6$-60.60s%7$1.1s%8$15.15s%9$-4.4s%10$1.1s\n", idDbt, numAgencia, numConta, dataOpcao, valorRecebimento.doubleValue() * 100.0, idRecebimento, tipoID, idCliente, filler, codMovimento);
        }
        return stringRetorno;
    }

    private String gerarCodigoIdentificador(RecebimentoDebitoTO ultimoRecebimentoDebito) {
        double valorRamdomico = Math.random();
        String codigoRamdomico = UtilString.completarAEsquerda((String)UtilString.removerCaracteres((String)String.valueOf(valorRamdomico)), (String)"0", (int)5);
        codigoRamdomico = codigoRamdomico.substring(codigoRamdomico.length() - 5);
        String dataHora = String.format("%1$td%1$tm%1$tY%1$ts", new Date());
        String numeroRecebimento = UtilString.completarAEsquerda((String)String.valueOf(ultimoRecebimentoDebito.getNumeroRecebimento()), (String)"0", (int)7);
        return String.valueOf(codigoRamdomico) + dataHora.substring(0, 13) + numeroRecebimento;
    }

    protected List<IdentificadorClienteDebitoTO> geraLista1(IdentificadorClienteDebitoTODecorator idCliente) {
        List<IdentificadorClienteDebitoTO> lista = null;
        idCliente.setSituacaoIdentificadorDebitoTO(this.getFabricaDeTO().novoSituacaoIdentificadorDebitoTO());
        idCliente.getSituacaoIdentificadorDebitoTO().setTextoSituacaoIdentificador('G');
        lista = this.getIdentificadorClienteDebitoDAO().consultarPeloConvenioESituacaoUltimaRemessaVazio(idCliente);
        return lista;
    }

    protected List<IdentificadorClienteDebitoTO> geraLista2(IdentificadorClienteDebitoTODecorator identificadorClienteDebitoTODecorator) {
        List<IdentificadorClienteDebitoTO> lista = null;
        identificadorClienteDebitoTODecorator.setSituacaoIdentificadorDebitoTO(this.getFabricaDeTO().novoSituacaoIdentificadorDebitoTO());
        identificadorClienteDebitoTODecorator.getSituacaoIdentificadorDebitoTO().setTextoSituacaoIdentificador('A');
        identificadorClienteDebitoTODecorator.setDataUltimaRemessa(new Date());
        lista = this.getIdentificadorClienteDebitoDAO().consultarPeloConvenioESituacaoDataUltimaRemessaNE(identificadorClienteDebitoTODecorator);
        return lista;
    }

    @Override
    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    private void gravaHeader(RemessaTODecorator remessaTODecorator, ConvenioTO convenio, Integer sequencial, StringBuffer textoRegistros) {
        Integer numeroConvenio = convenio.getId().getNumeroConvenio();
        String nomeEmpresa = convenio.getContaCorrenteClienteTO().getPessoaTO().getTextoNome();
        textoRegistros.append(this.criaHeader(numeroConvenio, nomeEmpresa, sequencial));
        remessaTODecorator.setNumeroLancamentos(0);
    }

    private Integer calculaSequencial(ConvenioDebitoTO convenioDebito) {
        Integer sequencial = 0;
        this.getConvenioDebitoDAO().atualizaObjeto(convenioDebito);
        if (convenioDebito != null && convenioDebito.getNumeroUltimaRemessa() != null) {
            sequencial = convenioDebito.getNumeroUltimaRemessa();
        }
        sequencial = sequencial + 1;
        return sequencial;
    }

    private void gravaRegistroTipoD(List<IdentificadorClienteDebitoTO> lista1, StringBuffer textoRegistros, RemessaTODecorator remessaTODecorator, List<RegistroGerarRemessaDecorator> colecaoAlterecaoExclucao) {
        int totalRegistros = remessaTODecorator.getNumeroLancamentos();
        for (IdentificadorClienteDebitoTO identificadorClienteDebitoTO : lista1) {
            textoRegistros.append(this.criaRegistroTipoD(identificadorClienteDebitoTO, colecaoAlterecaoExclucao));
            ++totalRegistros;
        }
        remessaTODecorator.setNumeroLancamentos(totalRegistros);
    }

    private void gravaRegistroTipoJ(List<IdentificadorClienteDebitoTO> lista1, StringBuffer textoRegistros, RemessaTODecorator remessaTODecorator, List<RegistroGerarRemessaDecorator> colecaoAlterecaoExclucao) {
        int totalRegistros = remessaTODecorator.getNumeroLancamentos();
        for (IdentificadorClienteDebitoTO identificadorClienteDebitoTO : lista1) {
            textoRegistros.append(this.criaRegistroTipoD(identificadorClienteDebitoTO, colecaoAlterecaoExclucao));
            ++totalRegistros;
        }
        remessaTODecorator.setNumeroLancamentos(totalRegistros);
    }

    private void gravaRegistroTipoE(Collection<RecebimentoDebitoTO> recebimentosSelecionados, List<IdentificadorClienteDebitoTO> lista2, StringBuffer textoRegistros, RemessaTODecorator remessaTODecorator, List<RegistroGerarRemessaDecorator> colecaoRecebimentos) {
        try {
            int totalRegistros = remessaTODecorator.getNumeroLancamentos();
            double valorTotalLancamentos = 0.0;
            Date dataAtual = new Date();
            HashSet<IdentificadorClienteDebitoTO> idsSelecionados = new HashSet<IdentificadorClienteDebitoTO>();
            IdentificadorClienteDebitoTO idCliente = null;
            for (RecebimentoDebitoTO recebimentoDebitoTO : recebimentosSelecionados) {
                idsSelecionados.add(recebimentoDebitoTO.getIdentificadorClienteDebitoTO());
            }
            for (IdentificadorClienteDebitoTO idClienteTO : lista2) {
                if (idsSelecionados.contains(idClienteTO)) continue;
                textoRegistros.append(this.criaRegistroTipoE(idClienteTO, dataAtual, null));
                idClienteTO.setDataUltimaRemessa(dataAtual);
                colecaoRecebimentos.add(this.novoRegistroGerarRemessaDecorator(idClienteTO, 1, UtilFormatadorDeData.formatar_ddMMyyyy((Date)idClienteTO.getDataUltimaRemessa()), UtilFormatadorDeReal.formatar((double)0.0)));
                ++totalRegistros;
            }
            for (RecebimentoDebitoTO recebimento : recebimentosSelecionados) {
                idCliente = recebimento.getIdentificadorClienteDebitoTO();
                valorTotalLancamentos = this.somarValorLancamento(valorTotalLancamentos, recebimento);
                recebimento.setTextoIdentificadorRegistro(this.gerarCodigoIdentificador(recebimento));
                textoRegistros.append(this.criaRegistroTipoE(idCliente, recebimento.getDataRecebimento(), recebimento));
                this.atualizaRecebimentoDebito(recebimento, remessaTODecorator);
                colecaoRecebimentos.add(this.novoRegistroGerarRemessaDecorator(idCliente, 0, UtilFormatadorDeData.formatar_ddMMyyyy((Date)recebimento.getDataRecebimento()), UtilFormatadorDeReal.formatar((Number)recebimento.getValorRecebimento())));
                ++totalRegistros;
            }
            remessaTODecorator.setNumeroLancamentos(totalRegistros);
            remessaTODecorator.setSomaValoresDeRemessa(new BigDecimal(valorTotalLancamentos));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private double somarValorLancamento(double valorTotalLancamentos, RecebimentoDebitoTO ultimoRecebimentoDebito) {
        if (this.isReferencia(ultimoRecebimentoDebito)) {
            BigDecimal valorLancamento = ultimoRecebimentoDebito.getValorRecebimento();
            if (!this.isReferencia(valorLancamento)) {
                valorLancamento = new BigDecimal(0);
            }
            valorTotalLancamentos += valorLancamento.doubleValue();
        }
        return valorTotalLancamentos;
    }

    public List<RelatorioGerarRemessaDecorator> processarGerarRemessa(RemessaTODecorator remessaTODecorator) throws BBException {
        UtilNotificador notificaStatus = remessaTODecorator.getNotificaProcessarRemessa();
        ArrayList<RegistroGerarRemessaDecorator> colecaoAlterecaoExclucao = new ArrayList<RegistroGerarRemessaDecorator>();
        ArrayList<RegistroGerarRemessaDecorator> colecaoRecebimentos = new ArrayList<RegistroGerarRemessaDecorator>();
        IdentificadorClienteDebitoTODecorator idCliente = remessaTODecorator.getIdentificadorClienteDebitoTODecorator();
        Collection colRecebimentos = remessaTODecorator.getListaRecebimentoDebitoTO();
        ConvenioDebitoTO convenioDebitoTO = null;
        Character idManutencaoAutomaticaSim = new Character('1');
        Integer sequencial = null;
        ConvenioTO convenioTO = remessaTODecorator.getConvenioTO();
        idCliente.setConvenioTO(convenioTO);
        convenioDebitoTO = this.getConvenioDebitoDAO().consultar(convenioTO.getNumeroConvenio(), convenioTO.getServicoTO().getTextoIdentificadorServico());
        sequencial = this.calculaSequencial(convenioDebitoTO);
        List<IdentificadorClienteDebitoTO> lista1 = this.geraLista1(idCliente);
        this.atualizaPorcentagem(notificaStatus, 100, 10);
        List<Object> lista2 = null;
        lista2 = convenioDebitoTO != null && idManutencaoAutomaticaSim.equals(convenioDebitoTO.getIndicadorManutencaoAutomatica()) ? this.geraLista2(idCliente) : new ArrayList();
        this.atualizaPorcentagem(notificaStatus, 100, 20);
        StringBuffer textoRegistros = new StringBuffer();
        this.gravaHeader(remessaTODecorator, convenioTO, sequencial, textoRegistros);
        this.atualizaPorcentagem(notificaStatus, 100, 30);
        this.gravaRegistroTipoD(lista1, textoRegistros, remessaTODecorator, colecaoAlterecaoExclucao);
        this.atualizaPorcentagem(notificaStatus, 100, 40);
        this.gravaRegistroTipoE(colRecebimentos, lista2, textoRegistros, remessaTODecorator, colecaoRecebimentos);
        this.atualizaPorcentagem(notificaStatus, 100, 50);
        this.gravaTrailler(remessaTODecorator, textoRegistros);
        this.atualizaPorcentagem(notificaStatus, 100, 60);
        this.incluiRemessa(remessaTODecorator, sequencial);
        this.atualizaPorcentagem(notificaStatus, 100, 70);
        this.armazenarArquivo(textoRegistros, remessaTODecorator);
        this.atualizaPorcentagem(notificaStatus, 100, 80);
        for (RecebimentoDebitoTO recebimentoDebitoTO : colRecebimentos) {
            this.atualizaRecebimentoDebito(recebimentoDebitoTO, remessaTODecorator);
            this.getRecebimentoDebitoDAO().alterar(recebimentoDebitoTO);
        }
        this.atualizaIdentificadoresDebito(lista1, remessaTODecorator);
        convenioDebitoTO.setNumeroUltimaRemessa(sequencial);
        this.getConvenioDebitoDAO().alterar(convenioDebitoTO);
        for (RegistroGerarRemessaDecorator registroGerarRemessaDecorator : colecaoAlterecaoExclucao) {
            registroGerarRemessaDecorator.setAgencia(String.valueOf(registroGerarRemessaDecorator.getAgencia()) + "-" + registroGerarRemessaDecorator.getDvAgencia());
            registroGerarRemessaDecorator.setContaCorrente(String.valueOf(registroGerarRemessaDecorator.getContaCorrente()) + "-" + registroGerarRemessaDecorator.getDvConta());
            if (registroGerarRemessaDecorator.getIdentificacaoParaDebitoClienteAnterior().equals("AGUARDANDO EXCLUSAO NO BB")) {
                registroGerarRemessaDecorator.setCodigoMovimento("Exclus\u00e3o de Identifica\u00e7\u00e3o de D\u00e9bito");
                continue;
            }
            registroGerarRemessaDecorator.setCodigoMovimento("Altera\u00e7\u00e3o de Identifica\u00e7\u00e3o de D\u00e9bito");
        }
        for (RegistroGerarRemessaDecorator registroGerarRemessaDecorator : colecaoRecebimentos) {
            registroGerarRemessaDecorator.setAgencia(String.valueOf(registroGerarRemessaDecorator.getAgencia()) + "-" + registroGerarRemessaDecorator.getDvAgencia());
            registroGerarRemessaDecorator.setContaCorrente(String.valueOf(registroGerarRemessaDecorator.getContaCorrente()) + "-" + registroGerarRemessaDecorator.getDvConta());
            registroGerarRemessaDecorator.setCodigoMovimento("D\u00e9bito Normal");
        }
        ArrayList<RelatorioGerarRemessaDecorator> arrayList = new ArrayList<RelatorioGerarRemessaDecorator>();
        this.criaRelatorioDataSourceAlteracaoExclusao(remessaTODecorator, colecaoAlterecaoExclucao, arrayList);
        this.atualizaPorcentagem(notificaStatus, 100, 95);
        this.criaRelatorioDataSourceRecebimentos(remessaTODecorator, colecaoRecebimentos, arrayList);
        this.atualizaPorcentagem(notificaStatus, 100, 100);
        return arrayList;
    }

    public int calcularResumoRemessa(RemessaTODecorator remessaTODecorator) throws BBException {
        IdentificadorClienteDebitoTODecorator idCliente = remessaTODecorator.getIdentificadorClienteDebitoTODecorator();
        ConvenioTO convenioTO = remessaTODecorator.getConvenioTO();
        idCliente.setConvenioTO(convenioTO);
        Object[] listaRecebimentos = remessaTODecorator.getListaRecebimentoDebitoTO().toArray();
        ConvenioDebitoTO convenioDebitoTO = this.getConvenioDebitoDAO().buscarVersaoLayout(convenioTO.getNumeroConvenio());
        List<IdentificadorClienteDebitoTO> lista1 = this.geraLista1(idCliente);
        int i = 0;
        while (i < listaRecebimentos.length) {
            if (convenioDebitoTO.getNumeroLayout() == null) {
                this.setVersaoLayout("");
            } else if (convenioDebitoTO.getNumeroLayout() == 4 || convenioDebitoTO.getNumeroLayout().toString().trim() == "") {
                this.setVersaoLayout("4");
            } else if (convenioDebitoTO.getNumeroLayout() == 5) {
                this.setVersaoLayout("5");
                IdentificacaoTO identificacaoTO = this.getPessoaDAO().consultarIdPessoaTOCodigo(((RecebimentoDebitoTO)listaRecebimentos[i]).getIdentificadorClienteDebitoTO().getPessoaTO().getCodigoPessoa().intValue());
                if (identificacaoTO == null || identificacaoTO.getId().getTextoIdentificacao().trim().equalsIgnoreCase("")) {
                    BBJPopupMensagem.exibirMensagem((String)"O Conv\u00eanio est\u00e1 com o Tipo Leiaute configurado como \" 5 (com identifica\u00e7\u00e3o) \". Portanto o campo N\u00ba Documento do Cliente \u00e9 de preenchimento obrigat\u00f3rio. Retorne ao Cadastramento de Cliente e efetue as devidas altera\u00e7\u00f5es.");
                    ((RecebimentoDebitoTO)listaRecebimentos[i]).setCodigoAgenciaDebito(Integer.valueOf(-999999999));
                    break;
                }
            }
            ++i;
        }
        return lista1.size();
    }

    private void atualizaIdentificadoresDebito(List<IdentificadorClienteDebitoTO> lista1, RemessaTODecorator remessaTODecorator) {
        for (IdentificadorClienteDebitoTO to : lista1) {
            to.setNumeroAlteracaoRemessa(remessaTODecorator.getNumeroRemessa());
            to.setDataAlteracaoRemessa(remessaTODecorator.getDataRemessa());
            this.getIdentificadorClienteDebitoDAO().alterar(to);
        }
    }

    private void criaRelatorioDataSourceAlteracaoExclusao(RemessaTODecorator remessaTODecorator, List<RegistroGerarRemessaDecorator> colecaoAlterecaoExclucao, List<RelatorioGerarRemessaDecorator> colecaoRetorno) throws BBException {
        RelatorioGerarRemessaDecorator relatorioGerarRemessaDecorator2 = new RelatorioGerarRemessaDecorator();
        relatorioGerarRemessaDecorator2.setAlterecaoExclucaoDS(new RelatorioDataSource(colecaoAlterecaoExclucao));
        relatorioGerarRemessaDecorator2.setTipoRegistroTitulo("ALTERA\u00c7\u00c3O/EXCLUS\u00c3O DE IDENTIFICA\u00c7\u00c3O PARA D\u00c9BITO");
        relatorioGerarRemessaDecorator2.setTotalRegistros(UtilConversorDeInteger.converterParaString((int)remessaTODecorator.getNumeroLancamentosAlteracaoExclusao()));
        colecaoRetorno.add(relatorioGerarRemessaDecorator2);
    }

    private void criaRelatorioDataSourceRecebimentos(RemessaTODecorator remessaTODecorator, List<RegistroGerarRemessaDecorator> colecaoRecebimentos, List<RelatorioGerarRemessaDecorator> colecaoRetorno) throws BBException {
        RelatorioGerarRemessaDecorator relatorioGerarRemessaDecorator = new RelatorioGerarRemessaDecorator();
        relatorioGerarRemessaDecorator.setAlterecaoExclucaoDS(new RelatorioDataSource(colecaoRecebimentos));
        relatorioGerarRemessaDecorator.setTipoRegistroTitulo("RECEBIMENTO");
        relatorioGerarRemessaDecorator.setTotalRegistros(UtilConversorDeInteger.converterParaString((int)remessaTODecorator.getNumeroLancamentosRecebimentos()));
        colecaoRetorno.add(relatorioGerarRemessaDecorator);
    }

    private void incluiRemessa(RemessaTODecorator remessaTODecorator, Integer sequencial) {
        RemessaTO remessaTO = this.getFabricaDeTO().novoRemessaTO();
        TipoRetornoTO tipoRetornoTO = this.getFabricaDeTO().novoTipoRetornoTO();
        TipoRemessaTO tipoRemessaTO = this.getFabricaDeTO().novoTipoRemessaTO();
        ConvenioTOId convenioId = remessaTODecorator.getConvenioTO().getId();
        RemessaTOId id = remessaTO.getId();
        id.setNumeroConvenio(convenioId.getNumeroConvenio().intValue());
        id.setCodigoPessoaConvenente(convenioId.getCodigoPessoaConvenente().intValue());
        id.setTextoIdentificadorServico(convenioId.getTextoIdentificadorServico());
        id.setNumeroRemessa(sequencial);
        remessaTO.setConvenioTO(remessaTODecorator.getConvenioTO());
        remessaTO.getId().setDataRemessa(new Date());
        tipoRemessaTO.setCodigoTipoRemessa(Integer.valueOf(1));
        remessaTO.setTipoRemessaTO(tipoRemessaTO);
        remessaTO.setContaCorrenteClienteTO(remessaTODecorator.getConvenioTO().getContaCorrenteClienteTO());
        tipoRetornoTO.setTextoTipoRetorno('A');
        remessaTO.setTipoRetornoTO(tipoRetornoTO);
        remessaTO.setValorRemessa(remessaTODecorator.getSomaValoresDeRemessa());
        this.getRemessaDAO().incluir((Object)remessaTO);
        remessaTODecorator.setRemessaTO(remessaTO);
        String nomeArquivo = this.getNomeArquivoRemessa(remessaTODecorator);
        remessaTO.setTextoNomeArquivo(nomeArquivo);
        this.getRemessaDAO().alterar((Object)remessaTO);
    }

    private void armazenarArquivo(StringBuffer textoRegistros, RemessaTODecorator remessaTODecorator) throws BBException {
        String nomeArquivo = this.getNomeArquivoRemessa(remessaTODecorator);
        File arquivo = this.getArquivoRemessa(nomeArquivo);
        PrintWriter printWriter = null;
        try {
            try {
                this.criaPastasSeNecessario();
                if (!arquivo.exists()) {
                    arquivo.createNewFile();
                }
                printWriter = new PrintWriter(arquivo);
                printWriter.write(textoRegistros.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        finally {
            if (this.isReferencia(printWriter)) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    private String getNomeArquivoRemessa(RemessaTODecorator remessaTODecorator) {
        String numeroConvenio = UtilConversorDeInteger.converterParaString((Integer)remessaTODecorator.getConvenioTO().getId().getNumeroConvenio());
        String numeroRemessa = UtilConversorDeInteger.converterParaString((int)(remessaTODecorator.getNumeroRemessa() == null ? 0 : remessaTODecorator.getNumeroRemessa()));
        String nomeArquivo = String.format("%s.%s.%3$td%3$tm%3$tY.%4$s.REM", "DBT", numeroConvenio, new Date(), numeroRemessa);
        return nomeArquivo;
    }

    private File criaPastasSeNecessario() {
        String pathPasta = this.getPastaArquivosRemessa();
        File pasta = new File(pathPasta);
        if (!pasta.exists()) {
            pasta.mkdirs();
        }
        return pasta;
    }

    private String getPastaArquivosRemessa() {
        UtilArquivoConfiguracao instanciaUtilArquivoConfiguraca = this.getInstanciaUtilArquivoConfiguraca();
        return instanciaUtilArquivoConfiguraca.getValorPropertie("diretorio.remessa");
    }

    private File getArquivoRemessa(String nomeArquivo) {
        return this.getArquivoFactory().novoFile(String.valueOf(this.getPastaArquivosRemessa()) + "\\" + nomeArquivo);
    }

    private UtilArquivoConfiguracao getInstanciaUtilArquivoConfiguraca() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    private void gravaTrailler(RemessaTODecorator remessaTODecorator, StringBuffer textoRegistros) {
        textoRegistros.append(this.criaTrailler(remessaTODecorator.getNumeroLancamentos() + 2, remessaTODecorator.getSomaValoresDeRemessa().doubleValue()));
    }

    @Override
    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    private RegistroGerarRemessaDecorator novoRegistroGerarRemessaDecorator(IdentificadorClienteDebitoTO identificadorClienteDebitoTO, Integer codMovimento, String data, String valor) {
        RegistroGerarRemessaDecorator registroGerarRemessaDecorator = new RegistroGerarRemessaDecorator();
        registroGerarRemessaDecorator.setAgencia(UtilConversorDeInteger.converterParaString((Integer)identificadorClienteDebitoTO.getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO().getId().getCodigoAgencia()));
        registroGerarRemessaDecorator.setBanco("BANCO DO BRASIL");
        registroGerarRemessaDecorator.setCodigoMovimento(UtilConversorDeInteger.converterParaString((Integer)codMovimento));
        registroGerarRemessaDecorator.setContaCorrente(UtilConversorDeLong.converterParaString((Long)identificadorClienteDebitoTO.getContaCorrenteClienteTO().getId().getCodigoContaCorrente()));
        registroGerarRemessaDecorator.setData(data);
        registroGerarRemessaDecorator.setIdentificacaoParaDebitoClienteAnterior(identificadorClienteDebitoTO.getTextoIdentificadorAnterior());
        registroGerarRemessaDecorator.setIdentificacaoParaDebitoCliente(identificadorClienteDebitoTO.getTextoIdentificadorDebito());
        registroGerarRemessaDecorator.setNome(identificadorClienteDebitoTO.getPessoaTO().getTextoNome());
        registroGerarRemessaDecorator.setValor(valor);
        registroGerarRemessaDecorator.setDvAgencia(identificadorClienteDebitoTO.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia().toString());
        registroGerarRemessaDecorator.setDvConta(identificadorClienteDebitoTO.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente().toString());
        return registroGerarRemessaDecorator;
    }

    private void atualizaPorcentagem(UtilNotificador notificaImportacao, int totalRegistros, int numeroLinha) {
        int porcentagem = numeroLinha * 100 / totalRegistros;
        notificaImportacao.notifyObservers((Object)porcentagem);
    }

    public List<RemessaTODecorator> consultarLancamentosConsolidados() {
        return this.getRecebimentoDebitoDAO().consultaRecebimentosSituacaoGravado();
    }

    public void consultarRecebimentosDaRemessa(GerarRemessaNegocioDecorator decorator) throws BBException {
        IdentificadorClienteDebitoTODecorator identificadorDecorator = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        identificadorDecorator.setConvenioTO(this.getConvenioPeloCodigo(decorator.getGerarRemessaBO().getNumeroConvenio()));
        decorator.setNomeColunas(this.columnNames);
        decorator.setAlinhamentoColunas(this.columnAligment);
        decorator.setTamanhoColunas(this.columnSizes);
        List<RecebimentoDebitoTO> listaRecebimentos = this.consultarPelaConvenioESituacaoRecebimentoG(identificadorDecorator);
        ArrayList<GerarRemessaDeDebitoAutomaticoBO> listaDados = new ArrayList<GerarRemessaDeDebitoAutomaticoBO>();
        double valorTotalLancamentos = 0.0;
        for (RecebimentoDebitoTO to : listaRecebimentos) {
            GerarRemessaDeDebitoAutomaticoBO bo = new GerarRemessaDeDebitoAutomaticoBO(to);
            if (to.getValorRecebimento() != null) {
                valorTotalLancamentos += to.getValorRecebimento().doubleValue();
            }
            listaDados.add(bo);
        }
        decorator.setValorTotalLancamentos(valorTotalLancamentos);
        decorator.setListaDados(listaDados);
    }

    public void gerarRemessa(GerarRemessaNegocioDecorator decorator) throws BBException {
        RemessaTODecorator remessaTODecorator = this.getFabricaDeTO().novoRemessaTODecorator();
        remessaTODecorator.setConvenioTO(this.getConvenioPeloCodigo(decorator.getGerarRemessaBO().getNumeroConvenio()));
        remessaTODecorator.setNotificaProcessarRemessa(decorator.getNotificaProcessarRemessa());
        List lancamentosSelecionandos = decorator.getLancamentosSelecionados();
        ArrayList<RecebimentoDebitoTO> listaRecebimentoDebitoTO = new ArrayList<RecebimentoDebitoTO>();
        for (Object obj : lancamentosSelecionandos) {
            listaRecebimentoDebitoTO.add(((GerarRemessaDeDebitoAutomaticoBO)obj).getRecebimentoDebitoTO());
        }
        remessaTODecorator.setListaRecebimentoDebitoTO(listaRecebimentoDebitoTO);
        decorator.setListaRelatorio(this.processarGerarRemessa(remessaTODecorator));
        decorator.setRemessaTODecorator(remessaTODecorator);
    }

    private ConvenioTO getConvenioPeloCodigo(Integer numeroConvenio) {
        ConvenioTODecorator convenioTODecorator = this.getFabricaDeTO().novoConvenioTODecorator();
        convenioTODecorator.setNumeroConvenio(numeroConvenio);
        convenioTODecorator.setTextoIdentificadorServico("DBT");
        return this.getConvenioDAO().consultarPorConvenioServico(convenioTODecorator);
    }

    private String substituirCaracteresEspeciais(String strVar) {
        return Util.substituirCaracteresEspeciais((String)strVar);
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public IdentificacaoDAO getIdentificacaoDAO() {
        return this.identificacaoDAO;
    }

    public void setIdentificacaoDAO(IdentificacaoDAO identificacaoDAO) {
        this.identificacaoDAO = identificacaoDAO;
    }
}

