/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.excecao.RegistroRejeitadoException;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.negocio.model.ImportarDadosExternoModel;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTOId;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenioTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.ImportarDadosExternoTODecorator;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.dominio.UtilDominioCamposDeLeiaute;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.conversor.UtilConversorDeData;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportarDadosExternoDBTModel
extends ImportarDadosExternoModel {
    private ConvenioDAO convenioDAO;
    private RemessaDAO remessaDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private ConvenioDebitoDAO convenioDebitoDAO;
    private RemessaTO remessaTO;
    private RecebimentoDebitoTO recebimentoDebitoTO;

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    public RemessaTO getRemessaTO() {
        return this.remessaTO;
    }

    public void setRemessaTO(RemessaTO remessaTO) {
        this.remessaTO = remessaTO;
    }

    public void importar(ImportarDadosExternoTODecorator importarDadosExternoTODecorator) throws BBException {
        if (importarDadosExternoTODecorator.getTipoLeiauteTO().getTextoDescricaoTipoLeiaute().equals("Recebimento")) {
            this.importarRecebimento(importarDadosExternoTODecorator);
        } else {
            this.importarPessoa(importarDadosExternoTODecorator);
        }
    }

    public void importarPessoa(ImportarDadosExternoTODecorator importarDadosExternoTODecorator) throws BBException {
        super.importar(importarDadosExternoTODecorator);
    }

    public void importarRecebimento(ImportarDadosExternoTODecorator importarDadosExternoTODecorator) throws BBException {
        File file = importarDadosExternoTODecorator.getArquivo();
        LeiauteTO leiauteTO = importarDadosExternoTODecorator.getLeiauteTO();
        Set colecaoCamposLeiauteTO = leiauteTO.getCamposLeiauteTOs();
        BufferedReader bufferedReader = null;
        int totalRegistros = 0;
        int totalAux = 0;
        String linha = null;
        int numeroLinha = 0;
        try {
            try {
                totalRegistros = this.getNumeroDeRegistros(file);
                bufferedReader = UtilArquivo.getBufferedReader((File)file);
                totalAux = totalRegistros;
                while (totalAux != 0) {
                    linha = bufferedReader.readLine();
                    ++numeroLinha;
                    try {
                        try {
                            this.inicializaValores();
                            this.criaMapaDeValores(colecaoCamposLeiauteTO, linha);
                            this.copiaMapaDeValores();
                            this.validaRegistroRecebimentos(colecaoCamposLeiauteTO, linha);
                            this.criaPessoaTO();
                            try {
                                this.incluiPessoaTO();
                            }
                            catch (BBException bBException) {
                                // empty catch block
                            }
                            this.criaRemessaTO();
                            this.incluiRemessaTO();
                            this.criaRecebimentoDebitoTO();
                            this.incluiRecebimentoDebitoTO();
                        }
                        catch (RegistroRejeitadoException e) {
                            e.getRegistroRejeitadoTODecorator().setNumeroRegistro(Integer.valueOf(numeroLinha));
                            this.getColecaoRegistroRejeitadoTO().add(e.getRegistroRejeitadoTODecorator());
                            this.atualizaPorcentagem(importarDadosExternoTODecorator.getNotificaImportacao(), totalRegistros, numeroLinha);
                            --totalAux;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        this.atualizaPorcentagem(importarDadosExternoTODecorator.getNotificaImportacao(), totalRegistros, numeroLinha);
                        --totalAux;
                        throw throwable;
                    }
                    this.atualizaPorcentagem(importarDadosExternoTODecorator.getNotificaImportacao(), totalRegistros, numeroLinha);
                    --totalAux;
                }
            }
            catch (IOException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        Collection colecaoRegistroRejeitadoTODecorator = this.getColecaoRegistroRejeitadoTO();
        int numeroRegistrosRejeitados = colecaoRegistroRejeitadoTODecorator.size();
        importarDadosExternoTODecorator.setNumeroRegistrosImportados(Integer.valueOf(totalRegistros - numeroRegistrosRejeitados));
        importarDadosExternoTODecorator.setNumeroRegistrosRejeitados(Integer.valueOf(numeroRegistrosRejeitados));
        importarDadosExternoTODecorator.setColecaoRegistroRejeitadoTODecorator(colecaoRegistroRejeitadoTODecorator);
    }

    private void copiaMapaDeValores() {
        this.getMapaCamposLeiauteTO().put("TX_IDFC", (CamposLeiauteTO)this.getMapaCamposLeiauteTO().get("TX_IDFC"));
        this.getMapaValorCampo().put("TX_IDFC", (String)this.getMapaValorCampo().get("TX_IDFC"));
        this.getMapaCamposLeiauteTO().put("TX_LGR", (CamposLeiauteTO)this.getMapaCamposLeiauteTO().get("TX_LGR"));
        this.getMapaValorCampo().put("TX_LGR", (String)this.getMapaValorCampo().get("TX_LGR"));
        this.getMapaCamposLeiauteTO().put("TX_SG_UF_END", (CamposLeiauteTO)this.getMapaCamposLeiauteTO().get("TX_SG_UF_END"));
        this.getMapaValorCampo().put("TX_SG_UF_END", (String)this.getMapaValorCampo().get("TX_SG_UF_END"));
        this.getMapaCamposLeiauteTO().put("TX_NM", (CamposLeiauteTO)this.getMapaCamposLeiauteTO().get("TX_NM"));
        this.getMapaValorCampo().put("TX_NM", (String)this.getMapaValorCampo().get("TX_NM"));
    }

    private void incluiRecebimentoDebitoTO() {
        this.getRecebimentoDebitoDAO().alterar(this.getRecebimentoDebitoTO());
    }

    private void validaRegistroRecebimentos(Set<CamposLeiauteTO> colecaoCamposLeiauteTO, String linha) throws RegistroRejeitadoException {
        this.validaTamanhoDosCampos(colecaoCamposLeiauteTO, linha);
        this.validaObrigatoriedadeDosCampos(colecaoCamposLeiauteTO);
        this.validaCPF();
        this.validaCNPJ();
        this.validaNacionalidade();
        this.validaSituacao();
        this.validaConvenio();
    }

    protected void validaObrigatoriedadeDosCampos(Set<CamposLeiauteTO> colecaoCamposLeiauteTO) throws RegistroRejeitadoException {
        for (CamposLeiauteTO camposLeiauteTO : colecaoCamposLeiauteTO) {
            String textoDescricaoCampo = camposLeiauteTO.getTextoNomeCampo();
            if (textoDescricaoCampo.equals("TX_CEP") || textoDescricaoCampo.equals("TX_SG_UF_END") || textoDescricaoCampo.equals("TX_CID")) continue;
            String valor = (String)this.getMapaValorCampo().get(textoDescricaoCampo);
            Boolean valido = UtilDominioCamposDeLeiaute.getInstancia().isCampoObrigatorio(camposLeiauteTO);
            if (valido == null || !valido.booleanValue() || !UtilString.isVazio((String)valor)) continue;
            throw new RegistroRejeitadoException("obrigatoriedade.invalida", camposLeiauteTO, valor);
        }
    }

    private void validaConvenio() throws RegistroRejeitadoException {
        String numeroConvenioStr = (String)this.getMapaValorCampo().get("NR_CVN");
        Integer numeroConvenio = UtilConversorDeInteger.converterParaInteger((String)numeroConvenioStr);
        ConvenenteTO convenenteTO = this.getConvenenteTOSelecionado();
        ConvenioTODecorator convenioTODecorator = this.getFabricaDeTO().novoConvenioTODecorator();
        convenioTODecorator.setNumeroConvenio(numeroConvenio);
        convenioTODecorator.setTextoIdentificadorServico(this.getServicoAtual());
        ConvenioTO convenioTO = this.getConvenioDAO().consultarPorConvenioServico(convenioTODecorator);
        if (this.isReferencia(convenioTO) && !convenioTO.getConvenenteTO().getCodigoPessoaConvenente().equals(convenenteTO.getCodigoPessoaConvenente())) {
            CamposLeiauteTO camposLeiauteTO = (CamposLeiauteTO)this.getMapaCamposLeiauteTO().get("NR_CVN");
            throw new RegistroRejeitadoException("conteudo.invalido", camposLeiauteTO, "N\u00famero do Conv\u00eanio " + numeroConvenioStr);
        }
    }

    private void validaSituacao() throws RegistroRejeitadoException {
        String codigoSituacaoRecebimento = (String)this.getMapaValorCampo().get("CD_EST_RCBT");
        if (UtilString.isVazio((String)codigoSituacaoRecebimento) || !UtilString.isStringsIguais((String)codigoSituacaoRecebimento, (String)"D") && !UtilString.isStringsIguais((String)codigoSituacaoRecebimento, (String)"O") && !UtilString.isStringsIguais((String)codigoSituacaoRecebimento, (String)"R")) {
            CamposLeiauteTO camposLeiauteTO = (CamposLeiauteTO)this.getMapaCamposLeiauteTO().get("CD_EST_RCBT");
            throw new RegistroRejeitadoException("conteudo.invalido", camposLeiauteTO, "Situa\u00e7\u00e3o lan\u00e7amento " + codigoSituacaoRecebimento);
        }
    }

    private void incluiRemessaTO() {
        if (!this.getRemessaDAO().isExisteRemessa(this.getRemessaTO())) {
            this.getRemessaDAO().incluir((Object)this.getRemessaTO());
        }
    }

    protected void inicializaValores() {
        this.setMapaValorCampo(null);
        this.setMapaCamposLeiauteTO(null);
        this.setPessoaTO(null);
        this.setRemessaTO(null);
        this.setRecebimentoDebitoTO(null);
        this.setColecaoRegistroRejeitadoTO(null);
    }

    private void criaRecebimentoDebitoTO() {
        String codigoSituacaoRecebimentoStr = (String)this.getMapaValorCampo().get("CD_EST_RCBT");
        String dataRecebimentoStr = (String)this.getMapaValorCampo().get("DT_RCBT");
        String valorRecebimentoStr = (String)this.getMapaValorCampo().get("VL_RCBT");
        String codigoDoBancoDeLiquida\u00e7\u00e3oStr = (String)this.getMapaValorCampo().get("CD_BCO_LQDC");
        String codigoAgenciadeLiquidacaoStr = (String)this.getMapaValorCampo().get("CD_AG_LQDC");
        String codigoContaCorrenteLiquidacaoStr = (String)this.getMapaValorCampo().get("CD_CC_LQDC");
        String dataDebitoStr = (String)this.getMapaValorCampo().get("DT_DEB");
        String valorDebitoStr = (String)this.getMapaValorCampo().get("VL_DEB");
        String textoIdentificadorDebitoStr = (String)this.getMapaValorCampo().get("TX_IDFC_DEB");
        String codigoDoBancoDebitadoStr = (String)this.getMapaValorCampo().get("CD_IFC_CLI");
        String codigoDoAgenciaDebitadoStr = (String)this.getMapaValorCampo().get("CD_AG_CLI");
        String codigoDoContaCorrenteDebitadoStr = (String)this.getMapaValorCampo().get("CD_CC_CLI");
        this.setRecebimentoDebitoTO(this.getFabricaDeTO().novoRecebimentoDebitoTO());
        RecebimentoDebitoTO recebimentoDebitoTO = this.getRecebimentoDebitoTO();
        recebimentoDebitoTO.setRemessaTO(this.getRemessaTO());
        recebimentoDebitoTO.setSituacaoRecebimentoTO(this.getFabricaDeTO().novoSituacaoRecebimentoTO());
        recebimentoDebitoTO.getSituacaoRecebimentoTO().setCodigoSituacaoRecebimento(new Character(codigoSituacaoRecebimentoStr.toCharArray()[0]));
        recebimentoDebitoTO.setDataRecebimento(UtilConversorDeData.converter((String)dataRecebimentoStr, (String)"ddMMyyyy"));
        recebimentoDebitoTO.setValorRecebimento(UtilConversorDeString.converterParaBigDecimal((String)valorRecebimentoStr, (int)2));
        recebimentoDebitoTO.setCodigoContaCorrenteLiquidacao(UtilConversorDeInteger.converterParaInteger((String)codigoContaCorrenteLiquidacaoStr));
        recebimentoDebitoTO.setCodigoAgenciaLiquidacao(UtilConversorDeInteger.converterParaInteger((String)codigoAgenciadeLiquidacaoStr));
        recebimentoDebitoTO.setCodigoBancoLiquidacao(UtilConversorDeInteger.converterParaInteger((String)codigoDoBancoDeLiquida\u00e7\u00e3oStr));
        recebimentoDebitoTO.setDataDebito(UtilConversorDeData.converter((String)dataDebitoStr, (String)"ddMMyyyy"));
        recebimentoDebitoTO.setValorDebito(UtilConversorDeString.converterParaBigDecimal((String)valorDebitoStr, (int)2));
        recebimentoDebitoTO.setCodigoAgenciaDebito(UtilConversorDeInteger.converterParaInteger((String)codigoDoContaCorrenteDebitadoStr));
        recebimentoDebitoTO.setCodigoAgenciaDebito(UtilConversorDeInteger.converterParaInteger((String)codigoDoAgenciaDebitadoStr));
        recebimentoDebitoTO.setCodigoBancoDebito(UtilConversorDeInteger.converterParaInteger((String)codigoDoBancoDebitadoStr));
        recebimentoDebitoTO.setIdentificadorClienteDebitoTO(this.getIdentificadorClienteDebitoDAO().listarPeloIdentificador(textoIdentificadorDebitoStr));
        recebimentoDebitoTO.setRemessaTO(this.getRemessaTO());
        recebimentoDebitoTO.setConvenioDebitoTO(this.getFabricaDeTO().novoConvenioDebitoTO());
        recebimentoDebitoTO.getConvenioDebitoTO().getId().setCodigoPessoaConvenente(Integer.valueOf(this.getRemessaTO().getId().getCodigoPessoaConvenente()));
        recebimentoDebitoTO.getConvenioDebitoTO().getId().setNumeroConvenio(Integer.valueOf(this.getRemessaTO().getId().getNumeroConvenio()));
        recebimentoDebitoTO.getConvenioDebitoTO().getId().setTextoIdentificadorServico(this.getRemessaTO().getId().getTextoIdentificadorServico());
    }

    private void criaRemessaTO() {
        String numeroDaRemessaStr = (String)this.getMapaValorCampo().get("NR_RMS");
        String numeroDoConvenioStr = (String)this.getMapaValorCampo().get("NR_CVN");
        Integer codigoPessoaConvenente = this.getConvenenteTOSelecionado().getCodigoPessoaConvenente();
        String dataRemessaStr = (String)this.getMapaValorCampo().get("DT_RMS");
        String codigoRetornoStr = (String)this.getMapaValorCampo().get("CD_RTN");
        String textoTipoDoRetornoStr = (String)this.getMapaValorCampo().get("TX_TIP_RTN");
        this.setRemessaTO(this.getFabricaDeTO().novoRemessaTO());
        RemessaTO remessaTO = this.getRemessaTO();
        RemessaTOId id = this.getFabricaDeTO().novoRemessaTOId();
        id.setNumeroRemessa(UtilConversorDeInteger.converterParaInteger((String)numeroDaRemessaStr));
        id.setNumeroConvenio(UtilConversorDeInteger.converterParaPrimitivo((String)numeroDoConvenioStr));
        id.setCodigoPessoaConvenente(UtilConversorDeInteger.converterParaPrimitivo((Integer)codigoPessoaConvenente));
        id.setTextoIdentificadorServico(this.getServicoAtual());
        remessaTO.setId(id);
        remessaTO.getId().setDataRemessa(UtilConversorDeData.converter((String)dataRemessaStr, (String)"ddMMyyyy"));
        remessaTO.setCodigoRetorno(UtilConversorDeInteger.converterParaInteger((String)codigoRetornoStr));
        remessaTO.setTipoRetornoTO(this.getFabricaDeTO().novoTipoRetornoTO());
        remessaTO.getTipoRetornoTO().setTextoTipoRetorno(textoTipoDoRetornoStr.charAt(0));
        remessaTO.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
    }

    public ConvenioDAO getConvenioDAO() {
        return this.convenioDAO;
    }

    public void setConvenioDAO(ConvenioDAO convenioDAO) {
        this.convenioDAO = convenioDAO;
    }

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public RecebimentoDebitoTO getRecebimentoDebitoTO() {
        return this.recebimentoDebitoTO;
    }

    public void setRecebimentoDebitoTO(RecebimentoDebitoTO recebimentoDebitoTO) {
        this.recebimentoDebitoTO = recebimentoDebitoTO;
    }

    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }
}

