/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.util.dominio;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.politec.generico.excecao.UtilExcecao;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;
import net.sf.jasperreports.view.JasperViewer;

public class UtilDominioImprimir {
    private JasperPrint impressao;
    private JasperViewer jrviewer;

    public JasperViewer imprimir(String caminhoDoRelatorio, Map parametrosFixos, List listaParaImprimir, String mensagemDeEstouroDeMemorio, String mensagemDeListaVazia) {
        try {
            if (listaParaImprimir.isEmpty()) {
                BBJPopupMensagem.exibirMensagemAlerta((String)mensagemDeListaVazia);
            } else {
                this.impressao = UtilRelatorioJasper.imprimirRelatorio((String)caminhoDoRelatorio, (Map)parametrosFixos, (Collection)listaParaImprimir);
                this.jrviewer = new JasperViewer(this.impressao, false);
                this.jrviewer.setIconImage(new ImageIcon(this.getClass().getResource("/images/BBRelatorio.gif")).getImage());
                this.jrviewer.setTitle("Banco do Brasil");
            }
        }
        catch (BBException e) {
            this.processarMensagemDeErro(null, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro(null, e);
        }
        catch (OutOfMemoryError e) {
            BBJPopupMensagem.exibirMensagemErro((String)mensagemDeEstouroDeMemorio);
        }
        return this.jrviewer;
    }

    public JRViewer imprimirViewer(String caminhoDoRelatorio, Map parametrosFixos, List listaParaImprimir, String mensagemDeEstouroDeMemorio, String mensagemDeListaVazia) {
        JRViewer viewer = null;
        try {
            if (listaParaImprimir.isEmpty()) {
                BBJPopupMensagem.exibirMensagemAlerta((String)mensagemDeListaVazia);
            } else {
                this.impressao = UtilRelatorioJasper.imprimirRelatorio((String)caminhoDoRelatorio, (Map)parametrosFixos, (Collection)listaParaImprimir);
                viewer = new JRViewer(this.impressao);
            }
        }
        catch (BBException e) {
            this.processarMensagemDeErro(null, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro(null, e);
        }
        catch (OutOfMemoryError e) {
            BBJPopupMensagem.exibirMensagemErro((String)mensagemDeEstouroDeMemorio);
        }
        return viewer;
    }

    protected void processarMensagemDeErro(IFormulario frame, Throwable e) {
        String erro = UtilExcecao.getMensagem((Throwable)e);
        String mensagem = UtilMensagem.getInstancia().getErroDeSistema(erro);
        BBJPopupMensagem.exibirMensagemErro((String)mensagem);
    }
}

