/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.util.objecttablemodel;

import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.swing.componente.IObjectTableModel;
import br.com.politec.generico.excecao.FormatadorException;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import br.com.politec.generico.formatador.instancia.FormatadorDeDataParaPadrao;
import br.com.politec.infra.util.UtilLog;
import java.util.Date;
import java.util.Map;

public class IObjectRecebimento
extends IObjectTableModel {
    private RecebimentoDebitoTO debitoTO;
    private Map<Integer, String> mapaDasColunas;

    public IObjectRecebimento(RecebimentoDebitoTO debitoTO) {
        this.setDebitoTO(debitoTO);
    }

    public Object getColumn(int column) {
        switch (column) {
            case 0: {
                return this.getDebitoTO().getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome();
            }
            case 1: {
                return this.getDebitoTO().getConvenioDebitoTO().getId().getNumeroConvenio();
            }
            case 2: {
                return this.formatarData(this.getDebitoTO().getDataRecebimento());
            }
            case 3: {
                return this.getDebitoTO().getSituacaoRecebimentoTO().getTextoDescricao();
            }
            case 4: {
                return this.getDebitoTO().getRemessaTO() != null ? this.formatarData(this.getDebitoTO().getRemessaTO().getId().getDataRemessa()) : "";
            }
            case 5: {
                return UtilFormatadorDeReal.formatarParaMonetario((Number)this.getDebitoTO().getValorRecebimento());
            }
        }
        return "";
    }

    private String formatarData(Date data) {
        FormatadorDeDataParaPadrao dataParaPadrao = new FormatadorDeDataParaPadrao();
        String retorno = "";
        try {
            retorno = dataParaPadrao.formatar((Object)data);
        }
        catch (FormatadorException e) {
            UtilLog.getLog().debug((Throwable)e);
        }
        return retorno;
    }

    public PluginTOAbstrato getTO() {
        return this.getDebitoTO();
    }

    public RecebimentoDebitoTO getDebitoTO() {
        return this.debitoTO;
    }

    public void setDebitoTO(RecebimentoDebitoTO debitoTO) {
        this.debitoTO = debitoTO;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.debitoTO == null ? 0 : this.debitoTO.getNumeroRecebimento());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IObjectRecebimento other = (IObjectRecebimento)((Object)obj);
        return !(this.debitoTO == null ? other.debitoTO != null : !this.mesmo(other));
    }

    private boolean mesmo(IObjectRecebimento other) {
        return this.getDebitoTO().getNumeroRecebimento().equals(other.getDebitoTO().getNumeroRecebimento());
    }
}

