/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.util.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.executarexpurgodebitoemconta.action.ConsultarListaExpurgoDebitoAction;
import br.com.bb.plugins.dbt.apresentacao.executarexpurgodebitoemconta.action.ExecutarExpurgoDebitoEmContaAction;
import br.com.bb.plugins.dbt.apresentacao.executarexpurgodebitoemconta.form.ExecutarExpurgoDebitoEmContaForm;
import br.com.bb.plugins.dbt.util.objecttablemodel.DadosExpurgo;
import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableScrollPane;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewExpurgarRecebimentos
extends DBTBasicInternalFrame
implements Observer {
    private JPanel panelPrincipal = null;
    private BBJPanelBotoesManut panelBotoes = null;
    private JPanel panelTitulo = null;
    private JPanel panelDados = null;
    private JPanel panelDadosTBL = null;
    private final String[] columnNames = new String[]{"Nome", "Conv\u00eanio", "Data", "Situa\u00e7\u00e3o", "Valor"};
    private final int[] columnSizes = new int[]{330, 70, 100, 100, 150};
    private final int[] columnAligment = new int[]{2, 2, 2, 2, 4};
    private BBJTableScrollPane<DadosExpurgo> tabelaExpurgos;
    private JPanel panelProgresso = null;
    private BBJProgressBar bbprogress;
    private BBJLabel filtroDaData;
    private BBJButton bntConfirmar;
    private BBJButton bntVoltar;
    private BBJButton bntMarcarTodos;
    private BBJButton bntDesmarcarTodos;

    public ViewExpurgarRecebimentos() {
        super("Lista de Lan\u00e7amentos para Expurgo", false, false);
        this.initialize();
    }

    private void initialize() {
        this.add(this.getJPMain());
    }

    public JPanel getJPMain() {
        if (!this.isReferencia(this.panelPrincipal)) {
            this.panelPrincipal = this.getPainelFactory().novoJPainel();
            this.panelPrincipal.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.panelPrincipal.setBackground(Color.WHITE);
            this.panelPrincipal.add((Component)this.getPanelDados(), "North");
            this.panelPrincipal.add((Component)this.getPanelBotoes(), "Center");
            this.getPanelProgresso().setVisible(false);
        }
        return this.panelPrincipal;
    }

    public JPanel getPanelDados() {
        if (!this.isReferencia(this.panelDados)) {
            this.panelDados = this.getPainelFactory().novoJPainel();
            this.panelDados.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.panelDados.setOpaque(false);
            this.panelDados.add((Component)this.getPanelTitulo(), "First");
            this.panelDados.add((Component)this.getPanelDadosTBL(), "Center");
            this.panelDados.add((Component)this.getPanelProgresso(), "South");
            this.panelDados.setPreferredSize(new Dimension(0, 400));
        }
        return this.panelDados;
    }

    public BBJPanelBotoesManut getPanelBotoes() {
        if (!this.isReferencia(this.panelBotoes)) {
            this.panelBotoes = new BBJPanelBotoesManut(-1);
            this.panelBotoes.removeAll();
            this.panelBotoes.add((Component)this.getBntConfirmar());
            this.panelBotoes.add((Component)this.getBntMarcarTodos());
            this.panelBotoes.add((Component)this.getBntDesmarcarTodos());
            this.panelBotoes.add((Component)this.getBntVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBntConfirmar() {
        if (!this.isReferencia(this.bntConfirmar)) {
            ExecutarExpurgoDebitoEmContaAction acao = this.getDBTActionFactory().novoExecutarExpurgoDebitoEmContaAction();
            this.bntConfirmar = this.getBotaoFactory().novoConfirmar((PluginActionAbstrato)acao);
        }
        return this.bntConfirmar;
    }

    public BBJButton getBntMarcarTodos() {
        if (!this.isReferencia(this.bntMarcarTodos)) {
            this.bntMarcarTodos = this.getBotaoFactory().novoBotao("MARCAR TODOS", this.marcarTodos(true));
        }
        return this.bntMarcarTodos;
    }

    public BBJButton getBntDesmarcarTodos() {
        if (!this.isReferencia(this.bntDesmarcarTodos)) {
            this.bntDesmarcarTodos = this.getBotaoFactory().novoBotao("DESMARCAR TODOS", this.marcarTodos(false));
        }
        return this.bntDesmarcarTodos;
    }

    public BBJButton getBntVoltar() {
        if (!this.isReferencia(this.bntVoltar)) {
            this.bntVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.bntVoltar;
    }

    public JPanel getPanelTitulo() {
        if (!this.isReferencia(this.panelTitulo)) {
            this.panelTitulo = this.getPainelFactory().novoJPainel();
            this.panelTitulo.setOpaque(false);
            this.panelTitulo.setLayout(this.getLayoutFactory().novoBoxLayout((Container)this.panelTitulo, 0));
            this.panelTitulo.add(Box.createRigidArea(this.getLayoutFactory().novoDimension(12, 0)));
            this.panelTitulo.add((Component)this.getFiltroDaData());
            this.panelTitulo.setPreferredSize(this.getLayoutFactory().novoDimension(200, 20));
            this.panelTitulo.setSize(this.getLayoutFactory().novoDimension(200, 20));
        }
        return this.panelTitulo;
    }

    public JPanel getPanelProgresso() {
        if (!this.isReferencia(this.panelProgresso)) {
            this.panelProgresso = this.getPainelFactory().novoJPainel();
            this.panelProgresso.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.panelProgresso.setOpaque(false);
            this.panelProgresso.setBorder(BBJBordaOval.createOvalBorder((String)"Progresso", (int)10));
            JPanel panel = this.getPainelFactory().novoJPainel();
            panel.setLayout(this.getLayoutFactory().novoBorderLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getBbprogress(), "North");
            this.panelProgresso.add((Component)panel, "Center");
        }
        return this.panelProgresso;
    }

    public void doShow(Map context) {
        this.getBbprogress().setValoratual(0L);
        this.getBbprogress().updateUI();
        this.setVisible(true);
        ExecutarExpurgoDebitoEmContaForm form = (ExecutarExpurgoDebitoEmContaForm)this.novoForm();
        this.getBntConfirmar().requestFocus();
    }

    public void doClose(Map context) {
        this.setVisible(false);
        super.doClose(context);
    }

    private JPanel getPanelDadosTBL() {
        if (!this.isReferencia(this.panelDadosTBL)) {
            Dimension d = new Dimension(0, 400);
            this.panelDadosTBL = this.getPainelFactory().novoJPainel();
            this.panelDadosTBL.setSize(d);
            this.panelDadosTBL.setPreferredSize(d);
            this.panelDadosTBL.setMaximumSize(d);
            this.panelDadosTBL.setMinimumSize(d);
            this.panelDadosTBL.setLayout(new BorderLayout());
            this.panelDadosTBL.add((Component)this.getTabelaExpurgos(), "Center");
            this.panelDadosTBL.setBorder(BBJBordaOval.createOvalBorder());
            this.panelDadosTBL.setOpaque(false);
        }
        return this.panelDadosTBL;
    }

    private void setDimension(Dimension dim, JPanel pnl) {
        pnl.setPreferredSize(dim);
        pnl.setMaximumSize(dim);
        pnl.setMinimumSize(dim);
        pnl.setSize(dim);
    }

    public BBJTableScrollPane<DadosExpurgo> getTabelaExpurgos() {
        if (!this.isReferencia(this.tabelaExpurgos)) {
            this.tabelaExpurgos = new BBJTableScrollPane(this.columnNames, this.columnSizes, this.columnAligment, 10);
            BBJTable tableModel = this.tabelaExpurgos.getBbtModel();
            this.tabelaExpurgos.setName("listaRecebimentos");
            tableModel.setNomeColunas(new String[]{"identificadorClienteDebitoTO.pessoaTO.textoNome", "identificadorClienteDebitoTO.convenioDebitoTO.convenioTO.numeroConvenio", "dataRecebimento", "situacaoRecebimentoTO.textoDescricao", "valorRecebimento"});
            tableModel.setOrdenacaoAutomatica(false);
            tableModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                        ViewExpurgarRecebimentos.this.ordenarTabela();
                    }
                }
            });
        }
        return this.tabelaExpurgos;
    }

    private void ordenarTabela() {
        BBJTable bbtModel = this.getTabelaExpurgos().getBbtModel();
        this.getExecutarExpurgoDebitoEmContaForm().getRecebimentoDebitoTODecorator().setNomeColunaOrdenada(bbtModel.getNomeColunaOrdenada());
        this.getExecutarExpurgoDebitoEmContaForm().getRecebimentoDebitoTODecorator().setTipoOrdenacao(bbtModel.getTipoordenacao());
        this.consultarListaExpurgo();
        this.preencheListaExpurgo();
    }

    public BBJProgressBar getBbprogress() {
        if (!this.isReferencia(this.bbprogress)) {
            this.bbprogress = new BBJProgressBar(100L);
        }
        return this.bbprogress;
    }

    private BasicInternalFrame instance() {
        return this;
    }

    public void inicializaTela() {
        this.getBntConfirmar().setEnabled(true);
        this.limpaTabelaDaDados();
        this.consultarListaExpurgo();
        this.getExecutarExpurgoDebitoEmContaForm().getRecebimentoDebitoTODecorator().getNotificaExpurgoDebitoEmConta().addObserver((Observer)this);
        String filtroData = "Filtro da Data : " + this.getDataInicio() + " a " + this.getDataFim();
        this.getFiltroDaData().setText(filtroData);
        this.preencheListaExpurgo();
        this.getBntConfirmar().requestFocus();
    }

    public void preencheListaExpurgo() {
        Collection<RecebimentoDebitoTO> listaRecebimentos = this.getExecutarExpurgoDebitoEmContaForm().getColecaoRecebimentos();
        this.getExecutarExpurgoDebitoEmContaForm().getRecebimentoDebitoTODecorator().setColecaoRecebimentos(listaRecebimentos);
        List dadosExpurgo = this.getColecaoFactory().novoArrayList();
        if (UtilColecao.isVazio(listaRecebimentos)) {
            this.getBntConfirmar().setEnabled(false);
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP004"));
        } else {
            for (RecebimentoDebitoTO recebimento : listaRecebimentos) {
                dadosExpurgo.add(new DadosExpurgo(recebimento));
            }
        }
        this.getTabelaExpurgos().getBbtModel().setDataListTabela(dadosExpurgo);
    }

    public void limpaTabelaDaDados() {
        List dados = this.getColecaoFactory().novoArrayList();
        this.getTabelaExpurgos().getBbtModel().setDataListTabela(dados);
    }

    public BBJLabel getFiltroDaData() {
        if (!this.isReferencia(this.filtroDaData)) {
            this.filtroDaData = this.getPainelFactory().novoBBJLabel("");
        }
        return this.filtroDaData;
    }

    public void preExecucaoExecutarExpurgoDebitoEmContaAction() {
        this.getPanelProgresso().setVisible(true);
    }

    public void consultarListaExpurgo() {
        try {
            this.getConsultarListaExpurgoDebitoAction().executar(this.getExecutarExpurgoDebitoEmContaForm());
        }
        catch (BBException e) {
            e.printStackTrace();
        }
    }

    public ConsultarListaExpurgoDebitoAction getConsultarListaExpurgoDebitoAction() {
        return this.getDBTActionFactory().novoConsultarListaExpurgoDebitoAction();
    }

    protected PluginFormAbstrato novoForm() {
        return (ExecutarExpurgoDebitoEmContaForm)this.getFormAnterior();
    }

    public ExecutarExpurgoDebitoEmContaForm getExecutarExpurgoDebitoEmContaForm() {
        return (ExecutarExpurgoDebitoEmContaForm)this.getForm();
    }

    public String getDataInicio() {
        return UtilFormatadorDeData.formatar_ddMMyyyy((Date)this.getExecutarExpurgoDebitoEmContaForm().getDataRecebimentoInicial());
    }

    public String getDataFim() {
        return UtilFormatadorDeData.formatar_ddMMyyyy((Date)this.getExecutarExpurgoDebitoEmContaForm().getDataRecebimentoFinal());
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        Integer porcentagem = (Integer)arg1;
        this.atualizaProgressBar(porcentagem);
    }

    private void atualizaProgressBar(Integer porcentagem) {
        this.getBbprogress().setValoratual((long)porcentagem.intValue());
        this.getBbprogress().updateUI();
    }

    public void posExecucaoFecharAction() {
        super.posExecucaoFecharAction();
    }

    public void posExecucaoExecutarExpurgoDebitoEmContaAction() {
        this.consultarListaExpurgo();
        this.atualizaTabela();
        this.getExecutarExpurgoDebitoEmContaForm().setPaginaAtual(0);
        Collection<RecebimentoDebitoTO> listaRecebimentos = this.getExecutarExpurgoDebitoEmContaForm().getColecaoRecebimentos();
        this.getExecutarExpurgoDebitoEmContaForm().getRecebimentoDebitoTODecorator().setColecaoRecebimentos(listaRecebimentos);
        if (UtilColecao.isVazio(listaRecebimentos)) {
            this.getBntConfirmar().setEnabled(false);
        }
        BBJPopupMensagem.exibirMensagem((String)this.getUtilMensagem().getMensagem("MP012"));
    }

    public void posExecucaoFinalExecutarExpurgoDebitoEmContaAction() {
        this.getPanelProgresso().setVisible(false);
    }

    public void atualizaTabela() {
        Collection<RecebimentoDebitoTO> listaRecebimentos = this.getExecutarExpurgoDebitoEmContaForm().getColecaoRecebimentos();
        this.getExecutarExpurgoDebitoEmContaForm().getRecebimentoDebitoTODecorator().setColecaoRecebimentos(listaRecebimentos);
        List dadosExpurgo = this.getColecaoFactory().novoArrayList();
        for (RecebimentoDebitoTO recebimento : listaRecebimentos) {
            dadosExpurgo.add(new DadosExpurgo(recebimento));
        }
        this.getTabelaExpurgos().getBbtModel().setDataListTabela(dadosExpurgo);
    }

    private PluginActionAbstrato marcarTodos(final boolean marcar) {
        return new PluginActionAbstrato(){

            public String executar(PluginFormAbstrato form) throws BBException {
                ViewExpurgarRecebimentos.this.getTabelaExpurgos().getBbtModel().marcaTodos(marcar);
                return null;
            }
        };
    }
}

