/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util;

import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.validador.UtilValidadorDeInteiro;
import br.com.politec.infra.util.UtilLog;
import java.security.InvalidParameterException;

public class CalculaDigitoVerificador {
    private String dv;
    private String dvCC;

    public static String calcularModulo10(String valor) throws InvalidParameterException {
        String dvCalculado = "";
        int soma = 0;
        int somaParcial = 0;
        int mult = 2;
        if (valor == null || valor.compareTo("") == 0) {
            throw new InvalidParameterException("Valor nao informado");
        }
        int tamValor = valor.length();
        int i = tamValor - 1;
        while (i >= 0) {
            if (!Character.isDigit(valor.charAt(i))) {
                throw new InvalidParameterException("Valor contem caracteres invalidos");
            }
            somaParcial = Integer.parseInt(valor.substring(i, i + 1)) * mult;
            if (somaParcial > 9) {
                somaParcial -= 9;
            }
            mult = mult == 2 ? 1 : 2;
            soma += somaParcial;
            --i;
        }
        int dv = 10 - soma % 10;
        if (dv == 10) {
            dv = 0;
        }
        dvCalculado = String.valueOf(dv);
        return dvCalculado;
    }

    public static String calcularModulo11(String valor) {
        int soma = 0;
        int mult = 9;
        if (valor == null || valor.compareTo("") == 0) {
            return "";
        }
        int tamValor = valor.length();
        int i = tamValor - 1;
        while (i >= 0) {
            if (!Character.isDigit(valor.charAt(i))) {
                return "";
            }
            soma += Integer.parseInt(valor.substring(i, i + 1)) * mult--;
            if (mult == 1) {
                mult = 9;
            }
            --i;
        }
        int dv = soma % 11;
        System.out.print(dv);
        String dvCalculado = dv == 10 ? "X" : String.valueOf(dv);
        return dvCalculado;
    }

    public static boolean isValidoModulo10(String valor, String dv) throws InvalidParameterException {
        boolean retorno = false;
        if (dv == null || dv.compareTo("") == 0) {
            return false;
        }
        String dvCalculado = CalculaDigitoVerificador.calcularModulo10(valor);
        System.out.println("Digito Modulo 10: (" + valor + ") " + dvCalculado);
        if (dv.compareTo(dvCalculado) == 0) {
            retorno = true;
        }
        return retorno;
    }

    public static boolean isValidoModulo11(String valor, String dv) throws InvalidParameterException {
        boolean retorno = false;
        if (CalculaDigitoVerificador.parseInt(valor) == 0 && CalculaDigitoVerificador.parseInt(dv) == 0) {
            return false;
        }
        if (dv == null || dv.compareTo("") == 0) {
            return false;
        }
        String dvCalculado = CalculaDigitoVerificador.calcularModulo11(valor);
        System.out.println("Digito Modulo 11: (" + valor + ") " + dvCalculado);
        if (dv.compareTo(dvCalculado) == 0) {
            retorno = true;
        }
        return retorno;
    }

    public static boolean verificaAgencia(String agencia, String dvag) {
        Long dvl = Long.parseLong(agencia);
        String dv = CalculaDigitoVerificador.calcularModulo11(dvl.toString());
        return dv.equals(dvag);
    }

    public static boolean verificaContaCorrente(String contaCorrente, String digitoConta) {
        Long dvl = Long.parseLong(contaCorrente);
        String digitoCalculado = CalculaDigitoVerificador.calcularModulo11(dvl.toString());
        return digitoCalculado.equals(digitoConta);
    }

    public String getDv() {
        return this.dv;
    }

    public void setDv(String dv) {
        this.dv = dv;
    }

    public String getDvCC() {
        return this.dvCC;
    }

    public void setDvCC(String dvCC) {
        this.dvCC = dvCC;
    }

    public String formatarPrefixoAgenciaSemDV(Number codPrefixo) {
        if (codPrefixo == null) {
            return "";
        }
        StringBuffer num = new StringBuffer(6);
        String dvF = null;
        try {
            num.append(Long.parseLong(codPrefixo.toString().trim()));
            dvF = codPrefixo.toString().length() < 5 ? CalculaDigitoVerificador.calcularModulo11(num.toString()) : num.toString().substring(4);
            this.setDv(dvF);
            while (num.length() < 5) {
                num.insert(0, '0');
            }
            num.insert(4, '-');
        }
        catch (Exception e) {
            return codPrefixo.toString();
        }
        return num.toString();
    }

    public String formatarContaCorrenteSemDV(String contaCorrente) {
        if (contaCorrente == null) {
            return "";
        }
        StringBuffer num = new StringBuffer(13);
        String dvf3 = null;
        try {
            num.append(Long.parseLong(contaCorrente));
            if (contaCorrente.toString().length() < 12) {
                String dvf1 = CalculaDigitoVerificador.calcularModulo11(contaCorrente.substring(0, contaCorrente.length() - 1));
                String dvf2 = CalculaDigitoVerificador.calcularModulo11(contaCorrente);
                dvf3 = contaCorrente.substring(contaCorrente.length() - 1);
                System.out.println("  dv1=" + dvf1 + "  ");
                System.out.println("  dv2=" + dvf2 + "  ");
                System.out.println("  dv3=" + dvf3 + "  ");
                if (!dvf1.equals(dvf2)) {
                    if (dvf1.equals(dvf3)) {
                        this.setDvCC(dvf3);
                    }
                } else {
                    this.setDvCC(dvf1);
                }
            }
            while (num.length() < 12) {
                num.insert(0, '0');
            }
            num.insert(11, '-');
        }
        catch (Exception e) {
            return contaCorrente.toString();
        }
        return num.toString();
    }

    public static boolean verificarCNPJ(String CNPJ) {
        if (CNPJ == null || CNPJ.length() != 14) {
            return false;
        }
        return CalculaDigitoVerificador.verificarCNPJCPF(CNPJ);
    }

    public static boolean verificarCPF(String CPF) {
        if (CPF == null || CPF.length() != 11) {
            return false;
        }
        return CalculaDigitoVerificador.verificarCNPJCPF(CPF);
    }

    public static boolean verificarCEI(String CEI) {
        return CalculaDigitoVerificador.isValidoCEI(CEI);
    }

    private static boolean isValidoCEI(String numeroCEI) {
        int digitoDois;
        if (numeroCEI == null || numeroCEI.length() < 11 || CalculaDigitoVerificador.parseLong(numeroCEI.substring(0, 2)) == 0L || !UtilValidadorDeInteiro.validar((String)numeroCEI)) {
            return false;
        }
        int digitoInformado = UtilConversorDeString.converterParaInt((String)(numeroCEI == null || numeroCEI.length() == 0 ? "" : numeroCEI.substring(numeroCEI.length() - 1, numeroCEI.length())));
        int[] nArray = new int[5];
        nArray[1] = 6;
        nArray[2] = 7;
        nArray[3] = 8;
        nArray[4] = 9;
        if (!CalculaDigitoVerificador.EstaNaMatriz(digitoInformado, nArray)) {
            return false;
        }
        byte[] tabelaPeso = new byte[]{7, 4, 1, 8, 5, 2, 1, 6, 3, 7, 4};
        int somaValores = 0;
        int icnt = 0;
        while (icnt < 11) {
            somaValores += UtilConversorDeString.converterParaInt((String)numeroCEI.substring(icnt, icnt + 1)) * tabelaPeso[icnt];
            ++icnt;
        }
        String somaString = "" + somaValores;
        int digitoUm = UtilConversorDeString.converterParaInt((String)somaString.substring(somaString.length() - 1, somaString.length()));
        String somaDigitos = "" + (digitoUm + (digitoDois = UtilConversorDeString.converterParaInt((String)somaString.substring(somaString.length() - 2, somaString.length() - 1))));
        String digitoVerificadorString = "" + (10 - UtilConversorDeString.converterParaInt((String)somaDigitos.substring(somaDigitos.length() - 1, somaDigitos.length())));
        int digitoVerificador = UtilConversorDeString.converterParaInt((String)digitoVerificadorString.substring(digitoVerificadorString.length() - 1, digitoVerificadorString.length()));
        return digitoInformado == digitoVerificador;
    }

    private static boolean EstaNaMatriz(int valorInt, int[] matrizValores) {
        int icnt = 0;
        while (icnt < matrizValores.length) {
            if (valorInt == matrizValores[icnt]) {
                return true;
            }
            ++icnt;
        }
        return false;
    }

    private static boolean isValidoReferencia(String numeroReferencia) {
        if (numeroReferencia == null || numeroReferencia.length() < 13 || !UtilValidadorDeInteiro.validar((String)numeroReferencia) || CalculaDigitoVerificador.parseLong(numeroReferencia) <= 0L) {
            return false;
        }
        int digitoInformado = UtilConversorDeString.converterParaInt((String)(numeroReferencia == null || numeroReferencia.length() == 0 ? "" : numeroReferencia.substring(numeroReferencia.length() - 1, numeroReferencia.length())));
        byte[] tabelaPeso = new byte[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int somaValores = 0;
        int icnt = 0;
        while (icnt < 13) {
            somaValores += UtilConversorDeString.converterParaInt((String)numeroReferencia.substring(icnt, icnt + 1)) * tabelaPeso[icnt];
            ++icnt;
        }
        int restoDivisao = somaValores % 11;
        int digitoVerificador = 0;
        if (restoDivisao != 0 && restoDivisao != 1) {
            digitoVerificador = 11 - restoDivisao;
        }
        return digitoInformado == digitoVerificador;
    }

    private static boolean isValidoTituloCobranca(String numeroTitulo) {
        if (UtilValidadorDeInteiro.validar((String)numeroTitulo) && CalculaDigitoVerificador.parseLong(numeroTitulo) == 0L) {
            return false;
        }
        if (numeroTitulo == null || numeroTitulo.length() < 13 || UtilConversorDeString.converterParaInt((String)numeroTitulo.substring(0, 9)) == 0 || !CalculaDigitoVerificador.TemSoNumeros(numeroTitulo.substring(9)) || !UtilValidadorDeInteiro.validar((String)numeroTitulo)) {
            return false;
        }
        int digitoInformado = UtilConversorDeString.converterParaInt((String)(numeroTitulo == null || numeroTitulo.length() == 0 ? "" : numeroTitulo.substring(numeroTitulo.length() - 1, numeroTitulo.length())));
        byte[] tabelaPeso = new byte[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int somaValores = 0;
        int icnt = 0;
        while (icnt < 13) {
            somaValores += UtilConversorDeString.converterParaInt((String)numeroTitulo.substring(icnt, icnt + 1)) * tabelaPeso[icnt];
            ++icnt;
        }
        int restoDivisao = somaValores % 11;
        int digitoVerificador = 0;
        if (restoDivisao != 0 && restoDivisao != 1) {
            digitoVerificador = 11 - restoDivisao;
        }
        return digitoInformado == digitoVerificador;
    }

    private static boolean TemSoNumeros(String textoString) {
        if (textoString != null && textoString.length() > 0) {
            int icnt = 0;
            while (icnt < textoString.length()) {
                int[] nArray = new int[10];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                nArray[8] = 8;
                nArray[9] = 9;
                if (!CalculaDigitoVerificador.EstaNaMatriz(UtilConversorDeString.converterParaInt((String)textoString.substring(icnt, icnt + 1)), nArray)) {
                    return false;
                }
                ++icnt;
            }
        }
        return true;
    }

    private static boolean isValidoDEBCAD(String numeroDEBCAD) {
        if (numeroDEBCAD == null || numeroDEBCAD.length() < 8 || CalculaDigitoVerificador.parseLong(numeroDEBCAD.trim()) == 0L) {
            return false;
        }
        int digitoInformado = UtilConversorDeString.converterParaInt((String)(numeroDEBCAD == null || numeroDEBCAD.length() == 0 ? "" : numeroDEBCAD.substring(numeroDEBCAD.length() - 1, numeroDEBCAD.length())));
        byte[] tabelaPeso = new byte[]{9, 8, 7, 6, 5, 4, 3, 2};
        int somaValores = 0;
        int icnt = 0;
        while (icnt < 8) {
            somaValores += UtilConversorDeString.converterParaInt((String)numeroDEBCAD.substring(icnt, icnt + 1)) * tabelaPeso[icnt];
            ++icnt;
        }
        int restoDivisao = somaValores % 11;
        int digitoVerificador = 0;
        if (restoDivisao != 0 && restoDivisao != 1) {
            digitoVerificador = 11 - restoDivisao;
        }
        return digitoInformado == digitoVerificador;
    }

    private static boolean isValidoNB(String numeroNB) {
        if (numeroNB == null || numeroNB.length() < 9 || CalculaDigitoVerificador.parseLong(numeroNB.trim()) == 0L) {
            return false;
        }
        int digitoInformado = UtilConversorDeString.converterParaInt((String)(numeroNB == null || numeroNB.length() == 0 ? "" : numeroNB.substring(numeroNB.length() - 1, numeroNB.length())));
        byte[] tabelaPeso = new byte[]{2, 9, 8, 7, 6, 5, 4, 3, 2};
        int somaValores = 0;
        int icnt = 0;
        while (icnt < 9) {
            somaValores += UtilConversorDeString.converterParaInt((String)numeroNB.substring(icnt, icnt + 1)) * tabelaPeso[icnt];
            ++icnt;
        }
        int restoDivisao = somaValores % 11;
        int digitoVerificador = 0;
        if (restoDivisao != 0 && restoDivisao != 1) {
            digitoVerificador = 11 - restoDivisao;
        }
        return digitoInformado == digitoVerificador;
    }

    public static boolean verificarNIT(String NIT) {
        return CalculaDigitoVerificador.verificarPASEP(NIT);
    }

    public static boolean verificarPIS(String PIS) {
        return CalculaDigitoVerificador.verificarPASEP(PIS);
    }

    public static boolean verificarPASEP(String PASEP) {
        if (UtilValidadorDeInteiro.validar((String)PASEP) && CalculaDigitoVerificador.parseLong(PASEP.trim()) == 0L) {
            return false;
        }
        return CalculaDigitoVerificador.calcularPASEP(PASEP.substring(0, PASEP.length() == 0 ? 0 : PASEP.length() - 1)).equals(PASEP.substring(PASEP.length() == 0 ? 0 : PASEP.length() - 1, PASEP.length()));
    }

    public static boolean verificarNB(String numeroNB) {
        return CalculaDigitoVerificador.isValidoNB(numeroNB);
    }

    public static boolean verificarTituloCobranca(String tituloCobranca) {
        return CalculaDigitoVerificador.isValidoTituloCobranca(tituloCobranca);
    }

    public static boolean verificarDEBCAD(String numeroDEBCAD) {
        return CalculaDigitoVerificador.isValidoDEBCAD(numeroDEBCAD);
    }

    public static boolean verificarReferencia(String ref) {
        return CalculaDigitoVerificador.isValidoReferencia(ref);
    }

    private static boolean verificarCNPJCPF(String cpfOrCnpj) {
        boolean isCpf;
        if (cpfOrCnpj == null || CalculaDigitoVerificador.parseLong(cpfOrCnpj.trim()) == 0L) {
            return false;
        }
        String n = cpfOrCnpj.replaceAll("[^0-9]*", "");
        boolean isCnpj = n.length() == 14;
        boolean bl = isCpf = n.length() == 11;
        if (!isCpf && !isCnpj) {
            return false;
        }
        int[] foundDv = new int[2];
        int dv1 = Integer.parseInt(String.valueOf(n.charAt(n.length() - 2)));
        int dv2 = Integer.parseInt(String.valueOf(n.charAt(n.length() - 1)));
        int j = 0;
        while (j < 2) {
            int sum = 0;
            int coeficient = 2;
            int i = n.length() - 3 + j;
            while (i >= 0) {
                int digit = Integer.parseInt(String.valueOf(n.charAt(i)));
                sum += digit * coeficient;
                if (++coeficient > 9 && isCnpj) {
                    coeficient = 2;
                }
                --i;
            }
            foundDv[j] = 11 - sum % 11;
            if (foundDv[j] >= 10) {
                foundDv[j] = 0;
            }
            ++j;
        }
        return dv1 == foundDv[0] && dv2 == foundDv[1];
    }

    public static String calcularPASEP(String pasep) {
        String pasepDv = "";
        int[] pasepParte = new int[10];
        int[] peso = new int[]{3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int soma = 0;
        if (pasep != null && pasep.length() == 10) {
            pasepParte[0] = CalculaDigitoVerificador.parseInt(pasep.substring(0, 1));
            pasepParte[1] = CalculaDigitoVerificador.parseInt(pasep.substring(1, 2));
            pasepParte[2] = CalculaDigitoVerificador.parseInt(pasep.substring(2, 3));
            pasepParte[3] = CalculaDigitoVerificador.parseInt(pasep.substring(3, 4));
            pasepParte[4] = CalculaDigitoVerificador.parseInt(pasep.substring(4, 5));
            pasepParte[5] = CalculaDigitoVerificador.parseInt(pasep.substring(5, 6));
            pasepParte[6] = CalculaDigitoVerificador.parseInt(pasep.substring(6, 7));
            pasepParte[7] = CalculaDigitoVerificador.parseInt(pasep.substring(7, 8));
            pasepParte[8] = CalculaDigitoVerificador.parseInt(pasep.substring(8, 9));
            pasepParte[9] = CalculaDigitoVerificador.parseInt(pasep.substring(9, 10));
            int i = 0;
            while (i < 10) {
                soma += pasepParte[i] * peso[i];
                ++i;
            }
            int Dv = 11 - soma % 11;
            if (Dv == 10 || Dv == 11) {
                Dv = 0;
            }
            pasepDv = String.valueOf(Dv);
        }
        return pasepDv;
    }

    private static int parseInt(String valor) {
        int num = 0;
        try {
            num = Integer.parseInt(valor);
        }
        catch (Exception ex) {
            UtilLog.getLog().debug((Throwable)ex);
        }
        return num;
    }

    private static long parseLong(String valor) {
        long num = 0L;
        try {
            num = Long.parseLong(valor);
        }
        catch (Exception ex) {
            UtilLog.getLog().debug((Throwable)ex);
        }
        return num;
    }

    public static String tirarTracoPonto(String valor) {
        if (valor == null) {
            return "";
        }
        String resultado = valor.replace("-", "").trim();
        resultado = resultado.replace("/", "");
        resultado = resultado.replace(".", "");
        resultado = resultado.replace(".", "");
        resultado = resultado.replace(".", "");
        resultado = resultado.replace(".", "");
        resultado = resultado.replace(".", "");
        return resultado;
    }
}

