/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util;

import br.com.bb.cdbb.excecao.BBException;
import br.com.bb.cdbb.util.Criptografia;
import br.com.bb.cdbb.util.FileUtils;
import br.com.bb.cdbb.util.Util;
import br.com.bb.cdbb.util.UtilMensagem;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.string.UtilString;
import br.com.politec.infra.util.UtilLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Properties;

public class ConfiguracaoProperties
extends Properties {
    private static final String DRIVER = "hibernate.jdbc.driver";
    private static final String DIALECT = "hibernate.dialect";
    private static final String POOL_SIZE = "hibernate.connection.pool_size";
    private static final String SHOW_SQL = "hibernate.show_sql";
    private static final String STATISTICS = "hibernate.generate_statistics";
    private static final String PROVIDER = "hibernate.cache.provider_class";
    private static final String URL = "hibernate.jdbc.url";
    private static final String URLCONTROLE = "hibernate.jdbc.url.controle";
    private static final String TIPOCONEXAOBANCODADOS = "hibernate.tipoinstalacaobancodados";
    private static final String LOCAL_BD = "diretorio.banco";
    private static final String NOME_HOST = "hibernate.rede.host";
    private static final String NOME_USUARIO = "campo1";
    private static final String SENHA = "campo2";
    private static final String PORTA = "rede.porta";
    private static final String DIR_BACKUP = "diretorio.copiaseguranca";
    private static final String DIR_RELATORIO = "diretorio.report";
    private static final String DIR_AJUDA = "diretorio.help";
    private static final String DIR_REMESSA = "diretorio.remessa";
    private static final String DIR_RETORNO = "diretorio.retorno";
    private static final String DIR_CONTRATO = "diretorio.contrato";
    private static final String DIR_EXISTENCIA = "diretorio.existencia";
    private static final String DIR_GEFIN = "diretorio.gefin";
    private static final String DIR_FIREBIRD = "diretorio.firebird";
    private static final String NOME_ARQUIVO_CONFIGURACAO = "BBGAC.properties";
    private static final String URL_ATUALIZAR_SISTEMA = "url.atualizar.sistema";
    private static final String URL_BANCO_RESTAURADO = "url.banco.restaurado";
    private String separadorArquivo = null;
    private String dirTemp = null;
    private String dirJava = null;
    private String dirProg = null;
    private String caminhoArquivoConfiguracao;
    private static ConfiguracaoProperties configuracaoProperties = null;

    public static ConfiguracaoProperties getConfiguracaoProperties() {
        if (configuracaoProperties == null) {
            configuracaoProperties = new ConfiguracaoProperties();
        }
        return configuracaoProperties;
    }

    public static void removerInstancia() {
        configuracaoProperties = null;
    }

    private ConfiguracaoProperties() {
        this.setDirJava(System.getProperty("java.home"));
        String s_dirtemp = String.valueOf(System.getProperty("user.dir").replaceAll("\\\\", "/")) + "/temp/";
        try {
            FileUtils.garantirPath(new File(String.valueOf(s_dirtemp) + "temp.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setDirTemp(s_dirtemp);
        this.setSeparadorArquivo(System.getProperty("file.separator"));
        this.initialize();
    }

    private void initialize() {
        this.carregaPropriedades();
    }

    public void setLocalBD(String localBD) {
        if (localBD != null) {
            this.setProperty(LOCAL_BD, localBD);
        }
    }

    public String getLocalBD() {
        return this.lerPropriedade(LOCAL_BD);
    }

    public String getDirRemessa() {
        return this.lerPropriedade(DIR_REMESSA);
    }

    public void setDirRemessa(String dirRemessa) {
        if (dirRemessa != null) {
            this.setProperty(DIR_REMESSA, dirRemessa);
        }
    }

    public void setDirRetorno(String dirRetorno) {
        if (dirRetorno != null) {
            this.setProperty(DIR_RETORNO, dirRetorno);
        }
    }

    public String getDirRetorno() {
        return this.lerPropriedade(DIR_RETORNO);
    }

    public String getDirGerFin() {
        return this.lerPropriedade(DIR_GEFIN);
    }

    public void setDirGerFin(String dirGerFin) {
        if (dirGerFin != null) {
            this.setProperty(DIR_GEFIN, dirGerFin);
        }
    }

    public String getDirAjuda() {
        return this.lerPropriedade(DIR_AJUDA);
    }

    public void setDirAjuda(String dirAjuda) {
        if (dirAjuda != null) {
            this.setProperty(DIR_AJUDA, dirAjuda);
        }
    }

    public String getDirFirebird() {
        return this.lerPropriedade(DIR_FIREBIRD);
    }

    public void setDirFirebird(String dirFirebird) {
        if (dirFirebird != null) {
            this.setProperty(DIR_FIREBIRD, dirFirebird);
        }
    }

    public String getDirContrato() {
        return this.lerPropriedade(DIR_CONTRATO);
    }

    public void setDirContrato(String dirContrato) {
        if (dirContrato != null) {
            this.setProperty(DIR_CONTRATO, dirContrato);
        }
    }

    public String getDirExistencia() {
        return this.lerPropriedade(DIR_EXISTENCIA);
    }

    public void setDirExistencia(String dirExistencia) {
        if (dirExistencia != null) {
            this.setProperty(DIR_EXISTENCIA, dirExistencia);
        }
    }

    public void setDirRelatorio(String dirRelat) {
        if (dirRelat != null) {
            this.setProperty(DIR_RELATORIO, dirRelat);
        }
    }

    public String getDirRelatorio() {
        return this.AdicionaSeparador(this.lerPropriedade(DIR_RELATORIO));
    }

    public void setDirBackup(String dirRelat) {
        if (dirRelat != null) {
            this.setProperty(DIR_BACKUP, dirRelat);
        }
    }

    public String getDirBackup() {
        return this.AdicionaSeparador(this.lerPropriedade(DIR_BACKUP));
    }

    private String AdicionaSeparador(String pasta) {
        if (!UtilString.isVazio((String)pasta)) {
            String separator = System.getProperties().getProperty("file.separator");
            if (pasta.length() > 0 && !pasta.endsWith(separator)) {
                pasta = String.valueOf(pasta) + separator;
            }
        }
        return pasta;
    }

    public void setNomeUsuario(String nomeUsuario) {
        if (nomeUsuario != null) {
            this.setProperty(NOME_USUARIO, Criptografia.cifrar(nomeUsuario));
        }
    }

    public String getNomeUsuario() {
        return Criptografia.decifrar(this.lerPropriedade(NOME_USUARIO));
    }

    public void setSenha(String senha) {
        if (senha != null) {
            this.setProperty(SENHA, Criptografia.cifrar(senha));
        }
    }

    public String getSenha() {
        return Criptografia.decifrar(this.lerPropriedade(SENHA));
    }

    public void setNomeHost(String nomeHost) {
        if (nomeHost != null) {
            this.setProperty(NOME_HOST, nomeHost);
        }
    }

    public String getNomeHost() {
        return this.lerPropriedade(NOME_HOST);
    }

    public void setUrl(String url) {
        if (url != null) {
            this.setProperty(URL, url);
        }
    }

    public String getUrl() {
        return this.lerPropriedade(URL);
    }

    public void setURLAtualizarSistema(String url) {
        if (url != null) {
            this.setProperty(URL_ATUALIZAR_SISTEMA, url);
        }
    }

    public String getURLAtualizarSistema() {
        return this.lerPropriedade(URL_ATUALIZAR_SISTEMA);
    }

    public void setUrlControle(String urlcontrole) {
        if (urlcontrole != null) {
            this.setProperty(URLCONTROLE, urlcontrole);
        }
    }

    public String getUrlControle() {
        return this.lerPropriedade(URLCONTROLE);
    }

    public void setTipoInstalacaoBancoDados(String tipoinstalacaobancodados) {
        if (tipoinstalacaobancodados != null) {
            this.setProperty(TIPOCONEXAOBANCODADOS, tipoinstalacaobancodados);
        }
    }

    public String getTipoInstalacaoBancoDados() {
        return this.lerPropriedade(TIPOCONEXAOBANCODADOS, "1");
    }

    public void setDriver(String driver) {
        if (driver != null) {
            this.setProperty(DRIVER, driver);
        }
    }

    public String getDriver() {
        return this.lerPropriedade(DRIVER);
    }

    public String getPorta() {
        return this.lerPropriedade(PORTA);
    }

    public void setPorta(String porta) {
        if (porta != null) {
            this.setProperty(PORTA, porta);
        }
    }

    public void setDialect(String dialect) {
        if (dialect != null) {
            this.setProperty(DIALECT, dialect);
        }
    }

    public void setPoolSize(String pool) {
        if (pool != null) {
            this.setProperty(POOL_SIZE, pool);
        }
    }

    public void setShowSql(String show) {
        if (show != null) {
            this.setProperty(SHOW_SQL, show);
        }
    }

    public void setStatistics(String st) {
        if (st != null) {
            this.setProperty(STATISTICS, st);
        }
    }

    public void setProvider(String pro) {
        if (pro != null) {
            this.setProperty(PROVIDER, pro);
        }
    }

    public String getBancoRestaurar() {
        return this.lerPropriedade(URL_BANCO_RESTAURADO);
    }

    public void setBancoRestaurar(String urlBanco) {
        if (urlBanco != null) {
            this.setProperty(URL_BANCO_RESTAURADO, urlBanco);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void carregaPropriedades() {
        try {
            stream = this.getInputStream();
            this.load(stream);
            return;
        }
        catch (Exception e) {
            UtilLog.getLog().debug((Throwable)e);
            transf = "BancoBrasil" + this.getSeparadorArquivo() + "BBTransf" + this.getSeparadorArquivo();
            s = new String[]{"campo1", "SYSDBA", "campo2", "masterkey", "hibernate.rede.host", "localhost", "rede.porta", "3060", "diretorio.remessa", String.valueOf(transf) + "Remessa", "diretorio.retorno", String.valueOf(transf) + "Retorno", "diretorio.contrato", String.valueOf(transf) + "Contrato", "diretorio.existencia", String.valueOf(transf) + "Existencia", "diretorio.gefin", "BancoBrasil" + this.getSeparadorArquivo() + "officePLUGIN"};
            i = 0;
            ** while (i < s.length - 1)
        }
lbl-1000:
        // 1 sources

        {
            this.setProperty(s[i], s[i + 1]);
            i += 2;
            continue;
        }
lbl15:
        // 1 sources

        s = null;
    }

    private InputStream getInputStream() {
        InputStream stream = UtilArquivo.getInputStream((String)this.getCaminhoArquivoConfiguracao());
        return stream;
    }

    public String[] getPropInfo() {
        return new String[]{this.getNomeUsuario(), this.getSenha(), this.getNomeHost(), this.getPorta(), this.getLocalBD(), this.getDirRelatorio(), this.getDirAjuda(), this.getDirRemessa(), this.getDirRetorno(), this.getDirContrato(), this.getDirExistencia(), this.getDirGerFin()};
    }

    public String[] getPropInfoInic() {
        return new String[]{this.getNomeUsuario(), this.getSenha(), this.getNomeHost(), this.getPorta(), this.getLocalBD(), this.getDirRelatorio(), this.getDirAjuda(), this.getDirRemessa(), this.getDirRetorno(), this.getDirContrato(), this.getDirGerFin()};
    }

    public void salvaPropriedades() throws BBException {
        try {
            String portaBancoDados = "";
            if (!"embedded".equals(this.getNomeHost())) {
                portaBancoDados = "/" + this.getPorta();
            }
            String s_url = "jdbc:firebirdsql:" + this.getNomeHost() + portaBancoDados + ":";
            String s_urlcontrole = "jdbc:firebirdsql:" + this.getNomeHost() + portaBancoDados + ":";
            if (Util.parseInt(this.getTipoInstalacaoBancoDados()) == 0) {
                s_url = String.valueOf(s_url) + "BBGACA";
                s_urlcontrole = String.valueOf(s_urlcontrole) + "BBGACC";
            } else {
                s_url = String.valueOf(s_url) + this.getLocalBD() + "\\" + "BBGACA.FDB";
                s_urlcontrole = String.valueOf(s_urlcontrole) + this.getLocalBD() + "\\" + "BBGACC.FDB";
            }
            this.setProperty(URL, s_url);
            this.setProperty(URLCONTROLE, s_urlcontrole);
            FileOutputStream stream = new FileOutputStream(this.getCaminhoArquivoConfiguracao());
            this.store(stream, "Arquivo de Configura\u00e7\u00e3o");
            stream = null;
        }
        catch (Exception e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public String getSeparadorArquivo() {
        return this.separadorArquivo;
    }

    public void setSeparadorArquivo(String string) {
        this.separadorArquivo = string;
    }

    public String getDirTemp() {
        return this.dirTemp;
    }

    public void setDirTemp(String string) {
        this.dirTemp = string;
    }

    public String getDirJava() {
        return this.dirJava;
    }

    public void setDirJava(String string) {
        this.dirJava = string;
    }

    public String getDirProg() {
        this.dirProg = System.getProperty("user.dir").replaceAll("\\\\", "/");
        return this.dirProg;
    }

    public String getCaminhoArquivoConfiguracao() {
        if (this.caminhoArquivoConfiguracao == null) {
            this.caminhoArquivoConfiguracao = NOME_ARQUIVO_CONFIGURACAO;
        }
        return this.caminhoArquivoConfiguracao;
    }

    public static String getDIR_EXISTENCIA() {
        return DIR_EXISTENCIA;
    }

    private String lerPropriedade(String chave) {
        return this.lerPropriedade(chave, "");
    }

    private String lerPropriedade(String chave, String valorDefault) {
        String s_valor = this.getProperty(chave);
        if (s_valor == null) {
            return valorDefault;
        }
        return s_valor;
    }

    public boolean arquivoEncontradoNormal() {
        try {
            File file = new File(this.getClass().getResource("/" + this.getCaminhoArquivoConfiguracao()).toURI());
            return file.exists() && file.canWrite();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }
}

