/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util;

import br.com.bb.cdbb.util.swing.componente.BBJProgressBar;
import br.com.politec.infra.util.UtilLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    public static void copiar(File origem, File destino) throws IOException {
        FileUtils.garantirPath(destino);
        FileInputStream in = new FileInputStream(origem);
        FileOutputStream out = new FileOutputStream(destino);
        FileUtils.copiar(in, out);
        ((OutputStream)out).close();
    }

    public static void garantirPath(File arq) throws IOException {
        String pai = arq.getParent();
        if (pai == null || pai.length() == 0) {
            return;
        }
        new File(pai).mkdirs();
    }

    public static void copiar(InputStream in, OutputStream out) throws IOException {
        int lidos;
        byte[] buffer = new byte[4096];
        while ((lidos = in.read(buffer)) != -1) {
            out.write(buffer, 0, lidos);
        }
        in.close();
    }

    public static void copyFile(String origem, String destino) throws Throwable {
        FileWriter fw = null;
        FileReader fr = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File source = null;
        try {
            try {
                fr = new FileReader(origem);
                fw = new FileWriter(destino);
                br = new BufferedReader(fr);
                bw = new BufferedWriter(fw);
                source = new File(origem);
                int fileLength = (int)source.length();
                char[] charBuff = new char[fileLength];
                while (br.read(charBuff, 0, fileLength) != -1) {
                    bw.write(charBuff, 0, fileLength);
                }
            }
            catch (FileNotFoundException fnfe) {
                throw new Exception(String.valueOf(origem) + " nao existe!");
            }
            catch (IOException ioe) {
                throw new Exception("Copia de arquivo - Erro de i/o");
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ioe) {
                UtilLog.getLog().debug((Throwable)ioe);
            }
        }
    }

    public static void copyFile(String origem, String destino, final BBJProgressBar barraProgresso) throws Throwable {
        FileWriter fw = new FileWriter(destino);
        FileReader fr = new FileReader(origem);
        final BufferedReader br = new BufferedReader(fr);
        final BufferedWriter bw = new BufferedWriter(fw);
        File source = new File(origem);
        try {
            final int fileLength = (int)source.length();
            Thread td = new Thread(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    char[] charBuff = new char[fileLength];
                    try {
                        while (true) {
                            if (br.read(charBuff, 0, fileLength) == -1) {
                                return;
                            }
                            bw.write(charBuff, 0, fileLength);
                            barraProgresso.setValoratual(barraProgresso.getValoratual() + 1L);
                            barraProgresso.updateUI();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            td.start();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ioe) {
                UtilLog.getLog().debug((Throwable)ioe);
            }
        }
    }

    public static boolean criarDiretorio(String Diretorio) throws Throwable {
        File nomeDir;
        block3: {
            try {
                nomeDir = new File(Diretorio);
                if (!nomeDir.isDirectory()) break block3;
                return true;
            }
            catch (Throwable e) {
                throw new Throwable(e.getMessage());
            }
        }
        return nomeDir.mkdirs();
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

