/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing;

import br.com.bb.cdbb.util.UtilText;
import br.com.bb.cdbb.util.Utilitarios;
import br.com.bb.cdbb.util.UtlrDatas_Dt;
import br.com.politec.infra.util.UtilLog;
import java.awt.ComponentOrientation;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class JFormatText
extends JTextField {
    private String mask = null;
    private JTextComponent textComponent = this;
    private boolean upperCase = false;
    private int charNumber = 0;
    private JTextField nxtFocusFld = null;
    private JButton nxtFocusButton = null;
    public static final int AGENCIA = 6;
    public static final int CEP = 5;
    public static final int CNPJ = 1;
    public static final int CONTA = 8;
    public static final int CONTA_SEM_DV = 7;
    public static final int CPF = 0;
    public static final int DATA = 3;
    public static final int DINHEIRO = 4;
    public static final int TELEFONE = 2;
    public static final int VALOR4DEC = 9;
    public static final int NUMERO_INT2 = 10;
    public static final int NUMERO_INT3 = 11;
    public static final int NUMERO_INT4 = 12;
    public static final int NUMERO_INTN = 13;
    public static final int VALOR3DEC = 14;
    public static final int NOSSO_NUMERO = 15;
    public static final int VALOR3INT3DEC = 16;
    public static final int VALOR3INT2DEC = 17;
    public static final int VALOR2INT2DEC = 18;
    public static final int ALPHA = 99;
    private String valor = null;
    private int fldType = 0;
    private JButton eventButton = null;
    private boolean enableEventButton = true;

    public void clear() {
        this.showValue("");
    }

    public String getText(boolean maskF) {
        if (maskF || this.fldType == 99) {
            return this.getText();
        }
        String wk = this.getText().trim();
        if (wk.compareTo("") == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < wk.length()) {
            if (Character.isLetterOrDigit(wk.charAt(i))) {
                buf.append(wk.charAt(i));
            }
            ++i;
        }
        wk = null;
        return buf.toString();
    }

    public BigDecimal getTextAsBigDecimal() {
        return new BigDecimal(Utilitarios.getDigitos(this.getText()));
    }

    public double getTextAsDouble() {
        String txt = this.getText().trim();
        if (txt.compareTo("") == 0) {
            txt = "0";
        }
        return Double.parseDouble(Utilitarios.getDigitos(txt));
    }

    public int getTextAsInteger() {
        String txt = Utilitarios.getDigitos(this.getText().trim());
        int pos = txt.indexOf(46);
        if (pos > 0) {
            txt = txt.substring(0, pos);
        }
        return Integer.parseInt(txt);
    }

    public Integer getTextAsIntegerInteger() {
        String txt = Utilitarios.getDigitos(this.getText().trim());
        int pos = txt.indexOf(46);
        if (pos > 0) {
            txt = txt.substring(0, pos);
        }
        return new Integer(txt);
    }

    public long getTextAsLong() {
        String txt = Utilitarios.getDigitos(this.getText());
        int pos = txt.indexOf(46);
        if (pos > 0) {
            txt = txt.substring(0, pos);
        }
        return Long.parseLong(txt);
    }

    public void reset() {
        this.reset(this.fldType);
    }

    public void reset(int fieldType) {
        this.fldType = fieldType;
        this.valor = "";
        if (this.fldType != 99) {
            String[] commonMasks = new String[]{"999.999.999-99", "99.999.999/9999-99", "(99)9999-9999", "99/99/9999", "Z.ZZZ.ZZZ.ZZZ.ZZ9,99", "99.999-999", "9.999", "ZZZ.ZZZ.999", "ZZZ.ZZZ.999-X", "Z.ZZZ.ZZ9,9999", "Z9", "ZZ9", "ZZZ9", "ZZZZZZZZZ9", "Z.ZZZ.ZZ9,999", "99.999.999.999.999.999", "ZZ9,999", "ZZ9,99"};
            this.mask = commonMasks[this.fldType];
            this.setDocument(new Format());
            commonMasks = null;
        } else {
            this.setDocument(new FormatAlpha());
        }
    }

    public void resetAlpha(int fldLen, boolean toUpper) {
        this.reset(99);
        this.setCharNumber(fldLen);
        this.setUpperCase(toUpper);
    }

    public void setCharNumber(int Quant) {
        this.charNumber = Quant;
    }

    public void setEventButton(JButton btn, boolean enabled) {
        this.eventButton = btn;
        this.enableEventButton = enabled;
    }

    public void setMask(String mask) {
        this.mask = mask;
        this.setDocument(new Format());
    }

    public void setNextFocus(JButton btn) {
        this.nxtFocusFld = null;
        this.nxtFocusButton = btn;
    }

    public void setNextFocus(JTextField txtFld) {
        this.nxtFocusFld = txtFld;
        this.nxtFocusButton = null;
    }

    public void setUpperCase(boolean toUpper) {
        this.upperCase = toUpper;
    }

    public void showDate(Date dt) {
        if (dt == null) {
            this.valor = "  /  /    ";
        } else {
            SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy");
            java.util.Date data = new java.util.Date(dt.getTime());
            this.valor = fmt.format(data);
            data = null;
            Object var2_2 = null;
        }
        this.setDocument(new Format());
    }

    public void showValue(double vlr) {
        UtilText txt;
        String wk = null;
        switch (this.fldType) {
            case 0: {
                this.valor = Utilitarios.formatString(Utilitarios.doubleToString(vlr, 11, 0, false), "3-3-3-2", "..-");
                break;
            }
            case 1: {
                this.valor = Utilitarios.formatString(Utilitarios.doubleToString(vlr, 14, 0, false), "2-3-3-4-2", "../-");
                break;
            }
            case 2: {
                wk = Utilitarios.doubleToString(vlr, 9, 0, false);
                this.valor = "(" + wk.substring(0, 2) + ")" + wk.substring(2, 5) + "-" + wk.substring(5);
                break;
            }
            case 4: {
                txt = new UtilText(Utilitarios.doubleToString(vlr * 100.0, 15, 2, false));
                this.valor = txt.formatWithMask("Z.ZZZ.ZZZ.ZZZ.ZZ9,99").trim();
                if (this.valor.compareTo("0,00") != 0) break;
                this.valor = "";
                break;
            }
            case 14: {
                txt = new UtilText(Utilitarios.doubleToString(vlr * 1000.0, 10, 3, false));
                this.valor = txt.formatWithMask("Z.ZZZ.ZZ9,999").trim();
                if (this.valor.compareTo("0,000") != 0) break;
                this.valor = "";
                break;
            }
            case 18: {
                txt = new UtilText(Utilitarios.doubleToString(vlr * 100.0, 4, 2, false));
                this.valor = txt.formatWithMask("Z9,99").trim();
                if (this.valor.compareTo("0,00") != 0) break;
                this.valor = "";
                break;
            }
            case 16: {
                txt = new UtilText(Utilitarios.doubleToString(vlr * 1000.0, 6, 3, false));
                this.valor = txt.formatWithMask("ZZ9,999").trim();
                if (this.valor.compareTo("0,000") != 0) break;
                this.valor = "";
                break;
            }
            case 17: {
                txt = new UtilText(Utilitarios.doubleToString(vlr * 100.0, 5, 2, false));
                this.valor = txt.formatWithMask("ZZ9,99").trim();
                if (this.valor.compareTo("0,00") != 0) break;
                this.valor = "";
                break;
            }
            case 9: {
                txt = new UtilText(Utilitarios.doubleToString(vlr * 10000.0, 11, 4, false));
                this.valor = txt.formatWithMask("Z.ZZZ.ZZ9,9999").trim();
                if (this.valor.compareTo("0,0000") != 0) break;
                this.valor = "";
                break;
            }
            case 5: {
                this.valor = Utilitarios.formatString(Utilitarios.doubleToString(vlr, 8, 0, false), "2-3-3", ".-");
                break;
            }
            case 8: {
                this.valor = Utilitarios.formatString(Utilitarios.doubleToString(vlr, 10, 0, false), "3-3-3-1", "..-");
                UtilText txt1 = new UtilText(this.valor);
                this.valor = txt1.delLeftZeros();
                txt1 = null;
                break;
            }
            case 7: {
                this.valor = Utilitarios.formatString(Utilitarios.doubleToString(vlr, 9, 0, false), "3-3-3", "..");
                UtilText txt2 = new UtilText(this.valor);
                this.valor = txt2.delLeftZeros();
                txt2 = null;
                break;
            }
            case 6: {
                this.valor = Utilitarios.formatString(Utilitarios.doubleToString(vlr, 4, 0, false), "1-3", ".");
            }
        }
        this.setDocument(new Format());
        wk = null;
        txt = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showValue(int vlr) {
        switch (this.fldType) {
            case 10: {
                this.valor = Utilitarios.intToString(vlr, 2);
                if (this.valor.compareTo("00") == 0) {
                    this.valor = "0";
                    break;
                }
                if (this.valor.charAt(0) != '0') break;
                this.valor = this.valor.substring(1);
                break;
            }
            case 11: {
                this.valor = Utilitarios.intToString(vlr, 3);
                if (this.valor.compareTo("000") == 0) {
                    this.valor = "0";
                    break;
                }
                while (this.valor.charAt(0) == '0') {
                    this.valor = this.valor.substring(1);
                }
                break;
            }
            case 12: {
                this.valor = Utilitarios.intToString(vlr, 4);
                if (this.valor.compareTo("0000") == 0) {
                    this.valor = "0";
                    break;
                }
                while (this.valor.charAt(0) == '0') {
                    this.valor = this.valor.substring(1);
                }
                break;
            }
            case 13: {
                this.valor = Utilitarios.intToString(vlr, 10);
                if (this.valor.compareTo("0000000000") == 0) {
                    this.valor = "0";
                    break;
                }
                while (this.valor.charAt(0) == '0') {
                    this.valor = this.valor.substring(1);
                }
                break;
            }
            case 6: {
                this.valor = Utilitarios.formatString(Utilitarios.intToString(vlr, 4), "1-3", ".");
                break;
            }
        }
        this.setDocument(new Format());
    }

    public void showValue(String val) {
        this.valor = val;
        if (this.fldType == 99) {
            this.setDocument(new FormatAlpha(val));
        } else {
            this.setDocument(new Format());
        }
    }

    public class Format
    extends PlainDocument {
        private int nDigs = 0;
        private boolean noTest = false;
        private int xChrInx;
        private int numCh;
        private String[] masks;

        public Format() {
            this.xChrInx = JFormatText.this.mask.indexOf(88);
            this.numCh = 1;
            this.masks = this.buildMasks();
            JFormatText.this.textComponent.addKeyListener(new IvjEventHandler());
            JFormatText.this.textComponent.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            try {
                super.insertString(0, JFormatText.this.valor, null);
            }
            catch (BadLocationException e) {
                UtilLog.getLog().debug((Throwable)e);
            }
            if (this.xChrInx >= 0) {
                int i = 0;
                while (i < this.xChrInx) {
                    if (JFormatText.this.mask.charAt(i) == '9' || JFormatText.this.mask.charAt(i) == 'Z' || JFormatText.this.mask.charAt(i) == 'X') {
                        ++this.numCh;
                    }
                    ++i;
                }
            }
        }

        private String[] buildMasks() {
            String wk;
            int i = 0;
            while (i < JFormatText.this.mask.length()) {
                if (JFormatText.this.mask.charAt(i) == '9' || JFormatText.this.mask.charAt(i) == 'Z' || JFormatText.this.mask.charAt(i) == 'X') {
                    ++this.nDigs;
                }
                ++i;
            }
            String wkMask = "|" + JFormatText.this.mask;
            int inx = wkMask.length() - 1;
            String[] msk = new String[this.nDigs + 1];
            msk[0] = " ";
            int indice = 0;
            while (wkMask.charAt(inx) != '|') {
                char ch = wkMask.charAt(inx);
                wk = "" + ch;
                --inx;
                if (ch != '9' && ch != 'Z' && ch != 'X') {
                    ch = wkMask.charAt(inx--);
                    String string = ++indice > 1 ? String.valueOf(msk[indice - 1]) + wk + ch : String.valueOf(wk) + ch;
                    msk[indice] = string;
                    continue;
                }
                String string = msk[indice] = ++indice > 1 ? String.valueOf(msk[indice - 1]) + wk : wk;
            }
            int i2 = 1;
            while (i2 < msk.length) {
                wk = "";
                int n = msk[i2].length();
                while (--n >= 0) {
                    wk = String.valueOf(wk) + msk[i2].charAt(n);
                }
                msk[i2] = wk;
                ++i2;
            }
            return msk;
        }

        private String maskValue(String mascara, String vlr) {
            int inx = 0;
            int i = 0;
            boolean goodChr = false;
            StringBuffer novoValor = new StringBuffer();
            while (i < mascara.length()) {
                boolean bl = goodChr = mascara.charAt(i) == '9' || mascara.charAt(i) == 'Z' || mascara.charAt(i) == 'X';
                if (!goodChr) {
                    novoValor.append(mascara.charAt(i));
                } else {
                    novoValor.append(vlr.charAt(inx++));
                }
                ++i;
            }
            return novoValor.toString();
        }

        private String extractDigits(String vlr) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < vlr.length()) {
                if (Character.isDigit(vlr.charAt(i))) {
                    buf.append(vlr.charAt(i));
                }
                ++i;
            }
            return buf.toString();
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            if (s == JFormatText.this.valor) {
                super.insertString(offset, s, attributeSet);
                this.noTest = false;
                return;
            }
            if (this.noTest) {
                return;
            }
            if ((s = s.trim()).compareTo("") == 0) {
                return;
            }
            String text = JFormatText.this.textComponent.getText().trim();
            if (JFormatText.this.eventButton != null && text.length() == 1) {
                JFormatText.this.eventButton.setEnabled(JFormatText.this.enableEventButton);
            }
            if (text.length() == JFormatText.this.mask.length()) {
                return;
            }
            StringBuffer buf = null;
            if (this.xChrInx >= 0 && JFormatText.this.valor != null) {
                boolean notDigit;
                boolean bl = notDigit = !Character.isDigit(s.charAt(0));
                if (JFormatText.this.valor.trim().length() + 1 == this.numCh || notDigit) {
                    this.noTest = true;
                    s = s.toUpperCase();
                }
            } else {
                try {
                    Integer.parseInt(s);
                }
                catch (Exception ex) {
                    UtilLog.getLog().debug((Throwable)ex);
                    return;
                }
            }
            JFormatText jFormatText = JFormatText.this;
            jFormatText.valor = String.valueOf(jFormatText.valor) + s;
            buf = new StringBuffer();
            int i = 0;
            while (i < JFormatText.this.valor.length()) {
                if (Character.isDigit(JFormatText.this.valor.charAt(i)) || this.noTest) {
                    buf.append(JFormatText.this.valor.charAt(i));
                }
                ++i;
            }
            JFormatText.this.valor = buf.toString();
            if (JFormatText.this.valor.length() > this.nDigs) {
                return;
            }
            text = JFormatText.this.textComponent.getText().trim();
            if (text.length() > 0) {
                super.remove(0, text.length());
            }
            String wk = this.masks[JFormatText.this.valor.length()];
            int inx = 0;
            int i2 = 0;
            StringBuffer novoValor = new StringBuffer();
            while (i2 < wk.length()) {
                boolean goodCh;
                boolean bl = goodCh = wk.charAt(i2) == '9' || wk.charAt(i2) == 'Z' || wk.charAt(i2) == 'X';
                if (!goodCh) {
                    novoValor.append(wk.charAt(i2));
                } else {
                    novoValor.append(JFormatText.this.valor.charAt(inx));
                    ++inx;
                }
                ++i2;
            }
            super.insertString(0, novoValor.toString(), attributeSet);
            if (JFormatText.this.textComponent.getText().trim().length() == JFormatText.this.mask.length()) {
                if (JFormatText.this.fldType == 3 && !UtlrDatas_Dt.isDataValida(JFormatText.this.textComponent.getText().trim())) {
                    JFormatText.this.textComponent.selectAll();
                    return;
                }
                if (JFormatText.this.nxtFocusFld != null) {
                    JFormatText.this.nxtFocusFld.grabFocus();
                } else if (JFormatText.this.nxtFocusButton != null) {
                    JFormatText.this.nxtFocusButton.grabFocus();
                }
            }
        }

        public void remove(int offset, int length) throws BadLocationException {
            if (length == 0) {
                return;
            }
            if (JFormatText.this.eventButton != null) {
                JFormatText.this.eventButton.setEnabled(JFormatText.this.enableEventButton);
            }
            String text = JFormatText.this.textComponent.getText().trim();
            int len = JFormatText.this.textComponent.getText().length();
            if (text.length() <= 0) {
                return;
            }
            super.remove(0, len);
            this.noTest = false;
            JFormatText.this.valor = this.extractDigits(text.substring(0, text.length() - 1));
            String novoValor = this.maskValue(this.masks[JFormatText.this.valor.length()], JFormatText.this.valor);
            super.insertString(0, novoValor, null);
            text = JFormatText.this.textComponent.getText().trim();
            if (text.compareTo(",") == 0) {
                super.remove(0, 1);
                this.noTest = false;
            }
        }

        class IvjEventHandler
        implements KeyListener {
            IvjEventHandler() {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (JFormatText.this.nxtFocusFld != null) {
                        JFormatText.this.nxtFocusFld.grabFocus();
                    } else if (JFormatText.this.nxtFocusButton != null) {
                        JFormatText.this.nxtFocusButton.grabFocus();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        }
    }

    public class FormatAlpha
    extends PlainDocument {
        public FormatAlpha() {
        }

        public FormatAlpha(String initValue) {
            try {
                super.insertString(0, initValue, null);
            }
            catch (BadLocationException e) {
                UtilLog.getLog().debug((Throwable)e);
            }
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            try {
                if (JFormatText.this.charNumber > 0) {
                    if (JFormatText.this.upperCase) {
                        s = s.toUpperCase();
                    }
                    if (offset <= JFormatText.this.charNumber - 1) {
                        super.insertString(offset, s, attributeSet);
                    }
                } else {
                    if (JFormatText.this.upperCase) {
                        s = s.toUpperCase();
                    }
                    super.insertString(offset, s, attributeSet);
                }
            }
            catch (Exception ex) {
                UtilLog.getLog().debug((Throwable)ex);
            }
        }
    }
}

