/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJMaskDateChooser;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJDateChooserLabel
extends JPanel {
    private String titulo;
    private int largura;
    private int larguralabel;
    private int posicaoLabel = 0;
    private boolean editavel = true;
    private BBJMaskDateChooser campoData;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;
    private String toolTip = "";

    public BBJDateChooserLabel(String titulo, boolean isEditavel, int posicaoLabel) {
        this(titulo, isEditavel, posicaoLabel, 0);
    }

    public BBJDateChooserLabel(String titulo, boolean isEditavel, int posicaoLabel, int largura) {
        this(titulo, isEditavel, posicaoLabel, largura, 0);
    }

    public BBJDateChooserLabel(String titulo, boolean isEditavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.campoData = new BBJMaskDateChooser();
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 19);
            this.campoData.setPreferredSize(dimfld);
        }
        this.campoData.setMaximumSize(new Dimension(3000, 19));
        this.campoData.setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.campoData.setForeground(this.estilotexto.getColor());
        this.campoData.setFont(this.estilotexto.getFont());
        JLabel jlTitulo = new JLabel(" ");
        jlTitulo.setFont(this.estilolabel.getFont());
        jlTitulo.setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            jlTitulo.setText(this.titulo);
        }
        this.add(jlTitulo);
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = jlTitulo.getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.campoData);
    }

    public void setVisible(boolean visivel) {
        super.setVisible(visivel);
        this.getCampoData().setVisible(visivel);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            g.drawString(this.titulo, 2, 10);
        }
    }

    public void addFocusListener(FocusListener l) {
        this.getCampoData().addFocusListener(l);
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.editavel = editavel;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public BBJMaskDateChooser getCampoData() {
        return this.campoData;
    }

    public Date getText() {
        return this.campoData.getDate();
    }

    public void setText(Date date) {
        this.campoData.setDate(date);
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public void limpar() {
        this.getCampoData().limpar();
    }

    public void setEnabled(boolean enabled) {
        this.getCampoData().setEnabled(enabled);
        this.getCampoData().setFocusable(enabled);
        this.getCampoData().setToolTipText(enabled ? this.toolTip : null);
    }

    public void setName(String name) {
        this.getCampoData().setName(name);
    }

    public String getName() {
        return this.getCampoData().getName();
    }

    public void setToolTipText(String text) {
        this.getCampoData().setToolTipText(text);
        this.toolTip = text;
    }

    public Date getDate() {
        return this.getCampoData().getDate();
    }

    public void requestFocus() {
        this.getCampoData().requestFocus();
    }
}

