/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.ConfiguracaoProperties;
import br.com.bb.cdbb.util.UtilMensagem;
import br.com.bb.cdbb.util.swing.componente.BBJButtonChooser;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJFileChooser
extends JPanel {
    private String titulo;
    private int maxchar;
    private int largura;
    private int larguralabel;
    private int posicaoLabel = 0;
    private boolean editavel = true;
    private BBJText jtfCampo;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;
    private JFileChooser filechooser = null;
    private BBJButtonChooser botaoExecutar = null;
    private BBJFileChooser bbfc = null;
    private boolean somenteDiretorio = false;
    private String toolTipText = "";
    private String buttonToolTipText = "";

    public BBJFileChooser(String titulo, String nomeBotao, int maxchar, boolean isEditavel, int posicaoLabel) {
        this(titulo, nomeBotao, maxchar, isEditavel, posicaoLabel, 0);
    }

    public BBJFileChooser(String titulo, String nomeBotao, int maxchar, boolean isEditavel, int posicaoLabel, int largura) {
        this(titulo, nomeBotao, maxchar, isEditavel, posicaoLabel, largura, 0);
    }

    public BBJFileChooser(String titulo, String nomeBotao, int maxchar, boolean isEditavel, int posicaoLabel, int largura, boolean somenteDiretorio) {
        this.somenteDiretorio = somenteDiretorio;
        this.titulo = titulo;
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = this.larguralabel;
        this.initialize();
    }

    public BBJFileChooser(String titulo, String nomeBotao, int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    public BBJFileChooser(String titulo, String nomeBotao, int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel, boolean somenteDiretorio) {
        this.titulo = titulo;
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.somenteDiretorio = somenteDiretorio;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.jtfCampo = new BBJText();
        this.jtfCampo.setUpperCase(false);
        this.jtfCampo.setAllChars(true);
        this.jtfCampo.setTipoEntrada(5);
        this.jtfCampo.setUpperCase(false);
        if (this.maxchar > 0) {
            this.jtfCampo.setMaxChar(this.maxchar);
        }
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 19);
            this.jtfCampo.setPreferredSize(dimfld);
        }
        this.jtfCampo.setEditable(this.isEditavel());
        this.jtfCampo.setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.jtfCampo.setForeground(this.estilotexto.getColor());
        this.jtfCampo.setFont(this.estilotexto.getFont());
        JLabel jlTitulo = new JLabel(" ");
        jlTitulo.setFont(this.estilolabel.getFont());
        jlTitulo.setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            jlTitulo.setText(this.titulo);
        }
        this.add(jlTitulo);
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = jlTitulo.getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.jtfCampo);
        this.add(this.getBotaoExecutar());
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            int posiy = (int)this.getSize().getHeight() - (this.jtfCampo.getHeight() + 5);
            g.drawString(this.titulo, 2, posiy);
        }
    }

    public BBJFileChooser(String nomelabel, String nomebutton) {
        this.initialize();
    }

    public BBJFileChooser(String nomelabel, String nomebutton, int largura, int larguraLabel) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.largura = largura;
        this.initialize();
    }

    public File getArquivo() {
        return this.getFilechooser().getSelectedFile();
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.setBackground(Color.WHITE);
        frm.setDefaultCloseOperation(2);
        BBJFileChooser bbfc = new BBJFileChooser("Arquivo", "ABRIR", 110, false, 0);
        frm.add(bbfc);
        frm.setSize(new Dimension(450, 70));
        frm.setVisible(true);
    }

    public BBJFileChooser getBBJFileChososer(String nomelabel, String nomebutton) {
        if (this.bbfc == null) {
            String nmb = nomebutton.toUpperCase();
            this.bbfc = new BBJFileChooser(nomelabel, nmb);
        }
        return this.bbfc;
    }

    public BBJButtonChooser getBotaoExecutar() {
        if (this.botaoExecutar == null) {
            this.botaoExecutar = new BBJButtonChooser();
            this.botaoExecutar.setToolTipText(this.getMensagem("MH010"));
            this.botaoExecutar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    BBJFileChooser.this.buscarArquivo();
                }
            });
        }
        return this.botaoExecutar;
    }

    protected String getMensagem(String mensagem) {
        return UtilMensagem.getInstancia().getMensagem(mensagem);
    }

    public String getTexto() {
        return this.getJTextField().getText();
    }

    public void setTexto(String texto) {
        this.getJTextField().setText(texto);
    }

    private BBJText getJTextField() {
        return this.jtfCampo;
    }

    public void setName(String name) {
        this.getJTextField().setName(name);
    }

    public void setEnabled(boolean enabled) {
        this.getJtfCampo().setEnabled(enabled);
        this.getBotaoExecutar().setEnabled(enabled);
        this.getJtfCampo().setToolTipText(enabled ? this.toolTipText : "");
        this.getBotaoExecutar().setToolTipText(enabled ? this.buttonToolTipText : "");
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.getJtfCampo().setEditable(editavel);
        this.getJtfCampo().setBackground(editavel ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.getBotaoExecutar().setEnabled(editavel);
        this.editavel = editavel;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public int getMaxchar() {
        return this.maxchar;
    }

    public void setMaxchar(int maxchar) {
        this.maxchar = maxchar;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public BBJText getJtfCampo() {
        return this.jtfCampo;
    }

    public void setJtfCampo(BBJText jtfCampo) {
        this.jtfCampo = jtfCampo;
    }

    public String getText() {
        return this.jtfCampo.getText();
    }

    public void setText(String text) {
        this.jtfCampo.setText(text);
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public JFileChooser getFilechooser() {
        if (this.filechooser == null) {
            this.filechooser = new JFileChooser();
            this.filechooser.setDialogTitle("Selecionar Arquivo");
        }
        if (this.somenteDiretorio) {
            this.filechooser.setFileSelectionMode(1);
        }
        return this.filechooser;
    }

    private void buscarArquivo() {
        if (this.isEditavel()) {
            if (this.getJTextField().getText().length() > 0) {
                File file = new File(this.getJTextField().getText());
                this.getFilechooser().setCurrentDirectory(file);
            }
            this.getFilechooser().setCurrentDirectory(this.getDiretorioAplicacao());
            int result = this.getFilechooser().showSaveDialog(this);
            if (result == 0) {
                String camarq = this.getFilechooser().getSelectedFile().getPath();
                this.getJtfCampo().setText(camarq);
            }
        }
    }

    private File getDiretorioAplicacao() {
        String dirAplicacao = ConfiguracaoProperties.getConfiguracaoProperties().getDirProg();
        return new File(dirAplicacao);
    }

    public void requestFocus() {
        this.getJtfCampo().requestFocus();
    }

    public void setToolTipText(String text) {
        this.getJtfCampo().setToolTipText(text);
        this.toolTipText = text;
    }

    public boolean isSomenteDiretorio() {
        return this.somenteDiretorio;
    }

    public void setSomenteDiretorio(boolean somenteDiretorio) {
        this.somenteDiretorio = somenteDiretorio;
    }

    public void setButtonToolTipText(String text) {
        this.getBotaoExecutar().setToolTipText(text);
        this.buttonToolTipText = text;
    }
}

