/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.CalculaDigitoVerificador;
import br.com.bb.cdbb.util.FormatadorNumero;
import br.com.bb.cdbb.util.swing.componente.BBJDate;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJNumericMasked;
import br.com.bb.cdbb.util.swing.componente.BBJPopupMensagem;
import br.com.bb.cdbb.util.swing.componente.EditionFinishedEvent;
import br.com.bb.cdbb.util.swing.componente.EditionFinishedEventMulticaster;
import br.com.bb.cdbb.util.swing.componente.EditionFinishedListener;
import br.com.bb.cdbb.util.swing.componente.FilterMask;
import br.com.bb.cdbb.util.swing.componente.Mask;
import br.com.bb.cdbb.util.swing.componente.MaskContainer;
import br.com.bb.cdbb.util.swing.componente.MaskDefinition;
import br.com.bb.cdbb.util.swing.componente.MaskSet;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InvalidObjectException;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BBJMask
extends JTextField
implements KeyListener,
FocusListener,
MouseListener {
    private MaskSet maskSet_;
    protected String mask_;
    protected String delimiter_;
    private boolean beep_;
    private String[] filter_;
    protected transient EditionFinishedListener aEditionFinishedListener = null;
    private char echoChar;
    private int positionCaret = -1;
    public static final String CPF = "###.###.###-##";
    public static final String CNPJ = "##.###.###/####-##";
    public static final String CONTA = "###.###.###-&";
    public static final String AGENCIA = "####-&";
    public static final String CEP = "#####-###";
    public static final String CEI = "############";
    public static final String NIT = "###########";
    public static final String PIS = "###########";
    public static final String PASEP = "###########";
    public static final String NB = "##########";
    public static final String TITULOCOBRANCA = "##############";
    public static final String DEBCAD = "#########";
    public static final String REFERENCIA = "##############";
    public static final Integer TIPO_SEM_VALIDACAO = -1;
    public static final Integer TIPO_CPF = 1;
    public static final Integer TIPO_CNPJ = 2;
    public static final Integer TIPO_CEI = 3;
    public static final Integer TIPO_NB = 4;
    public static final Integer TIPO_PIS = 5;
    public static final Integer TIPO_PASEP = 5;
    public static final Integer TIPO_TITULOCOBRANCA = 6;
    public static final Integer TIPO_NIT = 7;
    public static final Integer TIPO_DEBCAD = 8;
    public static final Integer TIPO_REFERENCIA = 9;
    public static final Integer TIPO_CONTA = 11;
    public static final Integer TIPO_AGENCIA = 12;
    public static final Integer TIPO_CEP = 13;
    public static final Integer FORNECIDA_USUARIO = 14;
    private Integer tipo;
    private String TipMask = null;
    private int maxChars = 15;
    private boolean validateInput = false;

    public BBJMask() {
        this(" ", new Integer(-1));
        this.initComponents();
    }

    public BBJMask(String format) {
        this(format, "");
        this.initComponents();
        this.TipMask = format;
        this.tipo = TIPO_SEM_VALIDACAO;
    }

    private void initComponents() {
        Dimension dim = new Dimension(0, 19);
        this.setMinimumSize(dim);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setFont(BBJEstilos.TABELATITULO.getFont());
    }

    public BBJMask(String format, Integer tipo) {
        this(format, "");
        this.TipMask = format;
        this.tipo = tipo;
    }

    public BBJMask(String format, String delimeters) {
        this.mask_ = format;
        if (format != null) {
            this.setMaxChars(format.length() + 2);
        }
        if (delimeters == "") {
            delimeters = null;
        }
        this.delimiter_ = delimeters;
        this.echoChar = (char)32;
        this.init();
        this.addKeyListener(this);
        this.addFocusListener(this);
        int align = this.getHorizontalAlignment();
        if (align != 2 || align != 4) {
            this.setHorizontalAlignment(2);
        }
    }

    public void addEditionFinishedListener(EditionFinishedListener newListener) {
        this.aEditionFinishedListener = EditionFinishedEventMulticaster.add(this.aEditionFinishedListener, newListener);
    }

    private void addFilter(char id, String filter) {
        MaskDefinition def = MaskDefinition.getMaskDefinition();
        Enumeration e = def.elements();
        while (e.hasMoreElements()) {
            Mask m = (Mask)e.nextElement();
            if (m instanceof FilterMask || m.getChar() != id) continue;
            throw new IllegalArgumentException("O identificador j\u00e1 \u00e9 utilizado como um padr\u00e3o.");
        }
        def.put("" + id, new FilterMask(id, filter));
    }

    public void clean() {
        this.maskSet_.clean();
        this.setMaskText(this.maskSet_.getText());
        this.setCaretPosition(0);
    }

    protected int computeColumns(String format) {
        this.setFont(new Font("Monospaced", 0, 12));
        int wid = this.getFontMetrics(this.getFont()).stringWidth("W");
        return format.length() + 2;
    }

    protected void fireEditionFinished(EditionFinishedEvent event) {
        if (this.aEditionFinishedListener == null) {
            return;
        }
        this.aEditionFinishedListener.editionFinished(event);
    }

    public void focusGained(FocusEvent e) {
        try {
            if (this.getPositionCaret() == -1) {
                int pos = this.maskSet_.lastPositionWritten();
                this.setCaretPosition(pos + 1);
            } else {
                this.setCaretPosition(this.getPositionCaret());
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void focusLost(FocusEvent e) {
        String valor = null;
        String mensagem = null;
        String cc = null;
        if (!this.isValidateInput()) {
            return;
        }
        try {
            CalculaDigitoVerificador clsdv = new CalculaDigitoVerificador();
            valor = CalculaDigitoVerificador.tirarTracoPonto(this.getText().trim());
            if (!this.tipo.equals(TIPO_AGENCIA)) {
                if (this.tipo.equals(TIPO_CONTA)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    if (valor.length() < 2) {
                        throw new Exception();
                    }
                    cc = clsdv.formatarContaCorrenteSemDV(valor);
                    super.setText(cc);
                    String dvcc1 = cc.substring(12);
                    String dvcc2 = clsdv.getDvCC();
                    if (!dvcc1.equals(dvcc2)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_CEP)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                } else if (this.tipo.equals(TIPO_CPF)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String cpf = FormatadorNumero.formatarCPF(valor);
                    super.setText(cpf);
                    cpf = CalculaDigitoVerificador.tirarTracoPonto(cpf);
                    if (!CalculaDigitoVerificador.verificarCPF(cpf)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_CNPJ)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String cnpj = FormatadorNumero.formatarCGC(valor);
                    super.setText(cnpj);
                    cnpj = CalculaDigitoVerificador.tirarTracoPonto(cnpj);
                    if (!CalculaDigitoVerificador.verificarCNPJ(cnpj)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_CEI)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String cei = valor;
                    super.setText(cei);
                    cei = CalculaDigitoVerificador.tirarTracoPonto(cei);
                    if (!CalculaDigitoVerificador.verificarCEI(cei)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_NIT)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String nit = valor;
                    super.setText(nit);
                    nit = CalculaDigitoVerificador.tirarTracoPonto(nit);
                    if (!CalculaDigitoVerificador.verificarNIT(nit)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_PIS)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String pis = valor;
                    super.setText(pis);
                    pis = CalculaDigitoVerificador.tirarTracoPonto(pis);
                    if (!CalculaDigitoVerificador.verificarPIS(pis)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_PASEP)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String pasep = valor;
                    super.setText(pasep);
                    pasep = CalculaDigitoVerificador.tirarTracoPonto(pasep);
                    if (!CalculaDigitoVerificador.verificarPASEP(pasep)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_NB)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String nb = valor;
                    super.setText(nb);
                    nb = CalculaDigitoVerificador.tirarTracoPonto(nb);
                    if (!CalculaDigitoVerificador.verificarNB(nb)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_TITULOCOBRANCA)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String titulocobranca = valor;
                    super.setText(titulocobranca);
                    titulocobranca = CalculaDigitoVerificador.tirarTracoPonto(titulocobranca);
                    if (!CalculaDigitoVerificador.verificarTituloCobranca(titulocobranca)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_DEBCAD)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String debcad = valor;
                    super.setText(debcad);
                    debcad = CalculaDigitoVerificador.tirarTracoPonto(debcad);
                    if (!CalculaDigitoVerificador.verificarDEBCAD(debcad)) {
                        throw new Exception();
                    }
                } else if (this.tipo.equals(TIPO_REFERENCIA)) {
                    if (valor.trim().length() == 0) {
                        return;
                    }
                    String referencia = valor;
                    super.setText(referencia);
                    referencia = CalculaDigitoVerificador.tirarTracoPonto(referencia);
                    if (!CalculaDigitoVerificador.verificarReferencia(referencia)) {
                        throw new Exception();
                    }
                }
            }
        }
        catch (Throwable t) {
            if (this.tipo.equals(TIPO_AGENCIA)) {
                mensagem = "Entre com uma Ag\u00eancia v\u00e1lida.";
            } else if (this.tipo.equals(TIPO_CONTA)) {
                mensagem = "Entre com uma  Conta v\u00e1lida.";
            } else if (this.tipo.equals(TIPO_CEP)) {
                mensagem = "Entre com um CEP v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_CPF)) {
                mensagem = "Entre com um CPF v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_CNPJ)) {
                mensagem = "Entre com um CNPJ v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_CEI)) {
                mensagem = "Entre com um CEI v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_NIT)) {
                mensagem = "Entre com um NIT v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_PIS)) {
                mensagem = "Entre com um PIS v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_PASEP)) {
                mensagem = "Entre com um PASEP v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_NB)) {
                mensagem = "Entre com um NB v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_TITULOCOBRANCA)) {
                mensagem = "Entre com um TITULOCOBRANCA v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_DEBCAD)) {
                mensagem = "Entre com um DEBCAD v\u00e1lido.";
            } else if (this.tipo.equals(TIPO_REFERENCIA)) {
                mensagem = "Entre com um REFERENCIA v\u00e1lido.";
            }
            BBJPopupMensagem.exibirMensagem(mensagem);
        }
    }

    public String getData() {
        return this.getMaskSet().getData();
    }

    public String getDelimiter() {
        return this.delimiter_;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public String[] getFilter() {
        return this.filter_;
    }

    public String getMask() {
        return this.mask_;
    }

    protected MaskSet getMaskSet() {
        return this.maskSet_;
    }

    protected void init() {
        this.maskSet_ = new MaskSet(this.mask_, this.delimiter_);
        this.setColumns(this.computeColumns(this.mask_));
        this.setMaskText(this.maskSet_.getText());
        this.setCaretPosition(0);
        int align = this.getHorizontalAlignment();
        if (align == 2) {
            this.maskSet_.setHorizontalAlignment(0);
        } else {
            this.maskSet_.setHorizontalAlignment(1);
        }
    }

    public boolean isBeepOnError() {
        return this.beep_;
    }

    public void keyPressed(KeyEvent evt) {
        int caretPos;
        int code = evt.getKeyCode();
        if (code == 10) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            return;
        }
        if (evt.getModifiers() == 8 || evt.getModifiers() == 2 || evt.getModifiers() == 4 || evt.isActionKey() || code == 17 || code == 16 || code == 18 || code == 10) {
            return;
        }
        if (this.isEditable() && (caretPos = this.maskSet_.tratarKeyPressed(this.getCaretPosition(), evt)) < this.getMaxChars()) {
            evt.consume();
            this.setMaskText(this.maskSet_.getText());
            this.setCaretPosition(caretPos);
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void paste() {
    }

    public void copy() {
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        this.tratarFormato();
    }

    protected void tratarFormato() {
        String str;
        int posStart = this.getSelectionStart();
        if (posStart != this.getSelectionEnd()) {
            return;
        }
        char[] charStr = this.getText().toCharArray();
        String texto = this.getText();
        int len = charStr.length;
        if (this.maxChars > 0 && this.maxChars < len) {
            len = this.maxChars;
        }
        if (!(str = new String(charStr, 0, len)).equals(texto)) {
            super.setText(str);
            this.setSelectionStart(posStart);
            this.setSelectionEnd(posStart);
        }
    }

    public void keyTyped(KeyEvent evt) {
        evt.consume();
        if (this.maskSet_.computeSpace() <= 0) {
            this.fireEditionFinished(new EditionFinishedEvent(this));
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Algumas Mascaras");
        frame.setDefaultCloseOperation(2);
        JLabel lblAgencia = new JLabel("AGENCIA  :");
        JLabel lblConta = new JLabel("CONTA    :");
        JLabel lblCNPJ = new JLabel("CNPJ     :");
        JLabel lblCPF = new JLabel("CPF      :");
        JLabel lblCEP = new JLabel("CEP      :");
        JLabel lblNumerico = new JLabel("N\u00famerico :");
        BBJMask mAgencia = new BBJMask(AGENCIA, TIPO_AGENCIA);
        BBJMask mConta = new BBJMask(CONTA, TIPO_CONTA);
        BBJMask mCNPJ = new BBJMask(CNPJ, TIPO_CNPJ);
        BBJMask mCPF = new BBJMask(CPF, TIPO_CPF);
        BBJMask mCEP = new BBJMask(CEP, TIPO_CEP);
        BBJDate d = new BBJDate();
        BBJNumericMasked mNumerico = new BBJNumericMasked();
        mNumerico.setDigitosDecimais(2);
        mNumerico.setDigitosNaoDecimais(5);
        mAgencia.setHorizontalAlignment(4);
        mConta.setHorizontalAlignment(4);
        mCPF.setHorizontalAlignment(4);
        mCNPJ.setHorizontalAlignment(4);
        mCEP.setHorizontalAlignment(4);
        mAgencia.setFilter(new String[]{"%=0-9,x,X"});
        JPanel pa = new JPanel(new FlowLayout());
        pa.add(lblAgencia);
        pa.add(mAgencia);
        JPanel pb = new JPanel(new FlowLayout());
        pb.add(lblConta);
        pb.add(mConta);
        JPanel pc = new JPanel(new FlowLayout());
        pc.add(lblCNPJ);
        pc.add(mCNPJ);
        JPanel pd = new JPanel(new FlowLayout());
        pd.add(lblCPF);
        pd.add(mCPF);
        JPanel pe = new JPanel(new FlowLayout());
        pe.add(lblNumerico);
        pe.add(mNumerico);
        JPanel cep = new JPanel(new FlowLayout());
        cep.add(lblCEP);
        cep.add(mCEP);
        JPanel panel = new JPanel();
        panel.add(pa);
        panel.add(pb);
        panel.add(pc);
        panel.add(pd);
        panel.add(pe);
        panel.add(cep);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        });
        frame.getContentPane().add(panel);
        frame.setSize(600, 200);
        frame.setVisible(true);
        frame.pack();
    }

    public void mouseClicked(MouseEvent e) {
        int pos = this.maskSet_.lastPositionWritten();
        this.setCaretPosition(pos + 1);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private String putEchoChar(String s) {
        int tam = s.length();
        String nova = "";
        int i = 0;
        while (i < tam) {
            MaskContainer mc = this.getMaskSet().get(i);
            nova = mc.isWritten(i) ? String.valueOf(nova) + this.echoChar : String.valueOf(nova) + s.charAt(i);
            ++i;
        }
        return nova;
    }

    public void removeEditionFinishedListener(EditionFinishedListener newListener) {
        this.aEditionFinishedListener = EditionFinishedEventMulticaster.remove(this.aEditionFinishedListener, newListener);
    }

    public void setBeepOnError(boolean beep) {
        this.beep_ = beep;
    }

    public void setData(String s) throws InvalidObjectException {
        System.out.println(this.putEchoChar(s));
        this.getMaskSet().setData(s);
        this.setMaskText(this.getMaskSet().getText());
    }

    public void setDelimiter(String newDelimitador) {
        this.delimiter_ = newDelimitador;
        if (this.mask_ != null) {
            this.init();
        }
    }

    public void setEchoChar(char newEchoChar) {
        this.echoChar = newEchoChar;
    }

    public void setFilter(String[] newFilter) {
        this.filter_ = newFilter;
        int i = 0;
        while (i < newFilter.length) {
            this.addFilter(newFilter[i].charAt(0), newFilter[i].substring(2));
            ++i;
        }
        if (this.mask_ != null) {
            this.init();
        }
    }

    public void setHorizontalAlignment(int align) {
        super.setHorizontalAlignment(align);
        if (align == 2) {
            this.maskSet_.setHorizontalAlignment(0);
        } else {
            this.maskSet_.setHorizontalAlignment(1);
        }
    }

    public void setMask(String newMask) {
        this.TipMask = newMask;
        this.mask_ = newMask;
        if (newMask != null) {
            this.setMaxChars(newMask.length() + 2);
        }
        this.init();
    }

    protected void setMaskText(String s) {
        if (this.echoChar != ' ') {
            s = this.putEchoChar(s);
        }
        super.setText(s);
    }

    public void setText(String s) {
        super.setText(s);
    }

    public void setTextWithMask(String s) throws InvalidObjectException {
        this.getMaskSet().setText(s);
        this.setMaskText(this.getMaskSet().getText());
    }

    public int getPositionCaret() {
        return this.positionCaret;
    }

    public void setPositionCaret(int positionCaret) {
        this.positionCaret = positionCaret;
    }

    public String getTipMask() {
        return this.TipMask;
    }

    public void setTipMask(String tipMask) {
        this.TipMask = tipMask;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public Integer getTipo() {
        return this.tipo;
    }

    public void setTipo(Integer tipo) {
        this.tipo = tipo;
    }

    public boolean isValidateInput() {
        return this.validateInput;
    }

    public void setValidateInput(boolean validateInput) {
        this.validateInput = validateInput;
    }
}

