/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJMask;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJMaskLabelCEP
extends JPanel {
    private String titulo = "CEP: ";
    private int maxchar;
    private int largura;
    private int larguralabel;
    private int posicaoLabel = 0;
    private boolean editavel = true;
    private BBJMask jtfCampo;
    private Color corFundo = new Color(255, 255, 255);
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;

    public BBJMaskLabelCEP(int maxchar, boolean isEditavel, int posicaoLabel) {
        this(maxchar, isEditavel, posicaoLabel, 0);
    }

    public BBJMaskLabelCEP(int maxchar, boolean isEditavel, int posicaoLabel, int largura) {
        this(maxchar, isEditavel, posicaoLabel, largura, 0);
    }

    public void setToolTipText(String text) {
        this.getJtfCampo().setToolTipText(text);
    }

    public BBJMaskLabelCEP(int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel) {
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setBackground(this.corFundo);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.jtfCampo = new BBJMask("#####-###", BBJMask.TIPO_CEP);
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 21);
            this.jtfCampo.setPreferredSize(dimfld);
        }
        this.jtfCampo.setEditable(this.isEditavel());
        this.jtfCampo.setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.jtfCampo.setForeground(this.estilotexto.getColor());
        this.jtfCampo.setFont(this.estilotexto.getFont());
        JLabel jlTitulo = new JLabel(" ");
        jlTitulo.setFont(this.estilolabel.getFont());
        jlTitulo.setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            jlTitulo.setText(this.titulo);
        }
        this.add(jlTitulo);
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = jlTitulo.getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.jtfCampo);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            g.drawString(this.titulo, 2, 10);
        }
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.editavel = editavel;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public int getMaxchar() {
        return this.maxchar;
    }

    public void setMaxchar(int maxchar) {
        this.maxchar = maxchar;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public BBJMask getJtfCampo() {
        return this.jtfCampo;
    }

    public void setJtfCampo(BBJMask jtfCampo) {
        this.jtfCampo = jtfCampo;
    }

    public String getText() {
        return this.jtfCampo.getText();
    }

    public void setText(String text) {
        this.jtfCampo.setText(text);
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public static void main(String[] a) {
        JFrame frm = new JFrame();
        frm.add(new BBJMaskLabelCEP(10, true, 0));
        frm.setSize(new Dimension(200, 200));
        frm.setPreferredSize(new Dimension(200, 200));
        frm.setVisible(true);
    }

    public void setName(String name) {
        this.jtfCampo.setName(name);
    }
}

