/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.swing.componente.BBMaskDocument;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class BBJMaskTextField
extends JTextField
implements KeyListener {
    private BBMaskDocument maskDocument;
    private String mascaraCampo;
    private String toolTip;

    public BBJMaskTextField(String mascaraCampo) {
        this.setMascaraCampo(mascaraCampo);
        this.addKeyListener(this);
    }

    public void setToolTipText(String toolTip) {
        this.toolTip = toolTip;
        super.setToolTipText(toolTip);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        super.setToolTipText(enabled ? this.toolTip : null);
    }

    public void alinharDireita() {
        this.setHorizontalAlignment(4);
        this.getMaskDocument().setAlinharDireita(true);
    }

    public String getMascaraCampo() {
        return this.mascaraCampo;
    }

    public void setMascaraCampo(String mascaraCampo) {
        this.mascaraCampo = mascaraCampo;
        boolean alinharDireita = false;
        if (this.getMaskDocument() != null) {
            alinharDireita = this.getMaskDocument().isAlinharDireita();
        }
        this.setMaskDocument(new BBMaskDocument(mascaraCampo));
        this.getMaskDocument().setAlinharDireita(alinharDireita);
        this.setDocument(this.getMaskDocument());
    }

    public void copy() {
    }

    public void paste() {
    }

    public BBMaskDocument getMaskDocument() {
        if (this.maskDocument == null) {
            this.maskDocument = new BBMaskDocument(this.mascaraCampo);
        }
        return this.maskDocument;
    }

    public void setMaskDocument(BBMaskDocument maskDocument) {
        this.maskDocument = maskDocument;
    }

    public void keyPressed(KeyEvent evento) {
        if (evento.getKeyCode() == 10) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            evento.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setData(String string) {
        this.setText(string);
    }

    public void setMask(String mascaraCampo) {
        this.setMascaraCampo(mascaraCampo);
    }

    public void clean() {
        this.setText("");
    }
}

