/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class BBJProgressBar
extends JPanel {
    private long valormaximo;
    private long valoratual;
    private int largurabordaoval = 5;
    private static final int DIREITA = 5;
    private static final int ESQUERDA = 10;

    public BBJProgressBar(long valormaximo) {
        this.setOpaque(false);
        this.setSize(new Dimension(0, 20));
        this.valormaximo = valormaximo;
    }

    public void setSize(Dimension dim) {
        super.setSize(dim);
        super.setPreferredSize(dim);
    }

    private double getPercent() {
        if (this.valormaximo <= 0L || this.valoratual <= 0L) {
            return 0.0;
        }
        double dpercent = this.valoratual / (this.valormaximo / 100L);
        if (dpercent > 100.0) {
            dpercent = 100.0;
        }
        return dpercent;
    }

    public void paint(Graphics g) {
        this.largurabordaoval = (int)(this.getSize().getHeight() / 2.0);
        super.paint(g);
        this.GeraBordaOval(g, new Color(212, 237, 249), 0, 10);
        this.GeraBordaOval(g, new Color(212, 237, 249), (int)this.getSize().getWidth(), 5);
        g.setColor(new Color(171, 166, 172));
        g.fillRect(this.largurabordaoval - 2, 0, (int)this.getSize().getWidth() - this.largurabordaoval * 2 + 4, 1);
        g.fillRect(this.largurabordaoval - 2, (int)this.getSize().getHeight() - 1, (int)this.getSize().getWidth() - this.largurabordaoval * 2 + 4, 1);
        g.setColor(new Color(212, 237, 249));
        g.fillRect(this.largurabordaoval, 1, (int)this.getSize().getWidth() - this.largurabordaoval * 2, (int)this.getSize().getHeight() - 2);
        if (this.getPercent() > 0.0) {
            g.setColor(new Color(204, 209, 212));
            g.fillRect(this.largurabordaoval, 1, (int)(this.getSize().getWidth() / 100.0 * this.getPercent()) - this.largurabordaoval * 2, (int)this.getSize().getHeight() - 2);
            this.GeraBordaOval(g, new Color(204, 209, 212), 0, 10);
            this.GeraBordaOval(g, new Color(204, 209, 212), (int)(this.getSize().getWidth() / 100.0 * this.getPercent()), 5);
        }
        g.setColor(Color.BLACK);
        g.setFont(new Font("Arial", 1, 11));
        String s_texto = String.valueOf((int)this.getPercent()) + "%";
        FontRenderContext frc = new FontRenderContext(null, true, false);
        Rectangle2D bounds = this.getFont().getStringBounds(s_texto, frc);
        int posicx = (int)((this.getSize().getWidth() - bounds.getWidth()) / 2.0);
        g.drawString(s_texto, posicx, (int)(this.getSize().getHeight() / 2.0 + bounds.getHeight() / 4.0));
    }

    private void GeraBordaOval(Graphics g, Color cormeio, int posicao, int direcao) {
        g.setColor(cormeio);
        int i_height = (int)this.getSize().getHeight();
        if (direcao == 10) {
            g.fillArc(posicao, 0, i_height, i_height, 90, 180);
            g.setColor(new Color(171, 166, 172));
            g.drawArc(posicao, -1, i_height + 1, i_height, 90, 180);
        } else {
            int posicleft = posicao - i_height;
            if (posicleft > 0) {
                g.fillArc(posicleft, 0, i_height, i_height, -90, 180);
                g.setColor(new Color(171, 166, 172));
                g.drawArc(posicleft - 1, 0, i_height, i_height, -90, 180);
            } else if (posicleft > -this.largurabordaoval / 2) {
                g.fillArc(posicleft, 0, i_height, i_height, -90, 180);
                g.setColor(new Color(171, 166, 172));
                g.drawArc(posicleft, 0, i_height, i_height, -90, 180);
            }
        }
    }

    public void setAddValue(int value) {
        this.valoratual += (long)value;
        if (this.valoratual > this.valormaximo) {
            this.valoratual = this.valormaximo;
        }
        this.repaint();
    }

    public long getValoratual() {
        return this.valoratual;
    }

    public void setValoratual(long valoratual) {
        this.valoratual = valoratual;
        this.repaint();
    }

    public long getValormaximo() {
        return this.valormaximo;
    }

    public void setValormaximo(long valormaximo) {
        this.valormaximo = valormaximo;
    }
}

