/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJRadioButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJRadioButtonLabel
extends JPanel
implements ActionListener {
    private String titulo;
    private int posicaoLabel = 0;
    private int quantidadeColuna;
    private int larguralabel;
    private JLabel jlTitulo;
    private ButtonGroup grupo;
    private BBJRadioButton selected = null;
    private Map<String, BBJRadioButton> opcoesRadio;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilolabel;
    private ActionListener listener;
    JPanel panelRadios = new JPanel();

    public BBJRadioButtonLabel(String titulo, int posicaoLabel, Map<String, BBJRadioButton> opcoesRadio) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesRadio = opcoesRadio;
        this.initialize();
    }

    public BBJRadioButtonLabel(String titulo, int posicaoLabel, Map<String, BBJRadioButton> opcoesRadio, int larguralabel) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesRadio = opcoesRadio;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    public BBJRadioButtonLabel(String titulo, int posicaoLabel, Map<String, BBJRadioButton> opcoesRadio, int larguralabel, int quantidadeColuna) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesRadio = opcoesRadio;
        this.quantidadeColuna = quantidadeColuna;
        this.initialize();
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] comp = this.panelRadios.getComponents();
        int i = 0;
        while (i < comp.length) {
            comp[i].setEnabled(enabled);
            ++i;
        }
    }

    private void initialize() {
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.jlTitulo = new JLabel(this.titulo);
        JLabel jlTitulo = new JLabel(" ");
        jlTitulo.setFont(this.estilolabel.getFont());
        jlTitulo.setForeground(this.estilolabel.getColor());
        jlTitulo.setText(this.titulo);
        GridBagConstraints gc = new GridBagConstraints();
        if (this.posicaoLabel == 0) {
            this.setLayout(new BoxLayout(this, 0));
            this.add(jlTitulo);
            if (this.larguralabel > 0) {
                System.out.print(this.larguralabel);
                FontRenderContext frc = new FontRenderContext(null, true, false);
                Rectangle2D bounds = jlTitulo.getFont().getStringBounds(this.titulo, frc);
                if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                    this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
                }
            }
            this.add(this.loadRadios());
        } else {
            this.setLayout(new GridBagLayout());
            gc.gridx = 0;
            gc.gridy = 0;
            gc.anchor = 17;
            this.add((Component)jlTitulo, gc);
            gc.gridy = 1;
            this.add((Component)this.loadRadios(), gc);
        }
    }

    public JPanel loadRadios() {
        if (this.opcoesRadio == null) {
            return this.panelRadios;
        }
        this.panelRadios.setOpaque(false);
        this.panelRadios.removeAll();
        Iterator<BBJRadioButton> itr = this.opcoesRadio.values().iterator();
        if (this.quantidadeColuna > 0) {
            this.panelRadios.setLayout(new GridLayout(this.GetQtdLinhas(), this.quantidadeColuna));
        } else {
            this.panelRadios.setLayout(new BoxLayout(this.panelRadios, 0));
        }
        ButtonGroup grupo = new ButtonGroup();
        while (itr.hasNext()) {
            JRadioButton radioButton = itr.next();
            grupo.add(radioButton);
            radioButton.setOpaque(false);
            radioButton.setForeground(this.estilolabel.getColor());
            radioButton.setFont(BBJEstilos.TEXTOEDITAVEL.getFont());
            radioButton.addActionListener(this);
            this.panelRadios.add(radioButton);
            this.panelRadios.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        return this.panelRadios;
    }

    private int GetQtdLinhas() {
        if (this.quantidadeColuna <= 0) {
            this.quantidadeColuna = this.opcoesRadio.size();
            return 1;
        }
        return this.opcoesRadio.size() / this.quantidadeColuna + (this.opcoesRadio.size() % this.quantidadeColuna > 0 ? 1 : 0);
    }

    public BBJRadioButton getSelected() {
        if (this.selected == null) {
            return new BBJRadioButton();
        }
        return this.selected;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public Map<String, BBJRadioButton> getOpcoesRadio() {
        return this.opcoesRadio;
    }

    public void setOpcoesRadio(Map<String, BBJRadioButton> opcoesRadio) {
        this.opcoesRadio = opcoesRadio;
    }

    public JLabel getJlTitulo() {
        return this.jlTitulo;
    }

    public void setJlTitulo(JLabel jlTitulo) {
        this.jlTitulo = jlTitulo;
    }

    public ButtonGroup getGrupo() {
        return this.grupo;
    }

    public void setGrupo(ButtonGroup grupo) {
        this.grupo = grupo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JRadioButton) {
            this.selected = (BBJRadioButton)e.getSource();
            this.fireAction(e);
        }
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null) {
            ActionEvent evt = new ActionEvent(this, 123, event.getActionCommand());
            this.listener.actionPerformed(evt);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setSelected(BBJRadioButton selected) {
        this.selected = selected;
        Component[] comp = this.panelRadios.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] instanceof BBJRadioButton) {
                ((BBJRadioButton)comp[i]).setSelected(selected == comp[i]);
            }
            ++i;
        }
        this.validateTree();
    }

    public void setSelected(int codigo) {
        Component[] comp = this.panelRadios.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] instanceof BBJRadioButton && ((BBJRadioButton)comp[i]).getCodigo() == codigo) {
                ((BBJRadioButton)comp[i]).setSelected(true);
                this.selected = (BBJRadioButton)comp[i];
                break;
            }
            ++i;
        }
    }
}

