/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.swing.componente.BBJDayChooser;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJSpin;
import java.awt.Color;
import java.util.Calendar;
import javax.swing.JFrame;

public class BBJYearChooser
extends BBJSpin {
    protected BBJDayChooser dayChooser;
    protected int startYear;
    protected int endYear;

    public BBJYearChooser() {
        Calendar calendar = Calendar.getInstance();
        this.dayChooser = null;
        this.setMinimum(calendar.getMinimum(1));
        this.setMaximum(calendar.getMaximum(1));
        this.setValue(calendar.get(1));
        this.textField.setEditable(false);
        this.setBackground(Color.WHITE);
        this.setFont(BBJEstilos.LABELTEXTO.getFont());
        this.setForeground(BBJEstilos.LABELTEXTO.getColor());
    }

    public void setYear(int y) {
        int oldYear = this.getValue();
        super.setValue(y, true, false);
        if (this.dayChooser != null) {
            this.dayChooser.setYear(this.value);
        }
        this.spinner.setValue(new Integer(this.value));
        this.firePropertyChange("year", oldYear, this.value);
    }

    public void setValue(int value) {
        this.setYear(value);
    }

    public int getYear() {
        return super.getValue();
    }

    public void setDayChooser(BBJDayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }

    public String getName() {
        return "JYearChooser";
    }

    public int getEndYear() {
        return this.getMaximum();
    }

    public void setEndYear(int endYear) {
        this.setMaximum(endYear);
    }

    public int getStartYear() {
        return this.getMinimum();
    }

    public void setStartYear(int startYear) {
        this.setMinimum(startYear);
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JYearChooser");
        frame.getContentPane().add(new BBJYearChooser());
        frame.pack();
        frame.setVisible(true);
    }
}

