/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.componente;

import br.com.bb.cdbb.util.swing.componente.BBJMask;
import br.com.bb.cdbb.util.swing.componente.FilterMask;
import br.com.bb.cdbb.util.swing.componente.Mask;
import br.com.bb.cdbb.util.swing.componente.MaskContainer;
import br.com.bb.cdbb.util.swing.componente.MaskDefinition;
import java.awt.event.KeyEvent;
import java.io.InvalidObjectException;
import java.util.Vector;

public final class MaskSet {
    private Vector containers_ = new Vector();
    private int size_;

    public MaskSet(String formato, String delim) {
        if (delim == null) {
            delim = MaskSet.getDelimiters(formato);
        }
        this.createArrayMask(formato, delim);
    }

    private void add(MaskContainer m) {
        this.containers_.addElement(m);
    }

    public void clean() {
        int tam = this.containers_.size();
        int i = 0;
        while (i < tam) {
            MaskContainer mask = (MaskContainer)this.containers_.elementAt(i);
            mask.clean();
            ++i;
        }
    }

    public int computeSpace() {
        int total = 0;
        int tam = this.containers_.size();
        int i = 0;
        while (i < tam) {
            MaskContainer mask = (MaskContainer)this.containers_.elementAt(i);
            total += mask.computeSpace();
            ++i;
        }
        return total;
    }

    private void createArrayMask(String formato, String delim) {
        MaskContainer mContainer;
        Object[] all;
        MaskDefinition def = MaskDefinition.getMaskDefinition();
        int tam = formato.length();
        Vector<Mask> subMask = new Vector<Mask>();
        Mask mAnterior = null;
        int indiceInicial = 0;
        int i = 0;
        while (i < tam) {
            char c = formato.charAt(i);
            Mask m = def.getMask(c);
            if (delim.indexOf(c) != -1 || m == null) {
                m = new Mask(c);
                m.setDelimiter(delim.indexOf(c) != -1);
            }
            if (!(m instanceof FilterMask) && !m.isDelimiter() && mAnterior != null && mAnterior.getChar() != m.getChar()) {
                all = new Mask[subMask.size()];
                subMask.copyInto(all);
                mContainer = new MaskContainer((Mask[])all, indiceInicial, i - 1);
                this.add(mContainer);
                indiceInicial = i;
                this.size_ += mContainer.count();
                subMask = new Vector();
            }
            subMask.addElement(m);
            if (!m.isDelimiter() && !(m instanceof FilterMask)) {
                mAnterior = m;
            }
            ++i;
        }
        all = new Mask[subMask.size()];
        subMask.copyInto(all);
        mContainer = new MaskContainer((Mask[])all, indiceInicial, i - 1);
        this.add(mContainer);
        this.size_ += mContainer.count();
    }

    public MaskContainer get(int posicao) {
        int tam = this.containers_.size();
        int i = 0;
        while (i < tam) {
            MaskContainer inter = (MaskContainer)this.containers_.elementAt(i);
            if (inter.estaNoIntervalo(posicao)) {
                return inter;
            }
            ++i;
        }
        return (MaskContainer)this.containers_.lastElement();
    }

    public String getData() {
        String nova = "";
        int tam = this.containers_.size();
        int i = 0;
        while (i < tam) {
            MaskContainer m = (MaskContainer)this.containers_.elementAt(i);
            nova = String.valueOf(nova) + m.getData();
            ++i;
        }
        return nova;
    }

    private static String getDelimiters(String formato) {
        char[] def = MaskDefinition.getMaskDefinition().getDefinitions();
        String defs = new String(def);
        String delim = "";
        int i = formato.length() - 1;
        while (i >= 0) {
            char c = formato.charAt(i);
            if (defs.indexOf(c) == -1) {
                delim = String.valueOf(delim) + c;
            }
            --i;
        }
        return delim;
    }

    public int getHorizontalAlignment() {
        MaskContainer inter = (MaskContainer)this.containers_.elementAt(0);
        return inter.getHorizontalAlignment();
    }

    public String getText() {
        int tam = this.containers_.size();
        String s = "";
        int i = 0;
        while (i < tam) {
            MaskContainer inter = (MaskContainer)this.containers_.elementAt(i);
            s = String.valueOf(s) + inter.getText();
            ++i;
        }
        return s;
    }

    public boolean isLimiteInferior(int posicao) {
        int tam = this.containers_.size();
        int i = 0;
        while (i < tam) {
            MaskContainer mask = (MaskContainer)this.containers_.elementAt(i);
            if (mask.getPosicaoInicio() == posicao) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLimiteSuperior(int posicao) {
        int tam = this.containers_.size();
        int i = 0;
        while (i < tam) {
            MaskContainer mask = (MaskContainer)this.containers_.elementAt(i);
            if (mask.getPosicaoFim() == posicao) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int lastPositionWritten() {
        int tam = this.containers_.size();
        int i = tam - 1;
        while (i >= 0) {
            MaskContainer mask = (MaskContainer)this.containers_.elementAt(i);
            int pos = mask.lastPositionWritten();
            if (pos != 0 && pos != -1) {
                return mask.getPosicaoInicio() + pos;
            }
            --i;
        }
        return -1;
    }

    public void setData(String s) throws InvalidObjectException {
        String nova = "";
        int tam = this.containers_.size();
        int indice = 0;
        if (this.getHorizontalAlignment() == 0) {
            int i = 0;
            while (i < tam) {
                MaskContainer m = (MaskContainer)this.containers_.elementAt(i);
                if (indice < s.length()) {
                    if (indice + m.countSemDelimitador() < s.length()) {
                        m.setData(s.substring(indice, indice + m.countSemDelimitador()));
                    } else {
                        m.setData(s.substring(indice));
                    }
                }
                indice += m.countSemDelimitador();
                ++i;
            }
        } else {
            indice = s.length();
            int i = tam - 1;
            while (i >= 0) {
                MaskContainer m = (MaskContainer)this.containers_.elementAt(i);
                if (indice >= 0) {
                    if (indice - m.countSemDelimitador() >= 0) {
                        m.setData(s.substring(indice - m.countSemDelimitador(), indice));
                    } else {
                        m.setData(s.substring(0, indice));
                    }
                }
                indice -= m.countSemDelimitador();
                --i;
            }
        }
    }

    public void setHorizontalAlignment(int align) {
        int tam = this.containers_.size();
        int i = 0;
        while (i < tam) {
            MaskContainer inter = (MaskContainer)this.containers_.elementAt(i);
            inter.setHorizontalAlignment(align);
            ++i;
        }
    }

    public void setText(String s) throws InvalidObjectException {
        String nova = "";
        int tam = this.containers_.size();
        int indice = 0;
        if (this.getHorizontalAlignment() == 0) {
            int i = 0;
            while (i < tam) {
                MaskContainer m = (MaskContainer)this.containers_.elementAt(i);
                if (indice < s.length()) {
                    if (indice + m.count() < s.length()) {
                        m.setText(s.substring(indice, indice + m.count()));
                    } else {
                        m.setText(s.substring(indice));
                    }
                }
                indice += m.count();
                ++i;
            }
        } else {
            indice = s.length();
            int i = tam - 1;
            while (i >= 0) {
                MaskContainer m = (MaskContainer)this.containers_.elementAt(i);
                if (indice >= 0) {
                    if (indice - m.count() >= 0) {
                        m.setText(s.substring(indice - m.count(), indice));
                    } else {
                        m.setText(s.substring(0, indice));
                    }
                }
                indice -= m.count();
                --i;
            }
        }
    }

    public int size() {
        return this.size_;
    }

    private boolean textSelected(BBJMask m) {
        if (m.getSelectedText() != null) {
            int pos;
            MaskContainer mContainer;
            int inicio = m.getSelectionStart();
            int fim = inicio + m.getSelectedText().length();
            Vector<Integer> posicoes = new Vector<Integer>();
            int i = inicio;
            while (i < fim) {
                mContainer = this.get(i);
                Mask mask = mContainer.getMaskAt(pos = mContainer.converter(i));
                if (!mask.isDelimiter() && mContainer.isWritten(pos)) {
                    posicoes.addElement(new Integer(i));
                }
                ++i;
            }
            if (m.getHorizontalAlignment() == 2) {
                i = posicoes.size() - 1;
                while (i >= 0) {
                    pos = (Integer)posicoes.elementAt(i);
                    mContainer = this.get(pos);
                    mContainer.cleanMaskedText(mContainer.converter(pos));
                    --i;
                }
            } else {
                i = 0;
                while (i < posicoes.size()) {
                    pos = (Integer)posicoes.elementAt(i);
                    mContainer = this.get(pos);
                    mContainer.cleanMaskedText(mContainer.converter(pos));
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public int tratarKeyPressed(int caretPos, KeyEvent evt) {
        MaskContainer mask = this.get(caretPos);
        switch (evt.getKeyCode()) {
            case 39: {
                if (caretPos >= this.size() || !this.isLimiteSuperior(caretPos)) break;
                mask = this.get(caretPos++);
                break;
            }
            case 37: {
                if (caretPos <= 0 || !this.isLimiteInferior(caretPos)) break;
                mask = this.get(caretPos--);
                break;
            }
            case 127: {
                if (!this.textSelected((BBJMask)evt.getSource())) break;
                return caretPos;
            }
            case 8: {
                if (caretPos <= 0 || !this.isLimiteInferior(caretPos)) break;
                mask = this.get(caretPos - 1);
                break;
            }
            case 36: {
                break;
            }
            case 35: {
                break;
            }
            default: {
                this.textSelected((BBJMask)evt.getSource());
            }
        }
        return mask.tratarKeyPressed(caretPos, evt);
    }
}

