/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.swing.menu;

import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemMenuServicoBean
extends JButton
implements MouseListener {
    private String txIdfrSrvc;
    private String txDcr;
    private String beanid;
    private String tipo;
    private boolean expanded = false;
    private boolean aplicarseguranca;
    private boolean addlistener = false;
    private int nivel;
    private BBJEstilos estilo;
    private Map<String, ItemMenuServicoBean> children;
    private ImageIcon imgIconeNormal = null;
    private ImageIcon imgIconeExpandido = null;
    private boolean underline = false;
    private boolean clicado = false;
    private String codigoAuditoria;

    public ItemMenuServicoBean() {
        this.initialize();
    }

    public ItemMenuServicoBean(String codigo, String descricao) {
        this.txIdfrSrvc = codigo;
        this.txDcr = descricao;
        this.initialize();
    }

    private void initialize() {
        this.estilo = BBJEstilos.TEXTOBARRALATERAL;
        this.setFocusable(false);
        this.setRolloverEnabled(false);
        this.setAlignmentX(8.0f);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.setBorder(null);
        this.imgIconeNormal = this.getImageIcon("/images/btSetaDir.gif");
        this.imgIconeExpandido = this.getImageIcon("/images/btSetaAbrir.gif");
        this.addMouseListener(this);
    }

    @Override
    public void setSize(Dimension dim) {
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Font fnt = this.estilo.getFont();
        if (this.isClicado() && !this.hasChildren()) {
            fnt = new Font(fnt.getFamily(), 1, fnt.getSize());
        }
        g.setColor(new Color(225, 225, 225));
        g.fillRect(0, (int)(this.getSize().getHeight() - 1.0), (int)this.getSize().getWidth(), 1);
        g.fillRect(0, 0, 1, (int)this.getSize().getHeight());
        g.fillRect((int)this.getSize().getWidth() - 1, 0, 1, (int)this.getSize().getHeight());
        if (this.hasChildren()) {
            ImageIcon icone = this.isExpanded() ? this.imgIconeExpandido : this.imgIconeNormal;
            g.drawImage(icone.getImage(), (int)(this.getSize().getWidth() - (double)icone.getIconWidth() - 6.0), 8, null, null);
        }
        g.setColor(this.estilo.getColor());
        g.setFont(fnt);
        int posicx = 3 + this.nivel * 5;
        if (this.txDcr.indexOf("|") > -1) {
            StringTokenizer tkn = new StringTokenizer(this.txDcr, "|");
            int posicy = 15;
            while (tkn.hasMoreTokens()) {
                String pedaco = tkn.nextToken();
                g.drawString(pedaco, posicx, posicy);
                if (this.underline && !this.isClicado()) {
                    Rectangle2D textBounds = this.getFontMetrics(fnt).getStringBounds(pedaco, g);
                    int y = posicy + 3;
                    int w = (int)textBounds.getWidth();
                    g.drawLine(posicx, y - 1, w + posicx, y - 1);
                }
                posicy += 15;
            }
        } else {
            g.drawString(this.txDcr, posicx, 15);
            if (this.underline && !this.isClicado()) {
                Rectangle2D textBounds = this.getFontMetrics(fnt).getStringBounds(this.txDcr, g);
                int y = 18;
                int w = (int)textBounds.getWidth();
                g.drawLine(posicx, y - 1, w + posicx, y - 1);
            }
        }
    }

    public void addChild(ItemMenuServicoBean child) {
        if (this.children == null) {
            this.children = new HashMap<String, ItemMenuServicoBean>();
        }
        this.children.put(child.getTxIdfrSrvc(), child);
    }

    public void HideChildren() {
        if (this.children != null) {
            this.HideChildren(this.children.values().iterator());
        }
    }

    private void HideChildren(Iterator<ItemMenuServicoBean> itr) {
        while (itr.hasNext()) {
            ItemMenuServicoBean imsbean = itr.next();
            imsbean.setVisible(false);
            if (!imsbean.hasChildren()) continue;
            if (imsbean.getNivel() > 1) {
                imsbean.setExpanded(false);
            }
            this.HideChildren(imsbean.getChildren().values().iterator());
        }
    }

    public void ShowChildren() {
        if (this.children != null) {
            this.ShowChildren(this.children.values().iterator());
        }
    }

    private void ShowChildren(Iterator<ItemMenuServicoBean> itr) {
        while (itr.hasNext()) {
            ItemMenuServicoBean imsbean = itr.next();
            imsbean.setVisible(true);
            imsbean.validate();
        }
    }

    public void ShowOrHide() {
        if (this.expanded) {
            this.HideChildren();
        } else {
            this.ShowChildren();
        }
        this.expanded = !this.expanded;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public String getTxIdfrSrvc() {
        return this.txIdfrSrvc;
    }

    public void setTxIdfrSrvc(String codigo) {
        this.txIdfrSrvc = codigo;
    }

    public String getTxDcr() {
        return this.txDcr;
    }

    public void setTxDcr(String descricao) {
        this.txDcr = descricao;
    }

    public Map<String, ItemMenuServicoBean> getChildren() {
        return this.children;
    }

    public void setChildren(Map<String, ItemMenuServicoBean> children) {
        this.children = children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public String getBeanid() {
        if (this.beanid == null) {
            return "";
        }
        return this.beanid;
    }

    public void setBeanid(String beanid) {
        this.beanid = beanid;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isAplicarseguranca() {
        return this.aplicarseguranca;
    }

    public void setAplicarseguranca(boolean aplicarseguranca) {
        this.aplicarseguranca = aplicarseguranca;
    }

    public boolean isAddlistener() {
        return this.addlistener;
    }

    public void setAddlistener(boolean addlistener) {
        this.addlistener = addlistener;
    }

    public int getNivel() {
        return this.nivel;
    }

    public void setNivel(int nivel) {
        this.setNivel(nivel, false);
    }

    public void setNivel(int nivel, boolean haschild) {
        this.nivel = nivel;
        switch (this.nivel) {
            case 1: {
                this.setBackground(this.hasChildren() ? new Color(215, 229, 238) : new Color(245, 245, 245));
                break;
            }
            default: {
                this.setBackground(new Color(235, 248, 255));
            }
        }
    }

    public BBJEstilos getEstilo() {
        return this.estilo;
    }

    public void setEstilo(BBJEstilos estilo) {
        this.estilo = estilo;
    }

    private ImageIcon getImageIcon(String image) {
        if (image == null || image.trim().length() == 0) {
            return null;
        }
        return new ImageIcon(this.getClass().getResource(image));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.underline = true;
        switch (this.nivel) {
            case 1: {
                this.setBackground(this.hasChildren() ? new Color(215, 229, 238) : new Color(226, 226, 226));
                break;
            }
            default: {
                this.setBackground(new Color(217, 241, 255));
            }
        }
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.underline = false;
        switch (this.nivel) {
            case 1: {
                this.setBackground(this.hasChildren() ? new Color(215, 229, 238) : new Color(245, 245, 245));
                break;
            }
            default: {
                this.setBackground(new Color(235, 248, 255));
            }
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public boolean isClicado() {
        return this.clicado;
    }

    public void setClicado(boolean clicado) {
        this.clicado = clicado;
        this.repaint();
    }

    public String getCodigoAuditoria() {
        return this.codigoAuditoria;
    }

    public void setCodigoAuditoria(String codigoAuditoria) {
        this.codigoAuditoria = codigoAuditoria;
    }
}

