/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdbb.util.view.painel;

import br.com.bb.cdbb.util.constante.Acao;
import br.com.bb.cdbb.util.swing.BBJBordaOval;
import br.com.bb.cdbb.util.swing.componente.BBJButton;
import br.com.bb.cdbb.util.swing.componente.BBJComboBoxLabel;
import br.com.bb.cdbb.util.swing.componente.BBJEstilos;
import br.com.bb.cdbb.util.swing.componente.BBJLabel;
import br.com.bb.cdbb.util.view.JanelaPrincipal;
import br.com.bb.cdbb.util.view.painel.PainelProcessoCancelado;
import br.com.bb.cdbb.util.view.painel.PainelSenhaCertificado;
import br.com.bb.cdbb.util.view.painel.PainelSenhaExpirou;
import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.swing.JPanel;

public class PainelListarCertificados {
    private BBJButton botaoCancelar = null;
    private BBJButton botaoOK = null;
    private JPanel painelBotoes = null;
    private JPanel painelPrincipal = null;
    private BBJLabel labelEmitidoPara = null;
    private BBJLabel valorEmitidoPara = null;
    private BBJLabel labelEmitidoPor = null;
    private BBJLabel valorEmitidoPor = null;
    private BBJLabel labelValidade = null;
    private BBJLabel valorValidade = null;
    private BBJComboBoxLabel cmbCertificados = null;
    private Map<String, String> opcoesCertificados;
    private JanelaPrincipal janelaPrincipal = null;

    public PainelListarCertificados(JanelaPrincipal janelaPrincipal) {
        this.janelaPrincipal = janelaPrincipal;
        this.iniciarlizarCombo();
    }

    public JPanel getPainelPrincipal() {
        if (this.painelPrincipal == null) {
            this.painelPrincipal = new JPanel();
            this.painelPrincipal.setOpaque(false);
            this.painelPrincipal.setBorder(BBJBordaOval.createOvalBorder(""));
            this.painelPrincipal.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.insets = new Insets(5, 5, 5, 5);
            gc.fill = 2;
            gc.weightx = 0.9;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 3;
            this.painelPrincipal.add((Component)this.getCmbCertificado(), gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            ++gc.gridx;
            this.painelPrincipal.add((Component)this.getLabelEmitidoPara(), gc);
            gc.weightx = 0.1;
            gc.fill = 2;
            ++gc.gridx;
            this.painelPrincipal.add((Component)this.getValorEmitidoPara(), gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            ++gc.gridx;
            this.painelPrincipal.add((Component)this.getLabelEmitidoPor(), gc);
            gc.weightx = 0.1;
            gc.fill = 2;
            ++gc.gridx;
            this.painelPrincipal.add((Component)this.getValorEmitidoPor(), gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            ++gc.gridx;
            this.painelPrincipal.add((Component)this.getLabelValidade(), gc);
            gc.weightx = 0.1;
            gc.fill = 2;
            ++gc.gridx;
            this.painelPrincipal.add((Component)this.getValorValidade(), gc);
        }
        return this.painelPrincipal;
    }

    public BBJComboBoxLabel getCmbCertificado() {
        if (this.cmbCertificados == null) {
            this.cmbCertificados = new BBJComboBoxLabel<String>("Nome: ", false, 0, this.opcoesCertificados, 250, 70);
            this.cmbCertificados.setVisible(true);
            this.cmbCertificados.getComboBox().addActionListener(this.actionListenerSelecionarCertificado());
            this.setSelectedCert(null);
        }
        return this.cmbCertificados;
    }

    private void iniciarlizarCombo() {
        this.getCmbCertificado().getComboBox().removeAllItems();
        try {
            SignerCertificate[] certs = this.janelaPrincipal.getMSigner().getPublicCerts();
            int i = 0;
            while (i < certs.length) {
                SignerCertificate cert = certs[i];
                this.getCmbCertificado().getComboBox().addItem(cert);
                if ((this.janelaPrincipal.getMDefaultCertLabel() == null || this.janelaPrincipal.getMDefaultCertLabel().equals(cert.getLabel())) && (this.janelaPrincipal.getMDefaultCertID() == null || Arrays.equals(cert.getID(), this.janelaPrincipal.getMDefaultCertID()))) {
                    this.getCmbCertificado().setSelectedItem(cert);
                }
                ++i;
            }
        }
        catch (SignerException e) {
            this.getCmbCertificado().getComboBox().removeAllItems();
            System.err.println("Erro ao carregar certificados: " + e);
        }
        if (this.getCmbCertificado().getComboBox().getSelectedObjects().length <= 0) {
            System.out.println("Nenhum certificado aceit\u00e1vel encontrado.");
        }
    }

    private ActionListener actionListenerSelecionarCertificado() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PainelListarCertificados.this.setSelectedCert((SignerCertificate)PainelListarCertificados.this.cmbCertificados.getSelectedItem());
            }
        };
        return listener;
    }

    public BBJLabel getLabelEmitidoPara() {
        if (this.labelEmitidoPara == null) {
            this.labelEmitidoPara = new BBJLabel("Emitido para:");
            this.labelEmitidoPara.setFont(BBJEstilos.LABELTEXTOBOLD.getFont());
            this.labelEmitidoPara.setHorizontalAlignment(4);
        }
        return this.labelEmitidoPara;
    }

    public BBJLabel getValorEmitidoPara() {
        if (this.valorEmitidoPara == null) {
            this.valorEmitidoPara = new BBJLabel("");
            this.valorEmitidoPara.setFont(BBJEstilos.LABELTEXTO.getFont());
            this.valorEmitidoPara.setHorizontalAlignment(2);
        }
        return this.valorEmitidoPara;
    }

    public BBJLabel getLabelEmitidoPor() {
        if (this.labelEmitidoPor == null) {
            this.labelEmitidoPor = new BBJLabel("Emitido por:");
            this.labelEmitidoPor.setFont(BBJEstilos.LABELTEXTOBOLD.getFont());
            this.labelEmitidoPor.setHorizontalAlignment(4);
        }
        return this.labelEmitidoPor;
    }

    public BBJLabel getValorEmitidoPor() {
        if (this.valorEmitidoPor == null) {
            this.valorEmitidoPor = new BBJLabel("");
            this.valorEmitidoPor.setFont(BBJEstilos.LABELTEXTO.getFont());
            this.valorEmitidoPor.setHorizontalAlignment(2);
        }
        return this.valorEmitidoPor;
    }

    public BBJLabel getLabelValidade() {
        if (this.labelValidade == null) {
            this.labelValidade = new BBJLabel("Validade do Certificado:");
            this.labelValidade.setFont(BBJEstilos.LABELTEXTOBOLD.getFont());
            this.labelValidade.setHorizontalAlignment(4);
        }
        return this.labelValidade;
    }

    public BBJLabel getValorValidade() {
        if (this.valorValidade == null) {
            this.valorValidade = new BBJLabel("");
            this.valorValidade.setFont(BBJEstilos.LABELTEXTO.getFont());
            this.valorValidade.setHorizontalAlignment(2);
        }
        return this.valorValidade;
    }

    public JPanel getPainelBotoes() {
        if (this.painelBotoes == null) {
            this.painelBotoes = new JPanel();
            this.painelBotoes.setOpaque(false);
            this.painelBotoes.setPreferredSize(new Dimension(0, 35));
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(1);
            this.painelBotoes.setLayout(layout);
            this.painelBotoes.add(this.getBotaoOK());
            this.painelBotoes.add(this.getBotaoCancelar());
        }
        return this.painelBotoes;
    }

    public BBJButton getBotaoOK() {
        if (this.botaoOK == null) {
            this.botaoOK = new BBJButton("OK");
            this.botaoOK.setSize();
            this.botaoOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PainelListarCertificados.this.validaValidadeCertificado(PainelListarCertificados.this.janelaPrincipal.getMValidadeCertificado())) {
                        PainelListarCertificados.this.janelaPrincipal.setMSignerCertificate(PainelListarCertificados.this.getSelectedCert());
                        PainelSenhaCertificado view = new PainelSenhaCertificado(PainelListarCertificados.this.janelaPrincipal);
                        PainelListarCertificados.this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), 10);
                    } else {
                        PainelSenhaExpirou painel = new PainelSenhaExpirou(PainelListarCertificados.this.janelaPrincipal);
                        PainelListarCertificados.this.janelaPrincipal.doShow(painel.getPainelPrincipal(), painel.getPainelBotoes(), 12);
                    }
                }
            });
        }
        return this.botaoOK;
    }

    public BBJButton getBotaoCancelar() {
        if (this.botaoCancelar == null) {
            this.botaoCancelar = new BBJButton("CANCELAR");
            this.botaoCancelar.setSize();
            this.botaoCancelar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PainelProcessoCancelado view = new PainelProcessoCancelado(PainelListarCertificados.this.janelaPrincipal);
                    PainelListarCertificados.this.janelaPrincipal.doShow(view.getPainelPrincipal(), view.getPainelBotoes(), Acao.PROCESSO_INTERRPOMPIDO);
                }
            });
        }
        return this.botaoCancelar;
    }

    public void setSelectedCert(SignerCertificate cert) {
        if (cert == null) {
            this.getCmbCertificado().setSelectedItem(null);
            this.getValorEmitidoPara().setText("");
            this.getValorEmitidoPor().setText("");
            this.getValorValidade().setText("          ");
            return;
        }
        if (this.getCmbCertificado().getSelectedItem() != cert) {
            this.getCmbCertificado().setSelectedItem(cert);
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        this.getValorEmitidoPara().setText(cert.getSubjectName());
        this.janelaPrincipal.setMDefaultCertLabel(cert.getSubjectName());
        this.getValorEmitidoPor().setText(cert.getIssuerName());
        this.janelaPrincipal.setMDefaultCertID(cert.getIssuerName().getBytes());
        try {
            this.getValorValidade().setText(df.format(cert.getX509Certificate().getNotAfter()));
            this.janelaPrincipal.setMValidadeCertificado(cert.getX509Certificate().getNotAfter());
        }
        catch (SignerException e) {
            System.err.println("Erro ao carregar validade do certificado: " + e);
        }
    }

    private boolean validaValidadeCertificado(Date dataValidade) {
        return !new Date().after(this.janelaPrincipal.getMValidadeCertificado());
    }

    public SignerCertificate getSelectedCert() {
        int i = this.getCmbCertificado().getSelectedIndex();
        if (i == -1) {
            return null;
        }
        return (SignerCertificate)this.getCmbCertificado().getItemAt(i);
    }
}

