/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador;

import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerKey;
import java.io.File;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public abstract class BaseSigner
implements Signer {
    private final String mConfigDir;

    public BaseSigner(String configDir) {
        this.mConfigDir = configDir;
    }

    public synchronized byte[] decrypt(byte[] data, byte[] key) throws SignerException {
        return this.callCipher(data, key, false);
    }

    public synchronized byte[] encrypt(byte[] data, byte[] key) throws SignerException {
        return this.callCipher(data, key, true);
    }

    public byte[] encrypt(byte[] data, SignerKey key) throws SignerException {
        try {
            RSAEngine cipher = new RSAEngine();
            PKCS1Encoding enc = new PKCS1Encoding((AsymmetricBlockCipher)cipher);
            RSAPublicKey rsaKey = (RSAPublicKey)key.getCertificate().getX509Certificate().getPublicKey();
            enc.init(true, (CipherParameters)new RSAKeyParameters(false, rsaKey.getModulus(), rsaKey.getPublicExponent()));
            return enc.processBlock(data, 0, data.length);
        }
        catch (DataLengthException e) {
            throw new SignerException("Erro ao cifrar dados.", e);
        }
        catch (InvalidCipherTextException e) {
            throw new SignerException("Erro ao decifrar dados.", e);
        }
        catch (IllegalArgumentException e) {
            throw new SignerException("Erro ao cifrar dados.", e);
        }
        catch (IllegalStateException e) {
            throw new SignerException("Erro ao cifrar dados.", e);
        }
    }

    public byte[] decrypt(byte[] data, SignerKey key) throws SignerException {
        try {
            RSAEngine cipher = new RSAEngine();
            PKCS1Encoding enc = new PKCS1Encoding((AsymmetricBlockCipher)cipher);
            RSAPublicKey rsaKey = (RSAPublicKey)key.getCertificate().getX509Certificate().getPublicKey();
            enc.init(false, (CipherParameters)new RSAKeyParameters(false, rsaKey.getModulus(), rsaKey.getPublicExponent()));
            return enc.processBlock(data, 0, data.length);
        }
        catch (DataLengthException e) {
            throw new SignerException("Erro ao decifrar dados.", e);
        }
        catch (InvalidCipherTextException e) {
            throw new SignerException("Erro ao decifrar dados.", e);
        }
        catch (IllegalArgumentException e) {
            throw new SignerException("Erro ao decifrar dados.", e);
        }
        catch (IllegalStateException e) {
            throw new SignerException("Erro ao decifrar dados.", e);
        }
    }

    protected String getConfigFile() throws IOException {
        File propFile = new File(this.mConfigDir, "Pkcs11.config");
        if (!propFile.exists()) {
            throw new IOException("Arquivo de configura\u00e7\u00e3o n\u00e3o encontrado: " + propFile.getAbsolutePath() + ".");
        }
        return propFile.getAbsolutePath();
    }

    protected String getConfigDir() {
        return this.mConfigDir;
    }

    private byte[] callCipher(byte[] data, byte[] key, boolean encripting) throws SignerException {
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()));
            cipher.init(encripting, (CipherParameters)new KeyParameter(key));
            int size = cipher.getOutputSize(data.length);
            byte[] result = new byte[size];
            int olen = cipher.processBytes(data, 0, data.length, result, 0);
            olen += cipher.doFinal(result, olen);
            if (olen < size) {
                byte[] tmp = new byte[olen];
                System.arraycopy(result, 0, tmp, 0, olen);
                result = tmp;
            }
            return result;
        }
        catch (DataLengthException e) {
            throw new SignerException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SignerException(e);
        }
        catch (IllegalStateException e) {
            throw new SignerException(e);
        }
        catch (InvalidCipherTextException e) {
            throw new SignerException(e);
        }
    }
}

