/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador;

import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerKey;
import br.com.bb.cdg.assinador.SignerTokenListener;
import br.com.bb.cdg.assinador.iaikLL.IAIKSigner;
import br.com.bb.cdg.assinador.util.SignerTokenEventDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class MultiSigner
implements Signer {
    private static final String[] SAFESIGN_LIB = new String[]{"aetpkss1.dll"};
    private static final String[] GEMSAFE_LIB = new String[]{"gclib.dll", "pk2priv.dll", "w32pk2ig.dll"};
    private static final String[] ENTERSAFE_LIB = new String[]{"ngp11v211.dll"};
    private static final String[] ALADDIN_LIB = new String[]{"eTPkcs11.dll"};
    private static final String[] ACS_LIB = new String[]{"acospkcs11.dll"};
    private static final String[] RAINBOW_LIB = new String[]{"dkck201.dll", "dkck232.dll", "cryptoki22.dll"};
    private static final String[] SCHLUMBERGER_LIB = new String[]{"acpkcs.dll", "slbck.dll"};
    private static final String[] SAFESIGN_LINUX_LIB = new String[]{"libaetpkss.so"};
    private static final String[] ZETTA_LINUX_LIB = new String[]{"libgpkcs11.so", "libgpkcs11.so.2"};
    private static final String[] ENTERSAFE_LINUX_LIB = new String[]{"libepsng_p11.so", "libepsng_p11.so.1", "/usr/local/ngsrv/libepsng_p11.so.1"};
    private static final String[] ALADDIN_LINUX_LIB = new String[]{"libeTPkcs11.so", "libeToken.so", "libeToken.so.4"};
    private static final String[] OPENSC_LIB = new String[]{"opensc-pkcs11.so", "/usr/lib/opensc-pkcs11.so", "/usr/lib/pkcs11/opensc-pkcs11.so"};
    private static final String[][] MODULES = new String[][]{SAFESIGN_LIB, GEMSAFE_LIB, ENTERSAFE_LIB, ALADDIN_LIB, ACS_LIB, RAINBOW_LIB, SCHLUMBERGER_LIB, SAFESIGN_LINUX_LIB, ZETTA_LINUX_LIB, ENTERSAFE_LINUX_LIB, ALADDIN_LINUX_LIB, OPENSC_LIB};
    private Signer[] mSigners;
    private Signer mCurrentSigner;
    private SignerTokenListener mTokenListeners;
    private final SignerTokenListener mListener = new SignerTokenListener(){

        public void tokenEvent(Signer signer) {
            if (MultiSigner.this.getCurrentSigner() != null) {
                return;
            }
            if (MultiSigner.this.mTokenListeners != null) {
                MultiSigner.this.mTokenListeners.tokenEvent(MultiSigner.this);
            }
        }

        public void tokenInserted(Signer signer) {
            if (signer == MultiSigner.this.getCurrentSigner()) {
                return;
            }
            MultiSigner.this.setCurrentSigner(signer);
            if (MultiSigner.this.mTokenListeners != null) {
                MultiSigner.this.mTokenListeners.tokenInserted(MultiSigner.this);
            }
        }

        public void tokenRemoved(Signer signer) {
            if (signer != null && signer != MultiSigner.this.getCurrentSigner()) {
                return;
            }
            if (MultiSigner.this.mTokenListeners != null) {
                MultiSigner.this.mTokenListeners.tokenRemoved(MultiSigner.this);
            }
            MultiSigner.this.setCurrentSigner(null);
        }
    };

    protected Signer getCurrentSigner() {
        return this.mCurrentSigner;
    }

    protected void setCurrentSigner(Signer currentSigner) {
        this.mCurrentSigner = currentSigner;
    }

    public MultiSigner() throws SignerException {
        ArrayList mods = new ArrayList(MODULES.length);
        int i = 0;
        while (i < MODULES.length) {
            int j = 0;
            while (j < MODULES[i].length) {
                if (this.carregarModulo(MODULES[i][j], mods)) break;
                ++j;
            }
            ++i;
        }
        if (mods.size() <= 0) {
            throw new SignerException("Nenhum modulo PKCS#11 foi encontrado.");
        }
        this.mSigners = new Signer[mods.size()];
        mods.toArray(this.mSigners);
        mods.clear();
    }

    protected boolean carregarModulo(String modulo, ArrayList mods) throws SignerException {
        try {
            mods.add(new IAIKSigner(modulo));
            System.out.println("Modulo PKCS#11 encontrado: " + modulo);
            System.out.flush();
            return true;
        }
        catch (SignerException e) {
            System.err.println("\nErro ao carregar modulo '" + modulo + "': " + e.getMessage());
            System.err.flush();
            e.printStackTrace();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg != null) {
                if (msg.indexOf("The specified module could not be found.") != -1 || msg.indexOf("cannot open shared object file: No such file or directory") != -1) {
                    return false;
                }
                msg = msg.replace('\r', '-').replace('\n', '-');
            }
            System.err.println("\nErro ao carregar modulo '" + modulo + "': " + msg);
            System.err.flush();
            e.printStackTrace();
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            if (msg != null) {
                msg = msg.replace('\r', '-').replace('\n', '-');
            }
            System.err.println("\nErro ao carregar modulo '" + modulo + "': " + msg);
            System.err.flush();
            t.printStackTrace();
        }
        return false;
    }

    public boolean isActive() {
        return this.mCurrentSigner != null && this.mCurrentSigner.isActive();
    }

    public boolean isLogginNeeded() {
        return this.mCurrentSigner.isLogginNeeded();
    }

    public void login(char[] pin) throws SignerException {
        this.mCurrentSigner.login(pin);
    }

    public void logout() throws SignerException {
        this.mCurrentSigner.logout();
    }

    public SignerCertificate[] getPublicCerts() throws SignerException {
        return this.mCurrentSigner.getPublicCerts();
    }

    public SignerCertificate getPublicCert(String label, byte[] id) throws SignerException {
        return this.mCurrentSigner.getPublicCert(label, id);
    }

    public byte[] encrypt(byte[] data, SignerKey key) throws SignerException {
        return this.mCurrentSigner.encrypt(data, key);
    }

    public void encrypt(InputStream in, OutputStream out, SignerKey key) throws SignerException {
        this.mCurrentSigner.encrypt(in, out, key);
    }

    public byte[] decrypt(byte[] data, SignerKey key) throws SignerException {
        return this.mCurrentSigner.decrypt(data, key);
    }

    public void decrypt(InputStream in, OutputStream out, SignerKey key) throws SignerException {
        this.mCurrentSigner.decrypt(in, out, key);
    }

    public byte[] sign(byte[] data, SignerCertificate cert) throws SignerException {
        return this.mCurrentSigner.sign(data, cert);
    }

    public byte[] sign(InputStream in, SignerCertificate cert) throws SignerException {
        return this.mCurrentSigner.sign(in, cert);
    }

    public boolean verify(byte[] data, byte[] signature, SignerCertificate cert) throws SignerException {
        return this.mCurrentSigner.verify(data, signature, cert);
    }

    public boolean verify(InputStream in, byte[] signature, SignerCertificate cert) throws SignerException {
        return this.mCurrentSigner.verify(in, signature, cert);
    }

    public void detectToken(SignerTokenListener stl) {
        boolean starting = this.mTokenListeners == null;
        this.mTokenListeners = SignerTokenEventDispatcher.add(this.mTokenListeners, stl);
        if (starting && this.mSigners != null) {
            int i = 0;
            while (i < this.mSigners.length) {
                this.mSigners[i].detectToken(this.mListener);
                ++i;
            }
        }
    }

    public void close() {
        this.mCurrentSigner = null;
        if (this.mSigners != null) {
            int i = 0;
            while (i < this.mSigners.length) {
                this.mSigners[i].close();
                ++i;
            }
        }
        this.mSigners = null;
    }
}

