/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.applet;

import br.com.bb.cdg.assinador.MultiSigner;
import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerTokenListener;
import br.com.bb.cdg.assinador.applet.PaneledApplet;
import br.com.bb.cdg.assinador.panels.MsgPanel;
import br.com.bb.cdg.assinador.panels.WaitPanel;
import java.applet.Applet;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import netscape.javascript.JSObject;

public abstract class BaseSignerApplet
extends PaneledApplet {
    private Signer mSigner;
    protected String mSendButton = null;
    private Boolean mProcessTerminated = null;
    private final WaitPanel mWaitPanel = new WaitPanel(this, "Aguarde.");
    private final MsgPanel mCardInsertedPanel = new MsgPanel(this, "Processo j\u00e1 encerrado. Remova o cart\u00e3o.");
    private final WaitPanel mWaitCardPanel = new WaitPanel(this, "Insira seu cart\u00e3o na leitora.");
    private final MsgPanel mCardRemovedPanel = new WaitPanel(this, "Aguarde.");
    private final SignerTokenListener mTokenListener = new SignerTokenListener(){

        public void tokenEvent(Signer signer) {
            BaseSignerApplet.this.processTokenEvent();
        }

        public void tokenInserted(Signer signer) {
            if (BaseSignerApplet.this.mProcessTerminated != null) {
                BaseSignerApplet.this.setCurrentPanel(BaseSignerApplet.this.mCardInsertedPanel);
            } else {
                BaseSignerApplet.this.processTokenInsertion();
            }
        }

        public void tokenRemoved(Signer signer) {
            if (BaseSignerApplet.this.mProcessTerminated != null) {
                BaseSignerApplet.this.processTermination();
            } else {
                BaseSignerApplet.this.processTokenRemotion();
            }
        }
    };

    public synchronized Signer getSigner() {
        return this.mSigner;
    }

    public void init() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (BaseSignerApplet.this.mSendButton == null) {
                    return false;
                }
                if (e.getID() == 401 && e.getKeyCode() == 9) {
                    try {
                        JSObject.getWindow((Applet)BaseSignerApplet.this).eval("javascript: mudaFoco('" + BaseSignerApplet.this.mSendButton + "');");
                    }
                    catch (Throwable t) {
                        System.err.println("Erro ao tentar focar no bot\u00e3o:" + t);
                    }
                    return true;
                }
                return false;
            }
        });
        try {
            this.mSendButton = this.getParameter("botao");
        }
        catch (Exception e) {
            System.err.println("Par\u00e2metros inv\u00e1lidos: " + e);
            this.showErrorPanel("Par\u00e2metros inv\u00e1lidos para a applet.");
            return;
        }
        try {
            String msg = this.getParameter("msg");
            if (msg != null && msg.length() > 0) {
                this.mWaitCardPanel.setMessage("Confirma\u00e7\u00e3o de " + msg + ".\nVerifique os dados da transa\u00e7\u00e3o antes de confirmar.\nInsira seu cart\u00e3o na leitora para continuar.");
            }
        }
        catch (Exception e) {
            System.err.println("Par\u00e2metros inv\u00e1lidos: " + e);
            this.showErrorPanel("Par\u00e2metros inv\u00e1lidos para a applet.");
            return;
        }
        super.init();
    }

    public synchronized void start() {
        super.start();
        if (this.isAppletSandboxed()) {
            this.showErrorPanel("Erro ao carregar applet. Applet n\u00e3o autorizada.\nFavor reiniciar o browser e acessar o site novamente\nautorizando a execu\u00e7\u00e3o da applet.");
            this.repaint();
            return;
        }
        this.setCurrentPanel(this.mWaitCardPanel);
        this.repaint();
        try {
            this.mSigner = new MultiSigner();
        }
        catch (SignerException e) {
            this.showErrorPanel("Erro ao preparar leitora: " + e.getMessage());
            return;
        }
        this.mSigner.detectToken(this.mTokenListener);
    }

    public synchronized void stop() {
        super.stop();
        if (this.mSigner != null) {
            this.mSigner.close();
            this.mSigner = null;
        }
    }

    public abstract boolean ok();

    public boolean cancel() {
        this.terminateProcess(false);
        return this.isProcessTerminated();
    }

    protected synchronized void finalize() throws Throwable {
        if (this.mSigner != null) {
            this.mSigner.close();
            this.mSigner = null;
        }
        super.finalize();
    }

    protected boolean isProcessTerminated() {
        return this.mProcessTerminated != null && (this.mSigner == null || !this.mSigner.isActive());
    }

    protected boolean getTerminationState() {
        return this.mProcessTerminated == Boolean.TRUE;
    }

    protected void processTokenEvent() {
        if (this.getCurrentPanel() != this.mWaitPanel) {
            this.setCurrentPanel(this.mWaitPanel);
        }
    }

    protected void processTokenInsertion() {
    }

    protected void processTokenRemotion() {
        this.setCurrentPanel(this.mWaitCardPanel);
    }

    protected void processTermination() {
        this.setCurrentPanel(this.mCardRemovedPanel);
        try {
            JSObject wnd = JSObject.getWindow((Applet)this);
            if (wnd == null) {
                System.out.println("N\u00e3o foi poss\u00edvel terminar o processo automaticamente.");
                this.showErrorPanel("N\u00e3o foi poss\u00edvel continuar automaticamente o processo.\r\nPressione OK para continuar.");
                return;
            }
            if (this.mSendButton != null && this.getTerminationState()) {
                wnd.eval("javascript: confirmaAssinador=1;");
                wnd.eval("javascript: trocaBotaoAction('" + this.mSendButton + "');");
            }
            wnd.eval("javascript: appletTerminated(" + this.mProcessTerminated + ");");
        }
        catch (Throwable e) {
            System.err.println("Erro ao alertar sobre o termino da opera\u00e7\u00e3o.");
            e.printStackTrace();
            this.showErrorPanel("Erro ao continuar automaticamente o processo.\r\nPressione OK para continuar.");
        }
    }

    protected void terminateProcess(boolean state) {
        this.mProcessTerminated = state ? Boolean.TRUE : Boolean.FALSE;
        this.processTermination();
    }

    protected boolean isAppletSandboxed() {
        try {
            System.getProperty("java.io.tmpdir");
            return false;
        }
        catch (RuntimeException e) {
            return true;
        }
    }
}

