/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.iaik;

import br.com.bb.cdg.assinador.BaseSigner;
import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerKey;
import br.com.bb.cdg.assinador.SignerLoginException;
import br.com.bb.cdg.assinador.SignerTokenListener;
import br.com.bb.cdg.assinador.iaik.IAIKSignerCertificate;
import br.com.bb.cdg.assinador.iaik.IAIKSignerKey;
import br.com.bb.cdg.assinador.iaik.IAIKTokenListenerThread;
import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.crypto.digests.SHA1Digest;

public final class IAIKSigner
extends BaseSigner {
    private Module mModule;
    private Session mSession;
    private IAIKTokenListenerThread mTokenListenerThread;
    private static final Object syncLoadSesssion = new Object();

    public IAIKSigner(String configDir) throws SignerException, IOException {
        super(configDir);
        this.loadModule();
        this.loadSession();
    }

    public synchronized boolean isActive() {
        return this.mModule != null && this.mSession != null;
    }

    protected Module getModule() {
        return this.mModule;
    }

    protected String getModuleLib() throws IOException {
        if (this.getConfigDir().indexOf(".dll") != -1 || this.getConfigDir().indexOf(".so") != -1) {
            return this.getConfigDir();
        }
        String configName = this.getConfigFile();
        Properties prop = new Properties();
        prop.load(new FileInputStream(configName));
        return prop.getProperty("library");
    }

    protected Object getObject(GenericTemplate modelo, String descricao) throws SignerException {
        iaik.pkcs.pkcs11.objects.Object[] objs;
        try {
            this.mSession.findObjectsInit(modelo);
            objs = this.mSession.findObjects(2);
            this.mSession.findObjectsFinal();
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao recuperar o objeto '" + descricao + "': " + e.getMessage(), e);
        }
        if (objs.length == 0) {
            throw new SignerException("N\u00e3o encontrado nenhum objeto '" + descricao + "'.");
        }
        if (objs.length > 1) {
            throw new SignerException("N\u00famero inv\u00e1lido de objetos '" + descricao + "' encontrados.");
        }
        return objs[0];
    }

    protected RSAPrivateKey getPrivateKey(IAIKSignerCertificate cert) throws SignerException {
        try {
            GenericTemplate gt = new GenericTemplate();
            gt.addAllAttributes(new RSAPrivateKey());
            gt.addAttribute(cert.getCertificate().getLabel());
            if (cert.getCertificate().getId().isPresent()) {
                gt.addAttribute(cert.getCertificate().getId());
            }
            return (RSAPrivateKey)this.getObject(gt, "chave privada");
        }
        catch (SignerException e) {
            if (!cert.getCertificate().getId().isPresent() || !e.getMessage().startsWith("N\u00e3o encontrado nenhum objeto")) {
                throw e;
            }
            GenericTemplate gt = new GenericTemplate();
            gt.addAllAttributes(new RSAPrivateKey());
            gt.addAttribute(cert.getCertificate().getId());
            return (RSAPrivateKey)this.getObject(gt, "chave privada");
        }
    }

    protected RSAPublicKey getPublicKey(IAIKSignerCertificate cert) throws SignerException {
        try {
            GenericTemplate gt = new GenericTemplate();
            gt.addAllAttributes(new PublicKey());
            gt.addAttribute(cert.getCertificate().getLabel());
            if (cert.getCertificate().getId().isPresent()) {
                gt.addAttribute(cert.getCertificate().getId());
            }
            return (RSAPublicKey)this.getObject(gt, "chave p\u00fablica");
        }
        catch (SignerException e) {
            if (!cert.getCertificate().getId().isPresent() || !e.getMessage().startsWith("N\u00e3o encontrado nenhum objeto")) {
                throw e;
            }
            GenericTemplate gt = new GenericTemplate();
            gt.addAllAttributes(new PublicKey());
            gt.addAttribute(cert.getCertificate().getId());
            return (RSAPublicKey)this.getObject(gt, "chave p\u00fablica");
        }
    }

    public SignerCertificate[] getPublicCerts() throws SignerException {
        iaik.pkcs.pkcs11.objects.Object[] objs;
        if (!this.isActive()) {
            return null;
        }
        try {
            this.mSession.findObjectsInit(new Certificate());
            objs = this.mSession.findObjects(100);
            this.mSession.findObjectsFinal();
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao recuperar certificados: " + e.getMessage(), e);
        }
        if (objs.length == 0) {
            throw new SignerException("Certificado n\u00e3o encontrado.");
        }
        ArrayList<IAIKSignerCertificate> list = new ArrayList<IAIKSignerCertificate>(objs.length);
        int i = 0;
        while (i < objs.length) {
            X509PublicKeyCertificate x509;
            IAIKSignerCertificate cert;
            if (objs[i] instanceof X509PublicKeyCertificate && (cert = new IAIKSignerCertificate((Signer)this, x509 = (X509PublicKeyCertificate)objs[i])).isICP() && cert.isA3()) {
                list.add(cert);
            }
            ++i;
        }
        SignerCertificate[] arr = new SignerCertificate[list.size()];
        return list.toArray(arr);
    }

    public SignerCertificate getPublicCert(String label, byte[] id) throws SignerException {
        X509PublicKeyCertificate x509;
        IAIKSignerCertificate cert;
        GenericTemplate gt = new GenericTemplate();
        gt.addAllAttributes(new X509PublicKeyCertificate());
        CharArrayAttribute ca = new CharArrayAttribute(Attribute.LABEL);
        ca.setCharArrayValue(label.toCharArray());
        gt.addAttribute(ca);
        if (id != null && id.length > 0) {
            ByteArrayAttribute ba = new ByteArrayAttribute(Attribute.ID);
            ba.setByteArrayValue(id);
            gt.addAttribute(ba);
        }
        if (!(cert = new IAIKSignerCertificate((Signer)this, x509 = (X509PublicKeyCertificate)this.getObject(gt, "certificado p\u00fablico"))).isICP() || !cert.isA3()) {
            throw new SignerException("Certificado p\u00fablico n\u00e3o \u00e9 v\u00e1lido.");
        }
        return cert;
    }

    public boolean isLogginNeeded() {
        try {
            return this.mSession.getToken().getTokenInfo().isLoginRequired();
        }
        catch (TokenException e) {
            return true;
        }
    }

    public void login(char[] pin) throws SignerException, SignerLoginException {
        try {
            this.mSession.login(true, pin);
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() == 256L) {
                return;
            }
            if (e.getErrorCode() == 162L || e.getErrorCode() == 160L || e.getErrorCode() == 161L) {
                throw new SignerLoginException("O PIN informado \u00e9 invalido: " + e.getMessage(), e);
            }
            if (e.getErrorCode() == 164L || e.getErrorCode() == 163L) {
                throw new SignerLoginException("O PIN informado n\u00e3o pode ser utilizado: " + e.getMessage(), e);
            }
            if (e.getErrorCode() == 258L) {
                throw new SignerLoginException("O cart\u00e3o n\u00e3o tem um PIN inicializado: " + e.getMessage(), e);
            }
            throw new SignerException("Erro no login: " + e.getMessage(), e);
        }
        catch (TokenException e) {
            throw new SignerException("Erro no login: " + e.getMessage(), e);
        }
    }

    public void logout() throws SignerException {
        if (this.mSession != null) {
            try {
                this.mSession.logout();
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() == 257L) {
                    return;
                }
                throw new SignerException("Erro ao fechar sess\u00e3o: " + e.getMessage(), e);
            }
            catch (TokenException e) {
                throw new SignerException("Erro ao fechar sess\u00e3o: " + e.getMessage(), e);
            }
        }
    }

    public byte[] sign(byte[] data, SignerCertificate cert) throws SignerException {
        try {
            this.mSession.signInit(Mechanism.RSA_PKCS, ((IAIKSignerKey)cert.getPrivateKey()).getKey());
            return this.mSession.sign(this.generateSignData(new ByteArrayInputStream(data)));
        }
        catch (IOException e) {
            throw new SignerException("Erro ao gerar assinatura: " + e.getMessage(), e);
        }
        catch (PKCS11Exception e) {
            throw new SignerException("Erro ao assinar dados: " + e.getMessage(), e);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao assinar dados: " + e.getMessage(), e);
        }
    }

    public byte[] sign(InputStream in, SignerCertificate cert) throws SignerException {
        try {
            this.mSession.signInit(Mechanism.RSA_PKCS, ((IAIKSignerKey)cert.getPrivateKey()).getKey());
            return this.mSession.sign(this.generateSignData(in));
        }
        catch (IOException e) {
            throw new SignerException("Erro ao gerar assinatura: " + e.getMessage(), e);
        }
        catch (PKCS11Exception e) {
            throw new SignerException("Erro ao assinar dados: " + e.getMessage(), e);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao assinar dados: " + e.getMessage(), e);
        }
    }

    protected byte[] generateSignData(InputStream in) throws IOException {
        int size;
        SHA1Digest digest = new SHA1Digest();
        byte[] hash = new byte[digest.getDigestSize()];
        byte[] data = new byte[8192];
        while ((size = in.read(data)) != -1) {
            digest.update(data, 0, size);
        }
        digest.doFinal(hash, 0);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        dOut.writeObject((Object)new DigestInfo(new AlgorithmIdentifier(new DERObjectIdentifier("1.3.14.3.2.26"), null), hash));
        return bOut.toByteArray();
    }

    public boolean verify(byte[] data, byte[] signature, SignerCertificate cert) throws SignerException {
        try {
            this.mSession.verifyInit(Mechanism.SHA1_RSA_PKCS, ((IAIKSignerKey)cert.getPublicKey()).getKey());
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao verificar assinatura: " + e.getMessage(), e);
        }
        try {
            this.mSession.verify(data, signature);
            return true;
        }
        catch (TokenException e) {
            return false;
        }
    }

    public boolean verify(InputStream in, byte[] signature, SignerCertificate cert) throws SignerException {
        try {
            int size;
            this.mSession.verifyInit(Mechanism.SHA1_RSA_PKCS, ((IAIKSignerKey)cert.getPublicKey()).getKey());
            byte[] data = new byte[8192];
            while ((size = in.read(data)) != -1) {
                if (size == data.length) {
                    this.mSession.verifyUpdate(data);
                    continue;
                }
                byte[] bufferBurro = new byte[size];
                System.arraycopy(data, 0, bufferBurro, 0, size);
                this.mSession.verifyUpdate(bufferBurro);
            }
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao verificar assinatura: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SignerException("Erro ao verificar assinatura: " + e.getMessage(), e);
        }
        try {
            this.mSession.verifyFinal(signature);
            return true;
        }
        catch (TokenException e) {
            return false;
        }
    }

    public byte[] encrypt(byte[] data, SignerKey key) throws SignerException {
        try {
            this.mSession.encryptInit(Mechanism.RSA_PKCS, ((IAIKSignerKey)key).getKey());
            return this.mSession.encrypt(data);
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() == 84L || e.getErrorCode() == 104L || e.getErrorCode() == 48L) {
                return super.encrypt(data, key);
            }
            throw new SignerException("Erro ao cifrar dados: " + e.getMessage(), e);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao cifrar dados: " + e.getMessage(), e);
        }
    }

    public void encrypt(InputStream in, OutputStream out, SignerKey key) throws SignerException {
        try {
            int size;
            this.mSession.encryptInit(Mechanism.RSA_PKCS, ((IAIKSignerKey)key).getKey());
            byte[] data = new byte[8192];
            while ((size = in.read(data)) != -1) {
                byte[] res;
                if (size == data.length) {
                    res = this.mSession.encryptUpdate(data);
                } else {
                    byte[] bufferBurro = new byte[size];
                    System.arraycopy(data, 0, bufferBurro, 0, size);
                    res = this.mSession.encryptUpdate(bufferBurro);
                }
                if (res == null) continue;
                out.write(res);
            }
            out.write(this.mSession.encryptFinal());
        }
        catch (IOException e) {
            throw new SignerException("Erro ao cifrar dados: " + e.getMessage(), e);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao cifrar dados: " + e.getMessage(), e);
        }
    }

    public byte[] decrypt(byte[] data, SignerKey key) throws SignerException {
        try {
            this.mSession.decryptInit(Mechanism.RSA_PKCS, ((IAIKSignerKey)key).getKey());
            return this.mSession.decrypt(data);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao decifrar dados: " + e.getMessage(), e);
        }
    }

    public void decrypt(InputStream in, OutputStream out, SignerKey key) throws SignerException {
        try {
            int size;
            this.mSession.decryptInit(Mechanism.RSA_PKCS, ((IAIKSignerKey)key).getKey());
            byte[] data = new byte[8192];
            while ((size = in.read(data)) != -1) {
                byte[] res;
                if (size == data.length) {
                    res = this.mSession.decryptUpdate(data);
                } else {
                    byte[] bufferBurro = new byte[size];
                    System.arraycopy(data, 0, bufferBurro, 0, size);
                    res = this.mSession.decryptUpdate(bufferBurro);
                }
                if (res == null) continue;
                out.write(res);
            }
            out.write(this.mSession.decryptFinal());
        }
        catch (IOException e) {
            throw new SignerException("Erro ao decifrar dados: " + e.getMessage(), e);
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao decifrar dados: " + e.getMessage(), e);
        }
    }

    protected synchronized void loadModule() throws IOException, SignerException {
        if (this.mModule != null) {
            return;
        }
        Module module = null;
        String library = this.getModuleLib();
        if (library == null) {
            throw new SignerException("Modulo PKCS #11 n\u00e3o especificado.");
        }
        try {
            module = Module.getInstance(library);
            module.initialize(new DefaultInitializeArgs());
        }
        catch (PKCS11Exception e) {
            if (module == null || e.getErrorCode() != 401L) {
                throw new SignerException("Leitora n\u00e3o encontrada: " + e.getMessage(), e);
            }
            try {
                module.finalize(null);
                module.initialize(new DefaultInitializeArgs());
            }
            catch (TokenException e1) {
                throw new SignerException("Erro ao reinicializar dispositivo: " + e1.getMessage(), e1);
            }
            System.err.println("Dispositivo reinicializado.");
        }
        catch (TokenException e) {
            throw new SignerException("Leitora n\u00e3o encontrada: " + e.getMessage(), e);
        }
        this.mModule = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized boolean loadSession() throws SignerException {
        try {
            Slot[] s = this.mModule.getSlotList(true);
            if (s.length == 0) {
                s = this.mModule.getSlotList(false);
                if (s.length != 0) return false;
                throw new SignerException("Leitora n\u00e3o encontrada.");
            }
            Token t = s[0].getToken();
            try {
                Object object = syncLoadSesssion;
                synchronized (object) {
                    try {
                        t.closeAllSessions();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mSession = t.openSession(true, false, null, null);
                    return true;
                }
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() != 225L) throw e;
                return false;
            }
        }
        catch (TokenException e) {
            throw new SignerException("Erro ao carregar cart\u00e3o: " + e.getMessage(), e);
        }
    }

    public synchronized void detectToken(SignerTokenListener stl) {
        if (this.mModule == null) {
            return;
        }
        if (this.mTokenListenerThread == null) {
            this.mTokenListenerThread = new IAIKTokenListenerThread(this, stl);
            this.mTokenListenerThread.start();
        } else {
            this.mTokenListenerThread.addListener(stl);
        }
    }

    public synchronized void close() {
        this.closeSession();
        this.closeModule();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected void closeSession() {
        if (this.mSession == null) {
            return;
        }
        Session s = this.mSession;
        this.mSession = null;
        try {
            s.logout();
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() != 179L && e.getErrorCode() != 224L && e.getErrorCode() != 257L) {
                System.err.println("Erro ao cancelar login: " + e);
            }
        }
        catch (TokenException e) {
            System.err.println("Erro ao cancelar login: " + e);
        }
        try {
            s.closeSession();
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() != 179L && e.getErrorCode() != 224L) {
                System.err.println("Erro ao finalizar sess\u00e3o: " + e);
            }
        }
        catch (TokenException e) {
            System.err.println("Erro ao finalizar sess\u00e3o: " + e);
        }
    }

    protected void closeModule() {
        if (this.mModule == null) {
            return;
        }
        Module m = this.mModule;
        this.mModule = null;
        if (this.mTokenListenerThread != null) {
            this.mTokenListenerThread.terminate();
            this.mTokenListenerThread = null;
        }
        try {
            m.finalize(null);
        }
        catch (TokenException e) {
            System.err.println("Erro ao finalizar modulo: " + e);
        }
        try {
            m.finalize();
        }
        catch (Throwable e) {
            System.err.println("Erro ao descarregar modulo: " + e);
        }
    }
}

