/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.iaikLL;

import br.com.bb.cdg.assinador.BaseSignerCertificate;
import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerKey;
import br.com.bb.cdg.assinador.iaikLL.IAIKSigner;
import br.com.bb.cdg.assinador.iaikLL.IAIKSignerKey;
import br.com.bb.cdg.assinador.iaikLL.IAIKUtils;
import br.com.bb.cdg.assinador.util.IcpUtils;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class IAIKSignerCertificate
extends BaseSignerCertificate {
    private final long mCertificate;
    private IAIKSignerKey mPublicKey;
    private IAIKSignerKey mPrivateKey;
    private final byte[] mID;
    private final String mLabel;
    private final String mSubject;
    private final byte[] mIssuer;

    protected IAIKSignerCertificate(Signer signer, long certificate) throws SignerException, PKCS11Exception {
        super(signer, IcpUtils.parseCert((byte[])IAIKUtils.loadAtributeValue((IAIKSigner)signer, certificate, 17L)));
        this.mCertificate = certificate;
        this.mID = (byte[])IAIKUtils.loadAtributeValue((IAIKSigner)this.getSigner(), this.mCertificate, 258L);
        this.mLabel = new String((char[])IAIKUtils.loadAtributeValue((IAIKSigner)this.getSigner(), this.mCertificate, 3L));
        this.mIssuer = (byte[])IAIKUtils.loadAtributeValue((IAIKSigner)this.getSigner(), this.mCertificate, 129L);
        byte[] data = (byte[])IAIKUtils.loadAtributeValue((IAIKSigner)this.getSigner(), this.mCertificate, 257L);
        this.mSubject = IcpUtils.extractFieldName(data);
    }

    public SignerKey getPrivateKey() throws SignerException {
        if (this.mPrivateKey == null) {
            long key = ((IAIKSigner)this.getSigner()).getPrivateKey(this);
            this.mPrivateKey = new IAIKSignerKey(this, key, true);
        }
        return this.mPrivateKey;
    }

    public SignerKey getPublicKey() throws SignerException {
        if (this.mPublicKey == null) {
            long key = ((IAIKSigner)this.getSigner()).getPublicKey(this);
            this.mPublicKey = new IAIKSignerKey(this, key, false);
        }
        return this.mPublicKey;
    }

    protected long getCertificate() {
        return this.mCertificate;
    }

    public String getLabel() {
        return this.mLabel;
    }

    protected byte[] getIssuerObjectData() {
        return this.mIssuer;
    }

    public String getIssuerName() {
        return IcpUtils.extractFieldName(this.getIssuerObjectData());
    }

    public String getSubjectName() {
        if (this.mSubject == null) {
            return null;
        }
        int pos = this.mSubject.indexOf(58);
        if (pos != -1) {
            return this.mSubject.substring(0, pos);
        }
        return this.mSubject;
    }

    public byte[] getID() {
        return this.mID;
    }

    public String toString() {
        if (this.mSubject == null) {
            return null;
        }
        int pos = this.mSubject.indexOf(58);
        if (pos != -1) {
            String nome = this.mSubject.substring(0, pos);
            String cpf = this.mSubject.substring(pos + 1);
            if (cpf.length() == 11) {
                return String.valueOf(nome) + " CPF: " + cpf.substring(0, 3) + "." + cpf.substring(3, 6) + "." + cpf.substring(6, 9) + "-" + cpf.substring(9);
            }
        }
        return this.mSubject;
    }
}

