/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.iaikLL;

import br.com.bb.cdg.assinador.SignerTokenListener;
import br.com.bb.cdg.assinador.iaikLL.IAIKSigner;
import br.com.bb.cdg.assinador.util.SignerTokenEventDispatcher;
import br.com.bb.cdg.assinador.util.TaskThread;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.InvalidParameterException;

public class IAIKTokenListenerThread
extends TaskThread {
    private final IAIKSigner mSigner;
    private SignerTokenListener mListeners;

    protected IAIKTokenListenerThread(IAIKSigner signer) {
        super("TokenListener");
        if (signer == null) {
            throw new InvalidParameterException("Assinador invalido.");
        }
        this.mSigner = signer;
    }

    protected IAIKTokenListenerThread(IAIKSigner signer, SignerTokenListener stl) {
        super("TokenListener");
        if (signer == null) {
            throw new InvalidParameterException("Assinador invalido.");
        }
        if (stl == null) {
            throw new InvalidParameterException("Listener invalido.");
        }
        this.mSigner = signer;
        this.mListeners = stl;
    }

    protected void addListener(SignerTokenListener stl) {
        this.mListeners = SignerTokenEventDispatcher.add(this.mListeners, stl);
        if (this.mSigner.isActive() && this.isRunning()) {
            this.mListeners.tokenInserted(this.mSigner);
        }
    }

    protected void removeListener(SignerTokenListener stl) {
        this.mListeners = SignerTokenEventDispatcher.remove(this.mListeners, stl);
    }

    public void run() {
        if (this.mSigner.isActive() && this.mListeners != null) {
            this.mListeners.tokenInserted(this.mSigner);
        }
        super.run();
    }

    public boolean isRunning() {
        return this.mSigner.getModule() != null && super.isRunning();
    }

    public void process() throws Exception {
        if (this.mListeners == null) {
            Thread.sleep(500L);
            return;
        }
        try {
            this.mSigner.getModule().C_WaitForSlotEvent(1L, null);
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() == 8L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                return;
            }
            throw e;
        }
        this.mListeners.tokenEvent(this.mSigner);
        if (this.mSigner.loadSession()) {
            if (this.mListeners != null) {
                this.mListeners.tokenInserted(this.mSigner);
            }
        } else {
            this.mSigner.closeSession();
            if (this.mListeners != null) {
                this.mListeners.tokenRemoved(this.mSigner);
            }
        }
    }

    public void processException(Exception e) {
        if (e instanceof PKCS11Exception && ((PKCS11Exception)e).getErrorCode() == 400L) {
            return;
        }
        super.processException(e);
    }
}

