/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.loader;

import br.com.bb.cdg.assinador.loader.Library;
import br.com.bb.cdg.assinador.loader.Linux64Library;
import br.com.bb.cdg.assinador.loader.LinuxLibrary;
import br.com.bb.cdg.assinador.loader.Win32Library;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;

public final class LibLoader {
    private static final String LIB_FILE_EXT = ".bld";
    private static final String LIB_FILE_NAME = "apfcdg";
    private static final int OS_LINUX_32 = 2;
    private static final int OS_LINUX_64 = 12;
    private static final int OS_MACOS = 3;
    private static final int OS_OS2 = 4;
    private static final int OS_UNDEF = 0;
    private static final int OS_WINDOWS_32 = 1;
    private static final int OS_WINDOWS_64 = 11;
    private static LibLoader sInstance = null;
    private final Random mRandom = new Random();
    private final File mTempDirectory = this.getTempDir();

    public static synchronized LibLoader getInstance() throws IOException {
        if (sInstance == null) {
            sInstance = new LibLoader();
        }
        return sInstance;
    }

    private LibLoader() throws IOException {
        this.cleanDir(this.mTempDirectory);
    }

    public void loadLib() throws IOException {
        File libFile = null;
        int i = 0;
        while (i < 10 && libFile == null) {
            libFile = this.createFile(this.mTempDirectory);
            ++i;
        }
        if (libFile == null) {
            throw new IOException("N\u00e3o foi poss\u00edvel criar biblioteca.");
        }
        this.loadLibData(libFile);
        try {
            System.load(libFile.getAbsolutePath());
        }
        catch (Throwable e) {
            throw new IOException("N\u00e3o foi poss\u00edvel carregar biblioteca.");
        }
    }

    protected void cleanDir(File dir) {
        block5: {
            try {
                File[] listNames = dir.listFiles();
                if (listNames == null) break block5;
                int c = 0;
                while (c < listNames.length) {
                    try {
                        listNames[c].delete();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++c;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected File createFile(File dir) {
        File file = new File(dir, LIB_FILE_NAME + this.mRandom.nextInt() + LIB_FILE_EXT);
        if (file.exists()) {
            return null;
        }
        return file;
    }

    protected int getOS() {
        String os = System.getProperty("os.name");
        String model = System.getProperty("sun.arch.data.model");
        String arch = System.getProperty("os.arch");
        if (os == null || model == null && arch == null) {
            return 0;
        }
        os = os.toLowerCase(Locale.ENGLISH).trim();
        arch = arch.toLowerCase(Locale.ENGLISH).trim();
        if (model != null && "32".equals(model) || arch != null && (arch.equals("x86") || arch.equals("i386") || arch.equals("i486") || arch.equals("i586") || arch.equals("i686"))) {
            if (os.indexOf("windows") != -1) {
                return 1;
            }
            if (os.indexOf("linux") != -1) {
                return 2;
            }
            if (os.indexOf("mac") != -1) {
                return 3;
            }
            if (os.indexOf("os/2") != -1) {
                return 4;
            }
        } else if (model != null && "64".equals(model) || arch != null && arch.equals("amd64")) {
            if (os.indexOf("windows") != -1) {
                return 11;
            }
            if (os.indexOf("linux") != -1) {
                return 12;
            }
        }
        return 0;
    }

    protected File getTempDir() throws IOException {
        File dir;
        String dirname = System.getProperty("java.io.tmpdir");
        if (dirname != null && this.checkDirectory(dir = new File(new File(dirname), ".tmp" + File.separatorChar + "tcx"))) {
            return dir;
        }
        dirname = System.getProperty("user.home");
        if (dirname != null && this.checkDirectory(dir = new File(new File(dirname), ".tmp" + File.separatorChar + "tcx"))) {
            return dir;
        }
        dir = new File(String.valueOf(File.separatorChar) + "tmp" + File.separatorChar + ".tcx");
        if (this.checkDirectory(dir)) {
            return dir;
        }
        throw new IOException("Erro ao localizar diret\u00f3rio tempor\u00e1rio.");
    }

    protected void loadLibData(File file) throws IOException {
        Library library;
        switch (this.getOS()) {
            case 1: {
                library = new Win32Library();
                break;
            }
            case 2: {
                library = new LinuxLibrary();
                break;
            }
            case 12: {
                library = new Linux64Library();
                break;
            }
            default: {
                throw new IOException("Plataforma n\u00e3o suportada.");
            }
        }
        FileOutputStream fos = new FileOutputStream(file);
        library.loadData(fos);
        fos.flush();
        fos.close();
    }

    protected boolean checkDirectory(File dir) {
        block4: {
            try {
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (dir.isDirectory() && dir.canWrite()) break block4;
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        File file = this.createFile(dir);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(69);
        fos.flush();
        fos.close();
        file.delete();
        return true;
    }
}

