/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.panels;

import br.com.bb.cdg.assinador.applet.BaseSignerApplet;
import br.com.bb.cdg.assinador.panels.ActivePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class BranchListPanel
extends ActivePanel {
    private JTable mBranchesTable = null;
    private JPanel mTextPainel = null;
    private final JTextField mBranch = new JTextField(6);
    private final JTextField mAcount = new JTextField(13);

    public BranchListPanel(BaseSignerApplet applet) {
        super(applet);
        this.initialize();
    }

    public void loadData(byte[] data) {
        DefaultTableModel mdl = (DefaultTableModel)this.mBranchesTable.getModel();
        while (mdl.getRowCount() > 0) {
            mdl.removeRow(0);
        }
        String s = new String(data);
        int count = Integer.parseInt(s.substring(0, 2));
        this.mTextPainel.setVisible(count >= 10);
        while (--count >= 0) {
            int i = 2 + count * 16;
            Object[] v = new Object[]{s.substring(i, i += 4), s.substring(i, i += 11), s.substring(i++, i)};
            mdl.addRow(v);
        }
    }

    public void init() {
        this.mBranchesTable.clearSelection();
        this.mAcount.setText("");
        this.mBranch.setText("");
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPnlTable(), "Center");
        this.add((Component)this.getTextPanel(), "South");
    }

    public List validateDataState() {
        if (this.getBranch() == null) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("Selecione uma agencia/conta" + (this.mTextPainel.isVisible() ? " ou digite, se n\u00e3o estiver listada" : "") + ".");
            return l;
        }
        return super.validateDataState();
    }

    private JTable getBranchesTable() {
        if (this.mBranchesTable == null) {
            DefaultTableModel model = new DefaultTableModel(){

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            model.setColumnIdentifiers(new Object[]{"Agencia", "Conta", "Titularidade"});
            DefaultTableColumnModel colModel = new DefaultTableColumnModel();
            TableColumn col = new TableColumn(0, 90);
            col.setHeaderValue("Agencia");
            col.setMinWidth(75);
            colModel.addColumn(col);
            col = new TableColumn(1, 90);
            col.setHeaderValue("Conta");
            col.setMinWidth(75);
            colModel.addColumn(col);
            this.mBranchesTable = new JTable(model, colModel);
            this.mBranchesTable.setColumnSelectionAllowed(false);
            this.mBranchesTable.getSelectionModel().setSelectionMode(0);
        }
        return this.mBranchesTable;
    }

    private JPanel createPnlTable() {
        JPanel pnlTable = new JPanel();
        pnlTable.setLayout(new BorderLayout());
        pnlTable.setBorder(BorderFactory.createTitledBorder("Selecione a Agencia\\Conta."));
        JScrollPane spn = new JScrollPane();
        spn.setViewportView(this.getBranchesTable());
        pnlTable.add((Component)spn, "Center");
        return pnlTable;
    }

    private JPanel getTextPanel() {
        if (this.mTextPainel == null) {
            this.mTextPainel = new JPanel();
            this.mTextPainel.setLayout(new BorderLayout());
            JPanel pnl = new JPanel();
            pnl.setBorder(BorderFactory.createTitledBorder("Digite sua agencia\\conta"));
            pnl.setLayout(new GridLayout(2, 2));
            pnl.add(new JLabel("Agencia"));
            pnl.add(new JLabel("Conta"));
            pnl.add(this.mBranch);
            pnl.add(this.mAcount);
            this.mTextPainel.add((Component)pnl, "Center");
        }
        return this.mTextPainel;
    }

    public String getBranch() {
        if (this.getTextPanel().isVisible() && this.mBranch.getText() != null && this.mBranch.getText().length() > 0 && this.mAcount.getText() != null && this.mAcount.getText().length() > 0) {
            return this.mBranch.getText();
        }
        int i = this.mBranchesTable.getSelectedRow();
        if (i != 0) {
            return (String)this.mBranchesTable.getValueAt(i, 0);
        }
        return null;
    }

    public String getAcount() {
        if (this.getTextPanel().isVisible() && this.mBranch.getText() != null && this.mBranch.getText().length() > 0 && this.mAcount.getText() != null && this.mAcount.getText().length() > 0) {
            return this.mAcount.getText();
        }
        int i = this.mBranchesTable.getSelectedRow();
        if (i != 0) {
            return (String)this.mBranchesTable.getValueAt(i, 1);
        }
        return null;
    }
}

