/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.util;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class MultilineLabelUI
extends BasicLabelUI {
    protected int mStringCacheId;
    protected String[] mLinesCache;

    public static String layoutCompoundLabel(FontMetrics fm, String[] text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.length == 0 || text.length == 1 && (text[0] == null || text[0].length() == 0);
        int gap = textIsEmpty || icon == null ? 0 : textIconGap;
        String rettext = "";
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
        } else {
            textR.height = fm.getHeight() * text.length;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            String clipString = "...";
            int clipStringWidth = SwingUtilities.computeStringWidth(fm, "...");
            StringBuffer retBuffer = new StringBuffer();
            int maxStringWidth = 0;
            int i = 0;
            while (i < text.length) {
                String line = text[i];
                int totalWidth = SwingUtilities.computeStringWidth(fm, line);
                if (totalWidth > availTextWidth) {
                    totalWidth = clipStringWidth;
                    int j = 0;
                    while (j < line.length()) {
                        int charWidth = fm.charWidth(line.charAt(j));
                        if ((totalWidth += charWidth) > availTextWidth) {
                            line = line.substring(0, j - 1).concat("...");
                            totalWidth -= charWidth;
                            break;
                        }
                        ++j;
                    }
                    totalWidth = SwingUtilities.computeStringWidth(fm, line);
                }
                if (totalWidth > maxStringWidth) {
                    maxStringWidth = totalWidth;
                }
                if (retBuffer.length() > 0) {
                    retBuffer.append('\n');
                }
                retBuffer.append(line);
                ++i;
            }
            rettext = retBuffer.toString();
            textR.width = maxStringWidth;
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + Math.round((float)labelR_width / 2.0f)));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return rettext;
    }

    public static String layoutCompoundLabel(JLabel label, FontMetrics fm, String[] text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (label != null && !label.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return MultilineLabelUI.layoutCompoundLabel(fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    protected String[] splitStringByLines(String str) {
        if (str.hashCode() == this.mStringCacheId) {
            return this.mLinesCache;
        }
        this.mStringCacheId = str.hashCode();
        int lines = 1;
        int i = 0;
        int c = str.length();
        while (i < c) {
            if (str.charAt(i) == '\n' && i != str.length() - 1) {
                ++lines;
            }
            ++i;
        }
        this.mLinesCache = new String[lines];
        StringTokenizer st = new StringTokenizer(str, "\n");
        int line = 0;
        while (st.hasMoreTokens()) {
            this.mLinesCache[line++] = st.nextToken();
        }
        return this.mLinesCache;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawString(Graphics g, String s, int accChar, int textX, int textY) {
        block4: {
            block3: {
                if (s.indexOf(10) != -1) break block3;
                BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
                break block4;
            }
            lines = this.splitStringByLines(s);
            height = g.getFontMetrics().getHeight();
            i = 0;
            while (i < lines.length) {
                if (accChar <= 0) ** GOTO lbl-1000
                pos1 = lines[i].indexOf(Character.toLowerCase((char)accChar));
                pos2 = lines[i].indexOf(Character.toUpperCase((char)accChar));
                pos = pos1 != -1 && pos2 != -1 ? Math.min(pos1, pos2) : (pos1 != -1 ? pos1 : pos2);
                if (pos != -1) {
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, lines[i], pos, textX, textY + height * i);
                } else lbl-1000:
                // 2 sources

                {
                    g.drawString(lines[i], textX, textY + height * i);
                }
                ++i;
            }
        }
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        String s = MultilineLabelUI.layoutCompoundLabel(label, fontMetrics, this.splitStringByLines(text), icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
        if (s.equals("")) {
            return text;
        }
        return s;
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(l.getBackground());
        this.drawString(g, s, accChar, textX, textY);
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(l.getForeground());
        this.drawString(g, s, accChar, textX, textY);
    }
}

