/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.util;

import br.com.bb.cdg.assinador.Signer;
import br.com.bb.cdg.assinador.SignerTokenListener;

public class SignerTokenEventDispatcher
implements SignerTokenListener {
    private final SignerTokenListener mListenerA;
    private final SignerTokenListener mListenerB;

    public static SignerTokenListener add(SignerTokenListener a, SignerTokenListener b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new SignerTokenEventDispatcher(a, b);
    }

    public static SignerTokenListener remove(SignerTokenListener l, SignerTokenListener oldl) {
        if (l == oldl || l == null) {
            return null;
        }
        if (l instanceof SignerTokenEventDispatcher) {
            return ((SignerTokenEventDispatcher)l).remove(oldl);
        }
        return l;
    }

    public SignerTokenEventDispatcher(SignerTokenListener a, SignerTokenListener b) {
        this.mListenerA = a;
        this.mListenerB = b;
    }

    public void tokenEvent(Signer signer) {
        this.mListenerA.tokenEvent(signer);
        this.mListenerB.tokenEvent(signer);
    }

    public void tokenInserted(Signer signer) {
        this.mListenerA.tokenInserted(signer);
        this.mListenerB.tokenInserted(signer);
    }

    public void tokenRemoved(Signer signer) {
        this.mListenerA.tokenRemoved(signer);
        this.mListenerB.tokenRemoved(signer);
    }

    protected SignerTokenListener remove(SignerTokenListener oldl) {
        if (oldl == this.mListenerA) {
            return this.mListenerB;
        }
        if (oldl == this.mListenerB) {
            return this.mListenerA;
        }
        SignerTokenListener a2 = SignerTokenEventDispatcher.remove(this.mListenerA, oldl);
        SignerTokenListener b2 = SignerTokenEventDispatcher.remove(this.mListenerB, oldl);
        if (a2 == this.mListenerA && b2 == this.mListenerB) {
            return this;
        }
        return SignerTokenEventDispatcher.add(a2, b2);
    }
}

