/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.Data;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.ObjectClassAttribute;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Object
implements Cloneable {
    protected static VendorDefinedObjectBuilder vendorObjectBuilder_;
    protected static Hashtable objectClassNames_;
    protected Hashtable attributeTable_ = new Hashtable(32);
    protected ObjectClassAttribute objectClass_;
    protected long objectHandle_ = -1L;

    public Object() {
        this.allocateAttributes();
    }

    protected Object(Session session, long objectHandle) throws TokenException {
        this.allocateAttributes();
        this.objectHandle_ = objectHandle;
        this.readAttributes(session);
    }

    public static Object getInstance(Session session, long objectHandle) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        ObjectClassAttribute objectClassAttribute = new ObjectClassAttribute();
        Object.getAttributeValue(session, objectHandle, objectClassAttribute);
        Long objectClass = objectClassAttribute.getLongValue();
        Object newObject = objectClassAttribute.isPresent() && objectClass != null ? (objectClass.equals(ObjectClass.PRIVATE_KEY) ? PrivateKey.getInstance(session, objectHandle) : (objectClass.equals(ObjectClass.PUBLIC_KEY) ? PublicKey.getInstance(session, objectHandle) : (objectClass.equals(ObjectClass.CERTIFICATE) ? Certificate.getInstance(session, objectHandle) : (objectClass.equals(ObjectClass.SECRET_KEY) ? SecretKey.getInstance(session, objectHandle) : (objectClass.equals(ObjectClass.DATA) ? Data.getInstance(session, objectHandle) : (objectClass.equals(ObjectClass.DOMAIN_PARAMETERS) ? DomainParameters.getInstance(session, objectHandle) : (objectClass.equals(ObjectClass.HW_FEATURE) ? HardwareFeature.getInstance(session, objectHandle) : ((objectClass & ObjectClass.VENDOR_DEFINED) != 0L ? Object.getUnknownObject(session, objectHandle) : Object.getUnknownObject(session, objectHandle))))))))) : Object.getUnknownObject(session, objectHandle);
        return newObject;
    }

    protected static Object getUnknownObject(Session session, long objectHandle) throws TokenException {
        Object newObject;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (vendorObjectBuilder_ != null) {
            try {
                newObject = vendorObjectBuilder_.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new Object(session, objectHandle);
            }
        } else {
            newObject = new Object(session, objectHandle);
        }
        return newObject;
    }

    public static void setVendorDefinedObjectBuilder(VendorDefinedObjectBuilder builder) {
        vendorObjectBuilder_ = builder;
    }

    public static String getObjectClassName(Long objectClass) {
        String objectClassName;
        if (objectClass == null) {
            throw new NullPointerException("Argument \"objectClass\" must not be null.");
        }
        if ((objectClass & 0x80000000L) != 0L) {
            objectClassName = "Vendor Defined";
        } else {
            if (objectClassNames_ == null) {
                Hashtable<Long, String> objectClassNames = new Hashtable<Long, String>(7);
                objectClassNames.put(ObjectClass.DATA, "Data");
                objectClassNames.put(ObjectClass.CERTIFICATE, "Certificate");
                objectClassNames.put(ObjectClass.PUBLIC_KEY, "Public Key");
                objectClassNames.put(ObjectClass.PRIVATE_KEY, "Private Key");
                objectClassNames.put(ObjectClass.SECRET_KEY, "Secret Key");
                objectClassNames.put(ObjectClass.HW_FEATURE, "Hardware Feature");
                objectClassNames.put(ObjectClass.DOMAIN_PARAMETERS, "Domain Parameters");
                objectClassNames_ = objectClassNames;
            }
            if ((objectClassName = (String)objectClassNames_.get(objectClass)) == null) {
                objectClassName = "<unknown>";
            }
        }
        return objectClassName;
    }

    public static VendorDefinedObjectBuilder getVendorDefinedObjectBuilder() {
        return vendorObjectBuilder_;
    }

    protected static void putAttributesInTable(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.CLASS, object.objectClass_);
    }

    protected void allocateAttributes() {
        this.objectClass_ = new ObjectClassAttribute();
        Object.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        Object clone;
        try {
            clone = (Object)super.clone();
            clone.objectClass_ = (ObjectClassAttribute)this.objectClass_.clone();
            clone.attributeTable_ = new Hashtable(32);
            Object.putAttributesInTable(clone);
        }
        catch (CloneNotSupportedException ex) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", ex);
        }
        return clone;
    }

    public boolean equals(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof Object) {
            Object other = (Object)otherObject;
            equal = this == other || this.objectHandle_ == other.objectHandle_ && this.objectClass_.equals(other.objectClass_);
        }
        return equal;
    }

    public Hashtable getAttributeTable() {
        return (Hashtable)this.attributeTable_.clone();
    }

    public long getObjectHandle() {
        return this.objectHandle_;
    }

    public void setObjectHandle(long objectHandle) {
        this.objectHandle_ = objectHandle;
    }

    public LongAttribute getObjectClass() {
        return this.objectClass_;
    }

    public Vector getSetAttributes() {
        Vector<CK_ATTRIBUTE> attributeCollection = new Vector<CK_ATTRIBUTE>(this.attributeTable_.size());
        Enumeration attributeEnumeration = this.attributeTable_.elements();
        while (attributeEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)attributeEnumeration.nextElement();
            if (!attribute.isPresent()) continue;
            CK_ATTRIBUTE ckAttribute = attribute.getCkAttribute();
            attributeCollection.addElement(ckAttribute);
        }
        return attributeCollection;
    }

    public int hashCode() {
        return this.objectClass_.hashCode() ^ (int)this.objectHandle_;
    }

    public void readAttributes(Session session) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("  ");
        buffer.append("Object Class: ");
        if (this.objectClass_ != null) {
            buffer.append(this.objectClass_.toString());
        } else {
            buffer.append("<unavailable>");
        }
        return buffer.toString();
    }

    public static CK_ATTRIBUTE[] getSetAttributes(Object object) throws PKCS11Exception {
        Vector setAttributes = object != null ? object.getSetAttributes() : null;
        CK_ATTRIBUTE[] ckAttributes = setAttributes != null ? Util.convertAttributesVectorToArray(setAttributes) : null;
        return ckAttributes;
    }

    protected static void getAttributeValue(Session session, long objectHandle, Attribute attribute) throws PKCS11Exception {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        PKCS11 pkcs11Module = session.getModule().getPKCS11Module();
        long sessionHandle = session.getSessionHandle();
        long attributeCode = attribute.getCkAttribute().type;
        try {
            CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
            attributeTemplateList[0].type = attributeCode;
            pkcs11Module.C_GetAttributeValue(sessionHandle, objectHandle, attributeTemplateList);
            attribute.setCkAttribute(attributeTemplateList[0]);
            attribute.setPresent(true);
            attribute.setSensitive(false);
        }
        catch (PKCS11Exception ex) {
            if (ex.getErrorCode() == 18L) {
                attribute.setPresent(false);
            }
            if (ex.getErrorCode() == 17L) {
                attribute.setPresent(true);
                attribute.setSensitive(true);
            }
            throw ex;
        }
    }

    public static interface ObjectClass {
        public static final Long DATA = new Long(0L);
        public static final Long CERTIFICATE = new Long(1L);
        public static final Long PUBLIC_KEY = new Long(2L);
        public static final Long PRIVATE_KEY = new Long(3L);
        public static final Long SECRET_KEY = new Long(4L);
        public static final Long HW_FEATURE = new Long(5L);
        public static final Long DOMAIN_PARAMETERS = new Long(6L);
        public static final Long MECHANISM = new Long(7L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }

    public static interface VendorDefinedObjectBuilder {
        public Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

