/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class X509PublicKeyCertificate
extends Certificate {
    protected ByteArrayAttribute subject_;
    protected ByteArrayAttribute id_;
    protected ByteArrayAttribute issuer_;
    protected ByteArrayAttribute serialNumber_;
    protected ByteArrayAttribute value_;

    public X509PublicKeyCertificate() {
        this.certificateType_.setLongValue(Certificate.CertificateType.X_509_PUBLIC_KEY);
    }

    protected X509PublicKeyCertificate(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.certificateType_.setLongValue(Certificate.CertificateType.X_509_PUBLIC_KEY);
    }

    public static Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X509PublicKeyCertificate(session, objectHandle);
    }

    protected static void putAttributesInTable(X509PublicKeyCertificate object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.SUBJECT, object.subject_);
        object.attributeTable_.put(Attribute.ID, object.id_);
        object.attributeTable_.put(Attribute.ISSUER, object.issuer_);
        object.attributeTable_.put(Attribute.SERIAL_NUMBER, object.serialNumber_);
        object.attributeTable_.put(Attribute.VALUE, object.value_);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject_ = new ByteArrayAttribute(Attribute.SUBJECT);
        this.id_ = new ByteArrayAttribute(Attribute.ID);
        this.issuer_ = new ByteArrayAttribute(Attribute.ISSUER);
        this.serialNumber_ = new ByteArrayAttribute(Attribute.SERIAL_NUMBER);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        X509PublicKeyCertificate.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        X509PublicKeyCertificate clone = (X509PublicKeyCertificate)super.clone();
        clone.subject_ = (ByteArrayAttribute)this.subject_.clone();
        clone.id_ = (ByteArrayAttribute)this.id_.clone();
        clone.issuer_ = (ByteArrayAttribute)this.issuer_.clone();
        clone.serialNumber_ = (ByteArrayAttribute)this.serialNumber_.clone();
        clone.value_ = (ByteArrayAttribute)this.value_.clone();
        X509PublicKeyCertificate.putAttributesInTable(clone);
        return clone;
    }

    public boolean equals(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof X509PublicKeyCertificate) {
            X509PublicKeyCertificate other = (X509PublicKeyCertificate)otherObject;
            equal = this == other || super.equals(other) && this.subject_.equals(other.subject_) && this.id_.equals(other.id_) && this.issuer_.equals(other.issuer_) && this.serialNumber_.equals(other.serialNumber_) && this.value_.equals(other.value_);
        }
        return equal;
    }

    public ByteArrayAttribute getSubject() {
        return this.subject_;
    }

    public ByteArrayAttribute getId() {
        return this.id_;
    }

    public ByteArrayAttribute getIssuer() {
        return this.issuer_;
    }

    public ByteArrayAttribute getSerialNumber() {
        return this.serialNumber_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public int hashCode() {
        return this.issuer_.hashCode() ^ this.serialNumber_.hashCode();
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.subject_);
        Object.getAttributeValue(session, this.objectHandle_, this.id_);
        Object.getAttributeValue(session, this.objectHandle_, this.issuer_);
        Object.getAttributeValue(session, this.objectHandle_, this.serialNumber_);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Subject (DER, hex): ");
        buffer.append(this.subject_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ID (hex): ");
        buffer.append(this.id_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Issuer (DER, hex): ");
        buffer.append(this.issuer_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Serial Number (DER, hex): ");
        buffer.append(this.serialNumber_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Value (BER, hex): ");
        buffer.append(this.value_.toString());
        return buffer.toString();
    }
}

