/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.atualizarsistema.view;

import br.com.bb.plugins.gac.apresentacao.atualizarsistema.action.SalvarAplicacoesAction;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.form.AtualizarSistemaForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelAtualizacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelInstalacaoBO;
import br.com.bb.plugins.gac.util.swing.componente.BBFileDownLoad;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.view.BBJFormPopup;
import br.com.politec.infra.util.UtilLog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ViewBaixarAplicativosPopup
extends BBJFormPopup
implements ActionListener {
    private ActionListener listener;
    private boolean baixougac = false;
    private boolean atualizoumodulo = false;
    private ConfiguracaoProperties config = null;
    private JPanel panelMain = null;
    private JScrollPane panelScroll = null;
    private Map context = null;
    private Boolean aplicativoComDownloadInvalido;
    private boolean aplicativoComVersaoIncompativel;
    private List<AplicativoDisponivelInstalacaoBO> listaInstalar;
    private List<AplicativoDisponivelAtualizacaoBO> listaAtualizar;

    public ViewBaixarAplicativosPopup(Frame owner) throws HeadlessException {
        super(owner);
        this.setTitulo("Mensagem da aplica\u00e7\u00e3o");
        this.setTitulointerno("Download de Aplicativos");
        this.setSize(new Dimension(680, 340));
        this.setResizable(false);
        this.initComponents();
    }

    private void initComponents() {
        this.panelMain = new JPanel();
        this.panelMain.setOpaque(false);
        this.panelMain.setLayout(new BoxLayout(this.panelMain, 1));
        this.panelScroll = new JScrollPane(this.panelMain);
        this.panelScroll.setVerticalScrollBarPolicy(20);
        this.panelScroll.setHorizontalScrollBarPolicy(31);
        this.panelScroll.setBorder(BorderFactory.createEmptyBorder());
        this.panelScroll.getViewport().setBackground(Color.WHITE);
        this.panelScroll.setPreferredSize(new Dimension(640, 158));
        this.panelScroll.getVerticalScrollBar().setPreferredSize(new Dimension(15, 0));
        this.panelScroll.getViewport().setPreferredSize(this.panelScroll.getPreferredSize());
        this.config = ConfiguracaoProperties.getConfiguracaoProperties();
        this.LimpaApplicativos();
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)this.panelScroll, "North");
        this.getBtnCancelar().removeActionListener(this.getBtnCancelar().getActionListeners()[0]);
        this.getBtnCancelar().addActionListener(this);
        this.listener = this;
    }

    public void LimpaApplicativos() {
        this.panelMain.removeAll();
        this.panelMain.add(Box.createRigidArea(new Dimension(10, 12)));
    }

    public void AdicionaAplicativo(String codigo, String nome, long tamanho, String nomejar, boolean novo) {
        JPanelLinha aplicativo = new JPanelLinha(codigo, nome, tamanho, nomejar, novo);
        aplicativo.addActionListener(this);
        this.panelMain.add(aplicativo);
        this.panelMain.add(Box.createRigidArea(new Dimension(10, 5)));
        if (codigo != null && codigo.equalsIgnoreCase("GAC")) {
            this.baixougac = true;
        }
        if (!novo) {
            this.atualizoumodulo = true;
        }
        aplicativo.IniciaDownLoad();
    }

    public static void main(String[] args) {
        ViewBaixarAplicativosPopup popup = new ViewBaixarAplicativosPopup(null);
        popup.AdicionaAplicativo("BBCLT", "Pagamento de T\u00edtulos v1.2", 1800L, "", true);
        popup.AdicionaAplicativo("BBPGAS", "Pagamento de Sal\u00e1rios v1.9", 1500L, "", true);
        popup.AdicionaAplicativo("BBDBT", "D\u00e9bito Autom\u00e1tico v2.1", 2300L, "", true);
        popup.Show();
    }

    public void Show() {
        this.doShow(null);
    }

    public void doShow(Map context) {
        this.LimpaApplicativos();
        this.habitaBotaoCancelar();
        if (context != null) {
            this.context = context;
            this.listaAtualizar = (List)context.get("LISTAATUALIZAR");
            if (this.listaAtualizar != null) {
                for (AplicativoDisponivelAtualizacaoBO aplicativoDisponivelAtualizacaoBO : this.listaAtualizar) {
                    this.AdicionaAplicativo(aplicativoDisponivelAtualizacaoBO.getCodigo(), aplicativoDisponivelAtualizacaoBO.getAplicativo(), aplicativoDisponivelAtualizacaoBO.getTamanho(), aplicativoDisponivelAtualizacaoBO.getNomejar(), false);
                }
            }
            this.listaInstalar = (List)context.get("LISTAINSTALAR");
            if (this.listaInstalar != null) {
                for (AplicativoDisponivelInstalacaoBO aplicativoDisponivelInstalacaoBO : this.listaInstalar) {
                    this.AdicionaAplicativo(aplicativoDisponivelInstalacaoBO.getCodigo(), aplicativoDisponivelInstalacaoBO.getAplicativo(), aplicativoDisponivelInstalacaoBO.getTamanho(), aplicativoDisponivelInstalacaoBO.getNomejar(), true);
                }
            }
        }
        super.doShow(context);
    }

    private void habitaBotaoCancelar() {
        this.getBtnCancelar().setEnabled(true);
    }

    private void stopDownloads() {
        int cont = 0;
        while (cont < this.panelMain.getComponentCount()) {
            if (this.panelMain.getComponent(cont) instanceof JPanelLinha) {
                ((JPanelLinha)this.panelMain.getComponent(cont)).stopDownload();
            }
            ++cont;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JPanelLinha) {
            int cont = 0;
            while (cont < this.panelMain.getComponentCount()) {
                JPanelLinha panel;
                if (this.panelMain.getComponent(cont) instanceof JPanelLinha && !(panel = (JPanelLinha)this.panelMain.getComponent(cont)).isParado()) {
                    return;
                }
                ++cont;
            }
            this.fireAction("CONCLUIDO");
        } else if (obj == this.getBtnCancelar()) {
            this.stopDownloads();
            this.ClosePopup();
        } else {
            this.AtualizarPlugins();
            this.ClosePopup();
        }
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 2008, command);
        this.fireAction(evt);
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null) {
            this.listener.actionPerformed(event);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public boolean isBaixougac() {
        return this.baixougac;
    }

    public void setBaixougac(boolean baixougac) {
        this.baixougac = baixougac;
    }

    public synchronized void AtualizarPlugins() {
        this.getBtnCancelar().setEnabled(false);
        SalvarAplicacoesAction acao = this.getActionFactory().novoSalvarAplicacoesAction();
        AtualizarSistemaForm form = (AtualizarSistemaForm)this.getForm();
        ArrayList listaAtualizar = (ArrayList)this.context.get("LISTAATUALIZAR");
        ArrayList listaInstalar = (ArrayList)this.context.get("LISTAINSTALAR");
        this.setAplicativoComVersaoIncompativel((Boolean)this.context.get("INCOMPATIVEL"));
        this.setAplicativoComDownloadInvalido((Boolean)this.context.get("INCOMPLETO"));
        if (!(listaAtualizar != null && listaAtualizar.size() != 0 || listaInstalar != null && listaInstalar.size() != 0 || !this.isAplicativoComDownloadInvalido() && !this.isAplicativoComVersaoIncompativel())) {
            BBJPopupMensagem.exibirMensagem(UtilMensagem.getInstancia().getMensagem("MI059"));
            return;
        }
        form.setAplicativosInstalados(listaInstalar);
        form.setAplicativosAtualizados(listaAtualizar);
        try {
            acao.executar(form);
            this.exibaMensagem();
        }
        catch (BBException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    private void setAplicativoComVersaoIncompativel(Boolean aplicativoComVersaoIncompativel_) {
        this.aplicativoComVersaoIncompativel = aplicativoComVersaoIncompativel_;
    }

    private void exibaMensagem() {
        if (this.isAplicativoComDownloadInvalido() || this.isAplicativoComVersaoIncompativel()) {
            BBJPopupMensagem.exibirMensagem(UtilMensagem.getInstancia().getMensagem("MI060"));
        } else {
            BBJPopupMensagem.exibirMensagem(this.getMensagem("MI002"));
        }
    }

    private boolean isAplicativoComVersaoIncompativel() {
        return this.aplicativoComVersaoIncompativel;
    }

    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoAtualizarSistemaForm();
    }

    public boolean isAtualizoumodulo() {
        return this.atualizoumodulo;
    }

    public void setAtualizoumodulo(boolean atualizoumodulo) {
        this.atualizoumodulo = atualizoumodulo;
    }

    public boolean isAplicativoComDownloadInvalido() {
        return this.aplicativoComDownloadInvalido;
    }

    public void setAplicativoComDownloadInvalido(boolean aplicativoComDownloadInvalido) {
        this.aplicativoComDownloadInvalido = aplicativoComDownloadInvalido;
    }

    public void ClosePopup() {
        this.stopDownloads();
        super.ClosePopup();
    }

    private class JPanelLinha
    extends JPanel {
        private ActionListener listener;
        private JLabel jlabelTitulo;
        private BBJProgressBar bbprogress;
        private BBFileDownLoad down = null;
        private JLabel jlAndamento;
        private String codigo;
        private long tamanho;
        private long andamento = 0L;
        private String nomejar;
        private boolean parado = false;
        private String titulo;
        private boolean novo = false;

        public JPanelLinha(String codigo, String titulo, long tamanho, String nomejar, boolean novo) {
            this.codigo = codigo;
            this.titulo = titulo;
            this.tamanho = tamanho;
            this.nomejar = nomejar;
            this.novo = novo;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 0));
            this.jlabelTitulo = new JLabel(this.titulo);
            this.jlabelTitulo.setSize(new Dimension(170, 22));
            this.jlabelTitulo.setPreferredSize(new Dimension(170, 22));
            this.jlabelTitulo.setMaximumSize(new Dimension(170, 22));
            this.bbprogress = new BBJProgressBar(this.tamanho);
            this.bbprogress.setSize(new Dimension(240, 22));
            this.bbprogress.setPreferredSize(new Dimension(240, 22));
            this.bbprogress.setMaximumSize(new Dimension(240, 22));
            this.jlAndamento = new JLabel("0 de 0 Bytes");
            this.jlAndamento.setSize(new Dimension(160, 22));
            this.jlAndamento.setPreferredSize(new Dimension(160, 22));
            this.jlAndamento.setMaximumSize(new Dimension(160, 22));
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.add(this.jlabelTitulo);
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.add(this.bbprogress);
            this.add(Box.createRigidArea(new Dimension(10, 0)));
            this.add(this.jlAndamento);
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(620, 22));
            this.setSize(new Dimension(620, 22));
            this.AtualizaPercentual(0L);
            this.down = new BBFileDownLoad(this.getNomejar(), this.getTamanho());
            this.down.setPath(ViewBaixarAplicativosPopup.this.config.getDirTemp());
            this.down.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().startsWith("POSICAO:")) {
                        JPanelLinha.this.AtualizaPercentual(Util.parseInt(e.getActionCommand().substring(8)));
                    } else if (e.getActionCommand().startsWith("INCOMPLETO:")) {
                        JPanelLinha.this.downloadIncompleto();
                    } else if (e.getActionCommand().startsWith("CANCELADO")) {
                        JPanelLinha.this.downloadCancelado();
                    } else if (!e.getActionCommand().startsWith("ERRO:") && e.getActionCommand().startsWith("CONCLUIDO:")) {
                        JPanelLinha.this.DownLoadTerminado();
                    }
                }
            });
        }

        protected synchronized void downloadCancelado() {
            this.stopDownload();
            this.DownLoadTerminado();
        }

        private synchronized void downloadIncompleto() {
            this.stopDownload();
            this.removaDaListaDeAplicativosDownloadIncompleto();
            this.DownLoadTerminado();
        }

        private void removaDaListaDeAplicativosDownloadIncompleto() {
            Boolean temArquivoInstalacaoDownloadIncompleto = false;
            Boolean temArquivoAtualizacaoDownloadIncompleto = false;
            if (this.isNovo()) {
                temArquivoInstalacaoDownloadIncompleto = this.removaDaListaDeAplicativosInstalacaoComDownloadIncompleto();
            } else {
                temArquivoAtualizacaoDownloadIncompleto = this.removaDaListaDeAplicativosAtualizacaoComDownloadIncompleto();
            }
            this.definaNoContextoSehaDownloadIncompleto(temArquivoInstalacaoDownloadIncompleto, temArquivoAtualizacaoDownloadIncompleto);
        }

        private void definaNoContextoSehaDownloadIncompleto(Boolean temArquivoInstalacaoDownloadIncompleto, Boolean temArquivoAtualizacaoDownloadIncompleto) {
            ViewBaixarAplicativosPopup.this.context.put("INCOMPLETO", new Boolean(temArquivoInstalacaoDownloadIncompleto != false || temArquivoAtualizacaoDownloadIncompleto != false));
        }

        private synchronized boolean removaDaListaDeAplicativosAtualizacaoComDownloadIncompleto() {
            AplicativoDisponivelAtualizacaoBO downloadIncompleto = this.procuraAplicativoAtualizacaoPor();
            return ((List)ViewBaixarAplicativosPopup.this.context.get("LISTAATUALIZAR")).remove(downloadIncompleto);
        }

        private AplicativoDisponivelAtualizacaoBO procuraAplicativoAtualizacaoPor() {
            for (AplicativoDisponivelAtualizacaoBO aplicativoDisponivelAtualizacaoBO : (List)ViewBaixarAplicativosPopup.this.context.get("LISTAATUALIZAR")) {
                if (!aplicativoDisponivelAtualizacaoBO.getCodigo().equalsIgnoreCase(this.getCodigo())) continue;
                return aplicativoDisponivelAtualizacaoBO;
            }
            return null;
        }

        private synchronized boolean removaDaListaDeAplicativosInstalacaoComDownloadIncompleto() {
            AplicativoDisponivelInstalacaoBO downloadIncompleto = this.procuraAplicativoInstalacaoPor();
            return ((List)ViewBaixarAplicativosPopup.this.context.get("LISTAINSTALAR")).remove(downloadIncompleto);
        }

        private AplicativoDisponivelInstalacaoBO procuraAplicativoInstalacaoPor() {
            for (AplicativoDisponivelInstalacaoBO aplicativoDisponivelInstalacaoBO : (List)ViewBaixarAplicativosPopup.this.context.get("LISTAINSTALAR")) {
                if (!aplicativoDisponivelInstalacaoBO.getCodigo().equalsIgnoreCase(this.getCodigo())) continue;
                return aplicativoDisponivelInstalacaoBO;
            }
            return null;
        }

        public void AtualizaPercentual(long andamento) {
            this.andamento = andamento;
            String status = "";
            try {
                status = String.valueOf(Util.formatarDecimal(andamento, 0)) + " de " + Util.formatarDecimal(this.tamanho, 0) + " Bytes";
            }
            catch (Throwable e) {
                UtilLog.getLog().debug(e);
            }
            this.getJlAndamento().setText(status);
            this.getBbprogress().setValoratual(andamento);
        }

        public BBJProgressBar getBbprogress() {
            return this.bbprogress;
        }

        public void setBbprogress(BBJProgressBar bbprogress) {
            this.bbprogress = bbprogress;
        }

        public JLabel getJlabelTitulo() {
            return this.jlabelTitulo;
        }

        public void setJlabelTitulo(JLabel jlabelTitulo) {
            this.jlabelTitulo = jlabelTitulo;
        }

        public JLabel getJlAndamento() {
            return this.jlAndamento;
        }

        public void setJlAndamento(JLabel jlAndamento) {
            this.jlAndamento = jlAndamento;
        }

        public long getTamanho() {
            return this.tamanho;
        }

        public void setTamanho(long tamanho) {
            this.tamanho = tamanho;
        }

        public String getCodigo() {
            return this.codigo;
        }

        public void setCodigo(String codigo) {
            this.codigo = codigo;
        }

        public void IniciaDownLoad() {
            Thread td = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                        JPanelLinha.this.IniciaDownLoad(JPanelLinha.this.codigo);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            };
            td.start();
        }

        private void IniciaDownLoad(String url) {
            this.down.doDownLoad();
        }

        private void DownLoadTerminado() {
            this.parado = true;
            if (this.listener != null) {
                this.fireAction("CONCLUIDO:" + this.getCodigo());
            }
        }

        public void fireAction(String command) {
            ActionEvent evt = new ActionEvent(this, 123, command);
            this.fireAction(evt);
        }

        public void fireAction(ActionEvent event) {
            if (this.listener != null) {
                this.listener.actionPerformed(event);
            }
        }

        public long getAndamento() {
            return this.andamento;
        }

        public void setAndamento(long andamento) {
            this.andamento = andamento;
        }

        public void addActionListener(ActionListener listener) {
            this.listener = listener;
        }

        public void stopDownload() {
            this.parado = true;
            this.down.setCancelar(true);
        }

        public boolean isParado() {
            return this.parado;
        }

        public void setParado(boolean parado) {
            this.parado = parado;
        }

        public String getNomejar() {
            return this.nomejar;
        }

        public void setNomejar(String nomejar) {
            this.nomejar = nomejar;
        }

        public boolean isNovo() {
            return this.novo;
        }

        public void setNovo(boolean novo) {
            this.novo = novo;
        }
    }
}

