/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.configurarexpurgo.action;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.configurarexpurgo.form.ConfigurarExpurgoForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.ConfigurarExpurgoFacade;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoSegmentoTO;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoSegmento;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiltrarExpurgoAction
extends PluginActionAbstrato {
    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ConfigurarExpurgoForm configurarExpurgoForm = this.getConfigurarExpurgoForm(form);
        List<Plugin> listaDeAplicationsInstalados = PluginController.getInstance().getPlugins();
        List<ServicoTO> listaDeAplicativosInstaladosServicoTO = this.getConfigurarExpurgoFacade().consultarListaDeServicosTO(listaDeAplicationsInstalados);
        this.filtrarListaDeServicoTO(configurarExpurgoForm, listaDeAplicativosInstaladosServicoTO);
        return null;
    }

    private void filtrarListaDeServicoTO(ConfigurarExpurgoForm configurarExpurgoForm, List<ServicoTO> listaDeAplicativosInstaladosServicoTO) {
        ArrayList<ServicoTO> listaDeAplicativosInstaladosFiltrados = new ArrayList<ServicoTO>();
        for (ServicoTO servicoTO : listaDeAplicativosInstaladosServicoTO) {
            if (!this.isPagamento(servicoTO.getTipoSegmentoTO(), configurarExpurgoForm) && !this.isRecebimento(servicoTO.getTipoSegmentoTO(), configurarExpurgoForm) && !this.isServico(servicoTO.getTipoSegmentoTO(), configurarExpurgoForm)) continue;
            listaDeAplicativosInstaladosFiltrados.add(servicoTO);
        }
        configurarExpurgoForm.setAplicativosInstalados(listaDeAplicativosInstaladosFiltrados);
    }

    private ConfigurarExpurgoForm getConfigurarExpurgoForm(PluginFormAbstrato form) {
        return (ConfigurarExpurgoForm)form;
    }

    private boolean isPagamento(TipoSegmentoTO tipoSegmentoTO, ConfigurarExpurgoForm configurarExpurgoForm) {
        Integer codigoTipoSegmento = tipoSegmentoTO.getCodigoTipoSegmento();
        return configurarExpurgoForm.isPagamento() && codigoTipoSegmento.equals(UtilDominioTipoSegmento.PAGAMENTO);
    }

    private boolean isRecebimento(TipoSegmentoTO tipoSegmentoTO, ConfigurarExpurgoForm configurarExpurgoForm) {
        Integer codigoTipoSegmento = tipoSegmentoTO.getCodigoTipoSegmento();
        return configurarExpurgoForm.isRecebimento() && codigoTipoSegmento.equals(UtilDominioTipoSegmento.RECEBIMENTO);
    }

    private boolean isServico(TipoSegmentoTO tipoSegmentoTO, ConfigurarExpurgoForm configurarExpurgoForm) {
        Integer codigoTipoSegmento = tipoSegmentoTO.getCodigoTipoSegmento();
        return configurarExpurgoForm.isServico() && codigoTipoSegmento.equals(UtilDominioTipoSegmento.SERVICO);
    }

    private ConfigurarExpurgoFacade getConfigurarExpurgoFacade() {
        return this.getFacadeFactory().novoConfigurarExpurgoFacade();
    }
}

