/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.consultarremessagerar.action;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.consultarremessagerar.form.ConsultarRemessaGerarForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.RemessaFacade;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoSegmento;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsultarAplicativosRemessaAction
extends PluginActionAbstrato {
    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ConsultarRemessaGerarForm consultarRemessaGerarForm = this.getConsultarRemessaGerarForm(form);
        RemessaTODecorator decorator = consultarRemessaGerarForm.getRemessaTODecorator();
        List<Plugin> listaDeAplicationsInstalados = PluginController.getInstance().getPlugins();
        List<Plugin> listaDeAplicationsFiltrada = this.filtrarListaAplicativos(consultarRemessaGerarForm, listaDeAplicationsInstalados);
        PaginadorTO paginadorTO = this.getRemessaFacade().consultarRemessasGerar(listaDeAplicationsFiltrada, decorator);
        Collection colecao = paginadorTO.getColecaoDeRegistros();
        consultarRemessaGerarForm.setColecaoRemessaTODecorator(colecao);
        return null;
    }

    private List<Plugin> filtrarListaAplicativos(ConsultarRemessaGerarForm consultarRemessaGerarForm, List<Plugin> listaDeAplicativosInstalados) {
        ArrayList<Plugin> retorno = new ArrayList<Plugin>();
        for (Plugin plugin : listaDeAplicativosInstalados) {
            if (!this.isPagamento(plugin.getTipoSegmento(), consultarRemessaGerarForm) && !this.isRecebimento(plugin.getTipoSegmento(), consultarRemessaGerarForm) && !this.isServico(plugin.getTipoSegmento(), consultarRemessaGerarForm)) continue;
            retorno.add(plugin);
        }
        return retorno;
    }

    private ConsultarRemessaGerarForm getConsultarRemessaGerarForm(PluginFormAbstrato form) {
        return (ConsultarRemessaGerarForm)form;
    }

    private boolean isPagamento(String tipoSegmento, ConsultarRemessaGerarForm consultarRemessaGerarForm) {
        Integer codigoTipoSegmento = null;
        if (tipoSegmento != null && !tipoSegmento.equals("")) {
            codigoTipoSegmento = Integer.parseInt(tipoSegmento);
        }
        return consultarRemessaGerarForm.isPagamento() && UtilDominioTipoSegmento.PAGAMENTO.equals(codigoTipoSegmento);
    }

    private boolean isRecebimento(String tipoSegmento, ConsultarRemessaGerarForm consultarRemessaGerarForm) {
        Integer codigoTipoSegmento = null;
        if (tipoSegmento != null && !tipoSegmento.equals("")) {
            codigoTipoSegmento = Integer.parseInt(tipoSegmento);
        }
        return consultarRemessaGerarForm.isRecebimento() && UtilDominioTipoSegmento.RECEBIMENTO.equals(codigoTipoSegmento);
    }

    private boolean isServico(String tipoSegmento, ConsultarRemessaGerarForm consultarRemessaGerarForm) {
        Integer codigoTipoSegmento = null;
        if (tipoSegmento != null && !tipoSegmento.equals("")) {
            codigoTipoSegmento = Integer.parseInt(tipoSegmento);
        }
        return consultarRemessaGerarForm.isServico() && UtilDominioTipoSegmento.SERVICO.equals(codigoTipoSegmento);
    }

    private RemessaFacade getRemessaFacade() {
        return this.getFacadeFactory().novoRemessaFacade();
    }
}

