/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.consultarremessagerar.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.consultarremessagerar.action.AvancarGerarRemessaAction;
import br.com.bb.plugins.gac.apresentacao.consultarremessagerar.action.ConsultarAplicativosRemessaAction;
import br.com.bb.plugins.gac.apresentacao.consultarremessagerar.form.ConsultarRemessaGerarForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.objecttablemodel.GerarRemessaBO;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPanelCheckBox;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGerarRemessa
extends BasicInternalFrame {
    private final String[] columnNames = new String[]{"Servi\u00e7o", "N\u00ba de Conv\u00eanio", "N\u00ba de Lan\u00e7amentos", "Valor"};
    private final int[] columnSizes = new int[]{250, 150, 150, 150};
    private final int[] columnAligment = new int[]{2, 4, 4, 4};
    protected JTable table;
    protected JScrollPane scroller;
    protected BBJTable<GerarRemessaBO> tableModel;
    private JPanel panelTabela;
    private JPanel panelMain = null;
    private JPanel panelCentro = null;
    private BBJPanelCheckBox panelCheckBox = null;
    private JPanel panelSuperior = null;
    private JPanel panelInferior = null;
    private JPanel panelTotalRegistros = null;
    private JPanel panelBotoes = null;
    private BBJButton botaoMarcarTodos = null;
    private BBJButton botaoDesmarcarTodos = null;
    private BBJButton botaoAvancar = null;
    private BBJButton botaoVoltar = null;
    private BBJLabel lblTotalRegistros = null;
    private BBJPaginacao paginacao;
    private Map context;

    public ViewGerarRemessa() {
        super("Consultar Remessa", false, false);
        this.initComponents();
    }

    private void initComponents() {
        this.add(this.getPanelMain());
    }

    public void posExecucaoConsultarAplicativosRemessaAction() {
        BBJTable<GerarRemessaBO> model = this.getTableModel();
        this.getConsultarRemessaGerarForm().setTipoOrdenacao(model.getTipoordenacao());
        this.getConsultarRemessaGerarForm().setNomeColunaOrdenada(model.getNomeColunaOrdenada());
        Vector<GerarRemessaBO> dados = new Vector<GerarRemessaBO>();
        Collection<RemessaTODecorator> colecao = this.getConsultarRemessaGerarForm().getColecaoRemessaTODecorator();
        for (RemessaTODecorator remessaTODecorator : colecao) {
            dados.add(new GerarRemessaBO(remessaTODecorator));
        }
        this.getTableModel().setDataListTabela(dados);
        String totalRegistros = "  Total de registros: " + dados.size();
        this.getLblTotalRegistros().setText(totalRegistros);
        if (dados.size() == 0) {
            BBJPopupMensagem.exibirMensagem(this.getMensagem("MP004"));
        }
        this.habilitarBotoes();
    }

    private void atualizaTabela() {
        ConsultarAplicativosRemessaAction action = this.getActionFactory().novoConsultarAplicativosRemessaAction();
        try {
            action.executar(this.getForm());
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(e.getMessage());
        }
        BBJTable<GerarRemessaBO> model = this.getTableModel();
        this.getConsultarRemessaGerarForm().setTipoOrdenacao(model.getTipoordenacao());
        this.getConsultarRemessaGerarForm().setNomeColunaOrdenada(model.getNomeColunaOrdenada());
        Vector<GerarRemessaBO> dados = new Vector<GerarRemessaBO>();
        Collection<RemessaTODecorator> colecao = this.getConsultarRemessaGerarForm().getColecaoRemessaTODecorator();
        for (RemessaTODecorator remessaTODecorator : colecao) {
            dados.add(new GerarRemessaBO(remessaTODecorator));
        }
        this.getTableModel().setDataListTabela(dados);
        String totalRegistros = "  Total de registros: " + dados.size();
        this.getLblTotalRegistros().setText(totalRegistros);
        this.habilitarBotoes();
    }

    public JPanel getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new JPanel();
            this.panelMain.setOpaque(false);
            this.panelMain.setLayout(new BorderLayout());
            this.panelMain.add((Component)this.getPanelCentro(), "Center");
        }
        return this.panelMain;
    }

    private JPanel getTotalRegistros() {
        if (this.panelTotalRegistros == null) {
            this.panelTotalRegistros = new JPanel();
            this.panelTotalRegistros.setOpaque(false);
            FlowLayout flw = new FlowLayout();
            flw.setAlignment(0);
            this.panelTotalRegistros.setLayout(flw);
            this.panelTotalRegistros.add(this.getLblTotalRegistros());
            this.panelTotalRegistros.setPreferredSize(new Dimension(200, 30));
        }
        return this.panelTotalRegistros;
    }

    public BBJLabel getLblTotalRegistros() {
        if (this.lblTotalRegistros == null) {
            this.lblTotalRegistros = new BBJLabel("0");
        }
        return this.lblTotalRegistros;
    }

    private JPanel GetPanelSuperior() {
        if (this.panelSuperior == null) {
            this.panelSuperior = new JPanel();
            this.panelSuperior.setOpaque(false);
            this.panelSuperior.setLayout(new BorderLayout());
            this.panelSuperior.add((Component)this.getPanelCheckBox(), "North");
            this.panelSuperior.add((Component)this.getPanelTabela(), "Center");
        }
        return this.panelSuperior;
    }

    public BBJPanelCheckBox getPanelCheckBox() {
        if (this.panelCheckBox == null) {
            this.panelCheckBox = new BBJPanelCheckBox(4, this.getConsultarAplicativosRemessaAction());
            this.panelCheckBox.setBorder(BBJBordaOval.createOvalBorder());
            this.panelCheckBox.setPreferredSize(new Dimension(200, 60));
        }
        return this.panelCheckBox;
    }

    private ConsultarAplicativosRemessaAction getConsultarAplicativosRemessaAction() {
        return this.getActionFactory().novoConsultarAplicativosRemessaAction();
    }

    public JPanel getPanelCentro() {
        if (this.panelCentro == null) {
            this.panelCentro = new JPanel();
            this.panelCentro.setLayout(new BorderLayout());
            this.panelCentro.setOpaque(false);
            this.panelCentro.add((Component)this.GetPanelSuperior(), "North");
            this.panelCentro.add((Component)this.getPanelInferior(), "Center");
        }
        return this.panelCentro;
    }

    private JPanel getPanelTabela() {
        this.panelTabela = new JPanel();
        this.panelTabela.setLayout(new BorderLayout());
        Dimension d = new Dimension(600, 260);
        this.panelTabela.setSize(d);
        this.panelTabela.setPreferredSize(d);
        this.panelTabela.setOpaque(false);
        this.tableModel = this.getTableModel();
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.table.setOpaque(false);
        this.tableModel.setTableProps(this.table);
        this.panelTabela.setLayout(new BorderLayout());
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)this.table.getTableHeader(), "North");
        pnl.setPreferredSize(new Dimension(0, 230));
        pnl.add((Component)this.table, "Center");
        pnl.setBorder(BBJBordaOval.createOvalBorder());
        this.panelTabela.add((Component)pnl, "North");
        this.panelTabela.add((Component)this.getPaginacao(), "Center");
        return this.panelTabela;
    }

    public JTable getTable() {
        if (this.table == null) {
            this.table = new JTable();
        }
        return this.table;
    }

    public BBJTable<GerarRemessaBO> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BBJTable(this.columnNames, this.columnSizes, this.columnAligment, 10);
            this.tableModel.setNomeColunas(new String[]{"", "id.textoIdentificadorServico", "id.numeroConvenio", "quantidadeConvenio", "valorRemessa"});
            this.tableModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                        ViewGerarRemessa.this.habilitarBotoes();
                    } else if (e.getActionCommand().equalsIgnoreCase("NAOSELECIONADO")) {
                        ViewGerarRemessa.this.habilitarBotoes();
                    } else if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                        ViewGerarRemessa.this.atualizaTabela();
                    }
                }
            });
        }
        return this.tableModel;
    }

    private void habilitarBotoes() {
        int registrosMarcados = this.getTableModel().getItensChecadosCheckBox() != null ? this.getTableModel().getItensChecadosCheckBox().size() : 0;
        int totalRegistros = this.getTableModel().getDataListTabela() != null ? this.getTableModel().getDataListTabela().size() : 0;
        this.getBotaoAvancar().setEnabled(registrosMarcados > 0);
        this.getBotaoDesmarcarTodos().setEnabled(registrosMarcados > 0);
        this.getBotaoMarcarTodos().setEnabled(registrosMarcados < totalRegistros);
    }

    public JPanel getPanelInferior() {
        if (this.panelInferior == null) {
            this.panelInferior = new JPanel();
            this.panelInferior.setLayout(new BorderLayout());
            this.panelInferior.setOpaque(false);
            this.panelInferior.add((Component)this.getTotalRegistros(), "North");
            this.panelInferior.add((Component)this.getPanelBotoes(), "Center");
        }
        return this.panelInferior;
    }

    public JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setOpaque(false);
            this.panelBotoes.setPreferredSize(new Dimension(0, 40));
            FlowLayout flayout = new FlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add(this.getBotaoMarcarTodos());
            this.panelBotoes.add(this.getBotaoDesmarcarTodos());
            this.panelBotoes.add(this.getBotaoAvancar());
            this.panelBotoes.add(this.getBotaoVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBotaoAvancar() {
        if (this.botaoAvancar == null) {
            this.botaoAvancar = this.getBotaoFactory().novoBotao("AVAN\u00c7AR", this.getAvancarGerarRemessaAction());
            this.botaoAvancar.setEnabled(false);
        }
        return this.botaoAvancar;
    }

    private AvancarGerarRemessaAction getAvancarGerarRemessaAction() {
        return this.getActionFactory().novoAvancarGerarRemessaAction();
    }

    public void preExecucaoAvancarGerarRemessaAction() {
        this.popularFormSelecionados();
    }

    private void popularFormSelecionados() {
        this.getConsultarRemessaGerarForm().setListaRemessasSelecionados(this.getTableModel().getItensSelecionados());
    }

    public void posExecucaoAvancarGerarRemessaAction() {
        this.getContext().put("to", this.getConsultarRemessaGerarForm().getDecoratorGerarRemessa());
        this.getContext().put("colecao", this.getConsultarRemessaGerarForm().getListaRemessasSelecionados());
        ViewController.getInstance().goToView("GACGERARREMESSAPROCESSAR", this.getContext());
    }

    public BBJButton getBotaoDesmarcarTodos() {
        if (this.botaoDesmarcarTodos == null) {
            this.botaoDesmarcarTodos = new BBJButton("DESMARCAR TODOS");
            this.botaoDesmarcarTodos.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerarRemessa.this.marcarTodosRegistros(false);
                    ViewGerarRemessa.this.habilitarBotoes();
                }
            });
        }
        return this.botaoDesmarcarTodos;
    }

    public BBJButton getBotaoMarcarTodos() {
        if (this.botaoMarcarTodos == null) {
            this.botaoMarcarTodos = new BBJButton("MARCAR TODOS");
            this.botaoMarcarTodos.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerarRemessa.this.marcarTodosRegistros(true);
                    ViewGerarRemessa.this.habilitarBotoes();
                }
            });
        }
        return this.botaoMarcarTodos;
    }

    private void marcarTodosRegistros(boolean selected) {
        this.getTableModel().marcaTodos(selected);
    }

    public BBJButton getBotaoVoltar() {
        if (this.botaoVoltar == null) {
            this.botaoVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.botaoVoltar;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(this.getContext());
    }

    public Map getContext() {
        if (!UtilObjeto.isReferencia(this.context)) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        this.getConsultarRemessaGerarForm().setTipoOrdenacao("ASC");
        this.getConsultarRemessaGerarForm().setPaginaAtual(1);
        this.getPaginacao().setValorMaximo(1);
        this.getPanelCheckBox().getChkPagamento().setSelected(false);
        this.getConsultarRemessaGerarForm().setPagamento(false);
        this.getPanelCheckBox().getChkServico().setSelected(false);
        this.getConsultarRemessaGerarForm().setServico(false);
        this.getPanelCheckBox().getChkRecebimento().setSelected(true);
        this.getConsultarRemessaGerarForm().setRecebimento(true);
        this.getPanelCheckBox().getChkPagamento().requestFocus();
        this.atualizaTabela();
        this.repaint();
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
    }

    public ConsultarRemessaGerarForm getConsultarRemessaGerarForm() {
        return (ConsultarRemessaGerarForm)this.getForm();
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoConsultarRemessaGerarForm();
    }

    public BBJPaginacao getPaginacao() {
        if (this.paginacao == null) {
            this.paginacao = new BBJPaginacao();
            this.paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ViewGerarRemessa.this.getConsultarRemessaGerarForm().setPaginaAtual((Integer)evt.getNewValue());
                    ViewGerarRemessa.this.atualizaTabela();
                }
            });
        }
        return this.paginacao;
    }

    public void setPaginacao(BBJPaginacao paginacao) {
        this.paginacao = paginacao;
    }
}

