/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.form;

import br.com.bb.plugins.gac.factory.PluginValidadorFactory;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.bb.plugins.gac.util.Log;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.bean.ValidacaoBean;
import br.com.bb.plugins.gac.util.validadores.PluginValidadorAbstrato;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.comparador.UtilComparadorDeDataMaior;
import br.com.politec.generico.conversor.UtilConversorDeBoolean;
import br.com.politec.generico.conversor.UtilConversorDeData;
import br.com.politec.generico.conversor.UtilConversorDeDouble;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.conversor.UtilConversorDeLong;
import br.com.politec.generico.conversor.UtilConversorDeTime;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.fabrica.NumeroFactory;
import br.com.politec.generico.formatador.UtilFormatadorDeCEP;
import br.com.politec.generico.formatador.UtilFormatadorDeCNPJ;
import br.com.politec.generico.formatador.UtilFormatadorDeCPF;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import br.com.politec.generico.formatador.UtilFormatadorDeInteiro;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeStringsIguais;
import br.com.politec.reflexao.UtilReflexaoGet;
import br.com.politec.reflexao.exception.ReflexaoException;
import java.io.File;
import java.io.Serializable;
import java.sql.Time;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginFormAbstrato
implements Serializable {
    private Collection<ValidacaoBean> colecaoMensagensDeValidacao;
    private boolean permitirValidacao = true;
    private int tipoTela;
    private Integer totalDeRegistros;

    public boolean isValidado() {
        boolean validado = true;
        if (this.isPermitirValidacao()) {
            this.getColecaoMensagensDeValidacao().clear();
            this.doCarregarValidadores();
            validado = UtilColecao.isVazio(this.getColecaoMensagensDeValidacao());
        }
        return validado;
    }

    public void adicionarValidadorDeTamanho(String propriedade, String msg) {
        Object valor = this.getValor(propriedade);
        if (valor != null && (Integer)valor > 25) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio("N\u00e3o retirar");
            this.adicionarValidador(propriedade, msg);
        }
    }

    public void adicionarValidadorDeTamanhoString(String propriedade, String msg, int tamanho) {
        Object valor = this.getValor(propriedade);
        if (valor != null && ((String)valor).toString().length() <= tamanho) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio("N\u00e3o retirar");
            this.adicionarValidador(propriedade, msg);
        }
    }

    protected void doCarregarValidadores() {
    }

    protected void adicionarValidadorDeObrigatoriedadeParaString(String propriedade, String nome) {
        Object valor = this.getValor(propriedade);
        if (!this.isReferencia(valor) || UtilObjeto.isString(valor) && UtilString.isVazio((String)valor)) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
            this.adicionarValidador(propriedade, mensagem);
        }
    }

    protected void adicionarValidadorDeExistenciaDeFile(String propriedade) {
        Object valor = this.getValor(propriedade);
        File file = new File(valor.toString());
        if (!file.exists()) {
            this.adicionarValidador(propriedade, "Diret\u00f3rio inv\u00e1lido");
        }
    }

    protected void adicionarValidadorDeObrigatoriedadeParaString(Map<String, String> mapaCampos) {
        boolean preencheu = false;
        StringBuffer nomesCampos = null;
        String nomeCampo = "";
        for (String campo : mapaCampos.keySet()) {
            Object valor = this.getValor(campo);
            if (this.isReferencia(valor) && UtilObjeto.isString(valor) && !UtilString.isVazio((String)valor)) {
                preencheu = true;
                break;
            }
            if (nomesCampos == null) {
                nomesCampos = new StringBuffer();
                nomeCampo = campo;
            } else {
                nomesCampos.append(" ou ");
            }
            nomesCampos.append(mapaCampos.get(campo));
        }
        if (!preencheu && mapaCampos.size() > 0) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nomesCampos.toString());
            this.adicionarValidador(nomeCampo, mensagem);
        }
    }

    protected void adicionarValidadorDeDigitoContaCorrente(String propriedadeConta, String propriedadeDigito, String mensagemKey) {
        String digito;
        String numeroConta = UtilString.getString(this.getValor(propriedadeConta));
        if (!UtilString.isVazio(numeroConta, digito = UtilString.getString(this.getValor(propriedadeDigito))) && !CalculaDigitoVerificador.verificaContaCorrente(numeroConta, digito)) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(propriedadeConta, mensagem);
        }
    }

    protected void adicionarValidadorDesenhasiguaisString(String propriedade, String senhaAtual, String senhaNova, String confirmacao) {
        if (senhaAtual.trim().toLowerCase().equals(senhaNova.toLowerCase()) && senhaAtual.toLowerCase().trim().equals(confirmacao.toLowerCase())) {
            this.adicionarValidador(propriedade, UtilMensagem.getInstancia().getMensagem("MN016"));
        }
    }

    protected void adicionarValidadorDeObrigatoriedadeParaDouble(String propriedade, String nome) {
        Object valor = this.getValor(propriedade);
        if (!this.isReferencia(valor) || valor instanceof Number && ((Number)valor).doubleValue() == 0.0) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
            this.adicionarValidador(propriedade, mensagem);
        }
    }

    protected void adicionarValidadorDeObrigatoriedadeParaInteiro(String propriedade, String nome) {
        Object valor = this.getValor(propriedade);
        if (!this.isReferencia(valor) || valor instanceof Number && ((Number)valor).intValue() == 0) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
            this.adicionarValidador(propriedade, mensagem);
        }
    }

    protected void adicionarValidadorDeObrigatoriedadeParaObjeto(String propriedade, String nome) {
        Object valor = this.getValor(propriedade);
        if (valor == null) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
            this.adicionarValidador(propriedade, mensagem);
        }
    }

    protected void adicionarValidadorDeDataFuturaEUtil(String propriedade, String nome) {
        Object valor = this.getValor(propriedade);
        if (valor == null) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
            this.adicionarValidador(propriedade, mensagem);
        } else {
            Date data = (Date)valor;
            Calendar calendAtual = Calendar.getInstance();
            calendAtual.add(5, -1);
            Date dataFim = calendAtual.getTime();
            if (this.isReferencia(data)) {
                if (UtilComparadorDeDataMaior.comparar(data, dataFim) == dataFim) {
                    String mensagem = "A Data informada n\u00e3o pode ser Menor que a Data Atual";
                    this.adicionarValidador(propriedade, mensagem);
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(data);
                    switch (cal.get(7)) {
                        case 1: 
                        case 7: {
                            String mensagem = "A Data informada deve ser um dia \u00fatil";
                            this.adicionarValidador(propriedade, mensagem);
                        }
                    }
                }
            } else {
                String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
                this.adicionarValidador(propriedade, mensagem);
            }
        }
    }

    protected void adicionarValidadorDeObrigatoriedadeParaColecao(String propriedade, String nome) {
        Object valor = this.getValor(propriedade);
        if (!this.isReferencia(valor) || UtilObjeto.isColecao(valor) && UtilColecao.isVazio((Collection)valor)) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
            this.adicionarValidador(propriedade, mensagem);
        }
    }

    protected void adicionarValidadorDeObrigatoriedadeParaColecao(String propriedade) {
        Object valor = this.getValor(propriedade);
        if (UtilObjeto.isColecao(valor) && UtilColecao.isVazio((Collection)valor)) {
            String mensagem = this.getUtilMensagem().getSelecioneUmItemNaLista();
            this.adicionarValidador(propriedade, mensagem);
        }
    }

    protected void adicionarValidadorDeIgualdade(String propriedade0, String propriedade1, String mensagemKey) {
        String string1;
        String string0 = UtilString.getString(this.getValor(propriedade0));
        if (UtilString.isStringsIguais(string0, string1 = UtilString.getString(this.getValor(propriedade1)))) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(propriedade1, mensagem);
        }
    }

    protected void adicionarValidadorDeIgualdadeString(String string0, String string1, String mensagemKey) {
        if (UtilString.isStringsIguais(string0, string1)) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(string1, mensagem);
        }
    }

    protected void adicionarValidadorDeDiferente(String propriedade0, String propriedade1, String mensagemKey) {
        String string1;
        String string0 = UtilString.getString(this.getValor(propriedade0));
        if (!UtilString.isStringsIguais(string0, string1 = UtilString.getString(this.getValor(propriedade1)))) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(propriedade0, mensagem);
        }
    }

    protected void adicionarValidadorDeAgencia(String propriedadeAgencia, String propriedadeDigito, String mensagemKey) {
        String digito;
        String agencia = UtilString.getString(this.getValor(propriedadeAgencia));
        if (!UtilString.isVazio(agencia, digito = UtilString.getString(this.getValor(propriedadeDigito))) && !CalculaDigitoVerificador.verificaAgencia(agencia, digito)) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(propriedadeAgencia, mensagem);
        }
    }

    protected void adicionarValidadorDeCEP(String propriedadeCEP, String mensagemKey) {
        String cep = UtilString.getString(this.getValor(propriedadeCEP));
        if (UtilString.isVazio(cep = cep.replace("-", "").trim()) || cep.length() < 8) {
            String mensagem = "Campo CEP de preenchimento obrigat\u00f3rio";
            this.adicionarValidador(propriedadeCEP, mensagem);
        }
    }

    protected void adicionarValidador(PluginValidadorAbstrato validador, String propriedade, String mensagem, String propriedadeFoco) {
        Object valor = this.getValor(propriedade);
        if (!validador.isValido(valor)) {
            this.adicionarValidador(propriedadeFoco, mensagem);
        }
    }

    protected void adicionarValidador(PluginValidadorAbstrato validador, String propriedade, String mensagem) {
        Object valor = this.getValor(propriedade);
        if (!validador.isValido(valor)) {
            this.adicionarValidador(propriedade, mensagem);
        }
    }

    protected void adicionarValidadorDeStringMaiorIgualSeNaoVazio(String propriedade0, String propriedade1, String mensagemKey) {
        String string0 = UtilString.getString(this.getValor(propriedade0));
        String string1 = UtilString.getString(this.getValor(propriedade1));
        if (!UtilString.isVazio(string1) && string0.compareToIgnoreCase(string1) > 0) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(propriedade1, mensagem);
        }
    }

    protected void adicionarValidadorDeDataMaiorIgualSeValida(String propriedade0, String propriedade1, String mensagemKey) {
        Date dataIni = (Date)this.getValor(propriedade0);
        Date dataFim = (Date)this.getValor(propriedade1);
        if (this.isReferencia(dataIni) && this.isReferencia(dataFim) && UtilComparadorDeDataMaior.comparar(dataIni, dataFim) == dataIni) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(propriedade1, mensagem);
        }
    }

    protected void adicionarValidadorDeDataValida(String propriedade, String mensagemKey) {
        Date dataInformada = (Date)this.getValor(propriedade);
        if (!this.isReferencia(dataInformada)) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(propriedade, mensagem);
        }
    }

    protected void adicionarValidadorDeValorMaiorIgualSeValido(String propriedade0, String propriedade1, String mensagemKey) {
        Float valorInicial = (Float)this.getValor(propriedade0);
        Float valorFinal = (Float)this.getValor(propriedade1);
        if (this.isReferencia(valorInicial) && this.isReferencia(valorFinal) && valorFinal.doubleValue() < valorInicial.doubleValue()) {
            String mensagem = this.getUtilMensagem().getMensagem(mensagemKey);
            this.adicionarValidador(propriedade1, mensagem);
        }
    }

    public void limpar() {
    }

    protected Collection novoArrayList() {
        return this.getColecaoFactory().novoArrayList();
    }

    protected boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected String formatarCEP(String cep) {
        return UtilFormatadorDeCEP.formatar(cep);
    }

    protected String formatarCNPJ(String cnpj) {
        return UtilFormatadorDeCNPJ.formatar(cnpj);
    }

    protected String formatarCPF(String cpf) {
        return UtilFormatadorDeCPF.formatar(cpf);
    }

    protected String formatarData(Date data) {
        return UtilFormatadorDeData.formatar_ddMMyyyy(data);
    }

    protected String formatarData_hhmm(Date data) {
        return UtilFormatadorDeData.formatar_hhmm(data);
    }

    protected String formatarData(Date data, String pattern) {
        return UtilFormatadorDeData.formatar(data, pattern);
    }

    protected String formatarInteiro(int inteiro) {
        return UtilFormatadorDeInteiro.formatar(inteiro);
    }

    protected String formatarInteiro(Integer inteiro) {
        return UtilFormatadorDeInteiro.formatar(inteiro);
    }

    protected String formatarReal(double real) {
        return UtilFormatadorDeReal.formatar(real);
    }

    protected String formatarReal(Double real) {
        return UtilFormatadorDeReal.formatar(real);
    }

    protected Boolean converterParaBoolean(String boleano) {
        return UtilConversorDeBoolean.converterParaBooleanWrapper(boleano);
    }

    protected Date converterParaData(String data) {
        return UtilConversorDeData.converter_ddMMyyyy(data);
    }

    protected Double converterParaDouble(String real) {
        return UtilConversorDeDouble.converterParaDoubleWrapper(real);
    }

    protected Integer converterParaInteger(String integer) {
        return UtilConversorDeInteger.converterParaInteger(integer);
    }

    protected Long converterParaLong(String valor) {
        return UtilConversorDeLong.converterParaLongWrapper(valor);
    }

    protected Time converterParaTime(String hora, String pattern) {
        return UtilConversorDeTime.converter(hora, pattern);
    }

    protected Integer converterParaInteger(int _int) {
        return UtilConversorDeInteger.converterParaInteger(_int);
    }

    protected int converterParaInt(Integer integer) {
        return UtilConversorDeInteger.converterParaPrimitivo(integer);
    }

    protected String converterParaString(Integer integer) {
        String string = UtilString.getString(integer);
        return UtilValidadorDeStringsIguais.validar(string, "0") ? null : string;
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    protected NumeroFactory getNumeroFactory() {
        return NumeroFactory.getInstance();
    }

    protected Integer novoInteger(int numero) {
        return this.getNumeroFactory().novoInteger(numero);
    }

    protected Integer novoInteger(String numero) {
        if (numero == null || numero.trim().length() == 0) {
            numero = "0";
        }
        return this.getNumeroFactory().novoInteger(numero);
    }

    protected PluginValidadorFactory getValidadorFactory() {
        return PluginValidadorFactory.getInstancia();
    }

    public Collection<ValidacaoBean> getColecaoMensagensDeValidacao() {
        if (!this.isReferencia(this.colecaoMensagensDeValidacao)) {
            this.colecaoMensagensDeValidacao = this.novoArrayList();
        }
        return this.colecaoMensagensDeValidacao;
    }

    protected UtilMensagem getUtilMensagem() {
        return UtilMensagem.getInstancia();
    }

    public boolean isPermitirValidacao() {
        return this.permitirValidacao;
    }

    public void setPermitirValidacao(boolean permitirValidacao) {
        this.permitirValidacao = permitirValidacao;
    }

    protected TOFactory getTOFactory() {
        return TOFactory.getInstancia();
    }

    public int getTipoTela() {
        return this.tipoTela;
    }

    public void setTipoTela(int tipoTela) {
        this.tipoTela = tipoTela;
    }

    public Integer getNumeroDePaginas() {
        Integer totalDeRegistros = 10 - this.getTotalDeRegistros() % 10;
        if (totalDeRegistros == 10) {
            totalDeRegistros = 0;
        }
        totalDeRegistros = totalDeRegistros + this.getTotalDeRegistros();
        return totalDeRegistros / 10;
    }

    public Integer getTotalDeRegistros() {
        return this.totalDeRegistros;
    }

    public void setTotalDeRegistros(Integer totalDeRegistros) {
        this.totalDeRegistros = totalDeRegistros;
    }

    private Object getValor(String propriedade) {
        Object valor = null;
        if (!UtilString.isVazio(propriedade)) {
            try {
                valor = UtilReflexaoGet.get(this, propriedade);
            }
            catch (ReflexaoException e) {
                Log.getInstance().logInfo("N\u00e3o foi poss\u00edvel recuperar o valor do atributo " + propriedade + " do FORM " + UtilObjeto.getNome(this));
                Log.getInstance().logMsg(e);
            }
        }
        return valor;
    }

    public void adicionarValidador(String propriedade, String mensagem) {
        ValidacaoBean vb = new ValidacaoBean();
        vb.setPropriedade(propriedade);
        vb.setMensagem(mensagem);
        this.adicionarValidacaoBean(vb);
    }

    public void adicionarValidacaoBean(ValidacaoBean validacaoBean) {
        this.getColecaoMensagensDeValidacao().add(validacaoBean);
    }

    public PluginTODecoratorAbstrato getTODecoratorParaOrdenacao() {
        return this.getTOFactory().novoPluginTODecoratorAbstrato();
    }

    public String getNomeColunaOrdenada() {
        return this.getTODecoratorParaOrdenacao().getNomeColunaOrdenada();
    }

    public void setNomeColunaOrdenada(String nomeColunaOrdenada) {
        this.getTODecoratorParaOrdenacao().setNomeColunaOrdenada(nomeColunaOrdenada);
    }

    public String getTipoOrdenacao() {
        return this.getTODecoratorParaOrdenacao().getTipoOrdenacao();
    }

    public void setTipoOrdenacao(String tipoOrdenacao) {
        this.getTODecoratorParaOrdenacao().setTipoOrdenacao(tipoOrdenacao);
    }

    public void setDado(Object dado) {
    }

    protected void adicionarValidadorDeArquivo(String propriedade, String nome) {
        Object valor = this.getValor(propriedade);
        if (valor == null) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
            this.adicionarValidador(propriedade, mensagem);
        } else {
            File arquivo = new File((String)valor);
            if (this.isReferencia(arquivo)) {
                if (!arquivo.isFile()) {
                    String mensagem = "O arquivo informado est\u00e1 inv\u00e1lido.";
                    this.adicionarValidador(propriedade, mensagem);
                }
            } else {
                String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
                this.adicionarValidador(propriedade, mensagem);
            }
        }
    }

    protected void adicinarValidadorSemBarraInvertidaNoInicio(String propriedade, String nome) {
        Object valor = this.getValor(propriedade);
        if (!this.isReferencia(valor) || UtilObjeto.isString(valor) && valor.toString().startsWith("\\")) {
            String mensagem = "Informe apenas o Nome ou IP do servidor sem caracteres especiais.";
            this.adicionarValidador(propriedade, mensagem);
        }
    }
}

