/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.action;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.form.ListarCadastroPessoaForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaFacade;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaFisicaFacade;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaJuridicaFacade;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.bb.plugins.gac.util.objecttablemodel.DadosCadastro;
import br.com.bb.plugins.gac.util.swing.IActionMultiThread;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprimirCadastroPessoaAction
extends PluginActionAbstrato
implements IActionMultiThread {
    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ManterCadastroPessoaFacade facade = this.getFacadeFactory().novoManterCadastroPessoaFacade();
        ListarCadastroPessoaForm listarCadastroPessoaForm = (ListarCadastroPessoaForm)form;
        if (listarCadastroPessoaForm.getColecaoDadosCadastrados() != null && listarCadastroPessoaForm.getColecaoDadosCadastrados().size() > 0) {
            ArrayList<PessoaTO> listaBasicaPessoa = new ArrayList<PessoaTO>(listarCadastroPessoaForm.getColecaoDadosCadastrados().size());
            ArrayList<ComplementoPessoaFisicaTO> listaPessoaFisicaTOs = new ArrayList<ComplementoPessoaFisicaTO>(listarCadastroPessoaForm.getColecaoDadosCadastrados().size());
            ArrayList<ComplementoPessoaJuridicaTO> listaPessoaJuridicaTOs = new ArrayList<ComplementoPessoaJuridicaTO>(listarCadastroPessoaForm.getColecaoDadosCadastrados().size());
            if (!UtilColecao.isVazio(listarCadastroPessoaForm.getColecaoDadosCadastrados())) {
                PessoaTO pessoaTO = null;
                for (DadosCadastro dadosCadastro : listarCadastroPessoaForm.getColecaoDadosCadastrados()) {
                    PessoaTO to = this.getTOFactory().novoPessoaTO();
                    to.setCodigoPessoa(dadosCadastro.getCodigoPessoa());
                    pessoaTO = facade.consultarPorCodigo(to);
                    listaBasicaPessoa.add(pessoaTO);
                    if (pessoaTO instanceof ComplementoPessoaFisicaTO) {
                        ComplementoPessoaFisicaTO complementoPessoaFisicaTO = (ComplementoPessoaFisicaTO)pessoaTO;
                        listaPessoaFisicaTOs.add(complementoPessoaFisicaTO);
                    }
                    if (!(pessoaTO instanceof ComplementoPessoaJuridicaTO)) continue;
                    ComplementoPessoaJuridicaTO complementoPessoaJuridicaTO = (ComplementoPessoaJuridicaTO)pessoaTO;
                    listaPessoaJuridicaTOs.add(complementoPessoaJuridicaTO);
                }
            }
            listarCadastroPessoaForm.setColecaoPessoaTODecorator(this.converterParaDecorator(listaBasicaPessoa));
            listarCadastroPessoaForm.setComplementoPessoaFisicaTO(listaPessoaFisicaTOs);
            listarCadastroPessoaForm.setComplementoPessoaJuridicaTO(listaPessoaJuridicaTOs);
        } else {
            switch (listarCadastroPessoaForm.getOpcaoRelatorio()) {
                case 1: {
                    this.basicoPessoaTodos(facade, listarCadastroPessoaForm);
                    break;
                }
                case 2: {
                    this.basicoPessoaFisica(facade, listarCadastroPessoaForm);
                    break;
                }
                case 3: {
                    this.basicoPessoaJuridica(facade, listarCadastroPessoaForm);
                    break;
                }
                case 4: {
                    this.completoPessoaFisica(facade, listarCadastroPessoaForm);
                    break;
                }
                case 5: {
                    this.completoPessoJuridico(facade, listarCadastroPessoaForm);
                    break;
                }
            }
        }
        return null;
    }

    private void basicoPessoaJuridica(ManterCadastroPessoaFacade<PluginTOAbstrato> facade, ListarCadastroPessoaForm listarCadastroPessoaForm) {
        ManterCadastroPessoaFisicaFacade manterCadastroPessoaFisicaFacade = this.getFacadeFactory().novoManterCadastroPessoaFisicaFacade();
        PessoaTODecorator pessoaTODecorator = new PessoaTODecorator();
        pessoaTODecorator.setCodigoTipoPessoa(UtilDominioTipoDocumento.CNPJ_PJ);
        Collection<PessoaTO> colecaoPessoaFisicaTO = manterCadastroPessoaFisicaFacade.consultarPor(pessoaTODecorator);
        listarCadastroPessoaForm.setColecaoPessoaTODecorator(this.converterParaDecorator(colecaoPessoaFisicaTO));
    }

    private void completoPessoJuridico(ManterCadastroPessoaFacade<PluginTOAbstrato> facade, ListarCadastroPessoaForm listarCadastroPessoaForm) {
        ManterCadastroPessoaJuridicaFacade facade3 = this.getFacadeFactory().novoManterCadastroPessoaJuridicaFacade();
        Collection<ComplementoPessoaJuridicaTO> colecao3 = facade3.consultarTodosComplementosPJ();
        listarCadastroPessoaForm.setNomeColunaOrdenada("objPessoaTO.textoNome");
        listarCadastroPessoaForm.setComplementoPessoaJuridicaTO(colecao3);
    }

    private void completoPessoaFisica(ManterCadastroPessoaFacade<PluginTOAbstrato> facade, ListarCadastroPessoaForm listarCadastroPessoaForm) {
        ManterCadastroPessoaFisicaFacade facade2 = this.getFacadeFactory().novoManterCadastroPessoaFisicaFacade();
        Collection<ComplementoPessoaFisicaTO> colecao2 = facade2.consultarTodosComplementosPF();
        listarCadastroPessoaForm.setNomeColunaOrdenada("objPessoaTO.textoNome");
        listarCadastroPessoaForm.setComplementoPessoaFisicaTO(colecao2);
    }

    private void basicoPessoaFisica(ManterCadastroPessoaFacade<PluginTOAbstrato> facade, ListarCadastroPessoaForm listarCadastroPessoaForm) {
        ManterCadastroPessoaFisicaFacade manterCadastroPessoaFisicaFacade = this.getFacadeFactory().novoManterCadastroPessoaFisicaFacade();
        PessoaTODecorator pessoaTODecorator = new PessoaTODecorator();
        pessoaTODecorator.setCodigoTipoPessoa(UtilDominioTipoDocumento.CPF_PF);
        Collection<PessoaTO> colecaoPessoaFisicaTO = manterCadastroPessoaFisicaFacade.consultarPor(pessoaTODecorator);
        listarCadastroPessoaForm.setColecaoPessoaTODecorator(this.converterParaDecorator(colecaoPessoaFisicaTO));
    }

    private void basicoPessoaTodos(ManterCadastroPessoaFacade<PluginTOAbstrato> facade, ListarCadastroPessoaForm listarCadastroPessoaForm) {
        listarCadastroPessoaForm.setNomeColunaOrdenada("objPessoaTO.textoNome");
        listarCadastroPessoaForm.getPessoaTODecorator().setPaginaAtual(null);
        Collection<PessoaTO> colecao = facade.consultarColecaoPorIntervaloNomeData(listarCadastroPessoaForm.getPessoaTODecorator());
        listarCadastroPessoaForm.setColecaoPessoaTODecorator(this.converterParaDecorator(colecao));
    }

    private Collection<PessoaTODecorator> converterParaDecorator(Collection<PessoaTO> colecao) {
        ArrayList<PessoaTODecorator> colecaoDecorator = new ArrayList<PessoaTODecorator>();
        for (PessoaTO pessoaTO : colecao) {
            PessoaTODecorator pessoaDecorator = this.getTOFactory().novoPessoaTODecorator();
            pessoaDecorator.setPessoaTO(pessoaTO);
            colecaoDecorator.add(pessoaDecorator);
        }
        return colecaoDecorator;
    }

    private Collection<PessoaTODecorator> converterComplementoPessoaFisicaParaDecorator(Collection<ComplementoPessoaFisicaTO> colecao) {
        ArrayList<PessoaTODecorator> colecaoDecorator = new ArrayList<PessoaTODecorator>();
        for (ComplementoPessoaFisicaTO complementoPessoaFisicaTO : colecao) {
            PessoaTODecorator pessoaDecorator = this.getTOFactory().novoPessoaTODecorator();
            pessoaDecorator.setPessoaTO(complementoPessoaFisicaTO);
            colecaoDecorator.add(pessoaDecorator);
        }
        return colecaoDecorator;
    }
}

