/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.mantercadastropessoafisica.action;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.form.ManterCadastroPessoaForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaFacade;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaFisicaFacade;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.objecttablemodel.DadosCadastro;
import br.com.bb.plugins.gac.util.swing.IActionDeConfirmacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.view.ViewExcluirCadastroLista;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcluirListaCadastroPessoaAction
extends PluginActionAbstrato
implements IActionDeConfirmacao {
    @Override
    public void preExecutar(PluginFormAbstrato form) {
        form.setPermitirValidacao(false);
    }

    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        List<DadosCadastro> colecaoDadosCadastroExcluir = ((ManterCadastroPessoaForm)form).getDadosCadastroExcluir();
        ArrayList<DadosCadastro> colecaoDadosCadastroComErroNaExclusao = new ArrayList<DadosCadastro>(colecaoDadosCadastroExcluir.size());
        for (DadosCadastro dadosCadastro : colecaoDadosCadastroExcluir) {
            try {
                PessoaTO pessoaTOLocal = new PessoaTO();
                pessoaTOLocal.setCodigoPessoa(dadosCadastro.getCodigoPessoa());
                PessoaTO pessoaTO = this.getManterCadastroPessoaFacade().consultarPorCodigo(pessoaTOLocal);
                this.getManterCadastroPessoaFacade().excluir(pessoaTO);
            }
            catch (Exception bbException) {
                colecaoDadosCadastroComErroNaExclusao.add(dadosCadastro);
            }
        }
        if (colecaoDadosCadastroComErroNaExclusao.size() == colecaoDadosCadastroExcluir.size()) {
            this.retiraExcluidoComSucesso(form, colecaoDadosCadastroExcluir, colecaoDadosCadastroComErroNaExclusao);
            BBJPopupMensagem.exibirMensagemErro(UtilMensagem.getInstancia().getMensagem("MP058"));
        } else if (colecaoDadosCadastroComErroNaExclusao.size() > 0) {
            this.retiraExcluidoComSucesso(form, colecaoDadosCadastroExcluir, colecaoDadosCadastroComErroNaExclusao);
            BBJPopupMensagem.exibirMensagemErro(UtilMensagem.getInstancia().getMensagem("MP057"));
        } else {
            BBJPopupMensagem.exibirMensagem(UtilMensagem.getInstancia().getMensagem("MP003"));
        }
        return "";
    }

    private void retiraExcluidoComSucesso(PluginFormAbstrato form, List<DadosCadastro> colecaoDadosCadastro, List<DadosCadastro> colecaoDadosCadastroComErroNaExclusao) {
        colecaoDadosCadastro.retainAll(colecaoDadosCadastroComErroNaExclusao);
        ManterCadastroPessoaForm manterCadastroPessoaForm = (ManterCadastroPessoaForm)form;
        manterCadastroPessoaForm.setDadosCadastroExcluir(colecaoDadosCadastro);
        ViewExcluirCadastroLista viewExcluirCadastroLista = (ViewExcluirCadastroLista)manterCadastroPessoaForm.getView();
        viewExcluirCadastroLista.consultarPessoa();
    }

    private ManterCadastroPessoaFisicaFacade getManterCadastroPessoaFisicaFacade() {
        return this.getFacadeFactory().novoManterCadastroPessoaFisicaFacade();
    }

    private ManterCadastroPessoaFacade<PluginTOAbstrato> getManterCadastroPessoaFacade() {
        return this.getFacadeFactory().novoManterCadastroPessoaFacade();
    }

    @Override
    public String getMensagemDeConfirmacao() {
        return this.getUtilMensagem().getMensagem("MN002");
    }
}

